/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.genesis;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.eth.AccountState;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Block;
import org.apache.tuweni.eth.BlockBody;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.trie.MerklePatriciaTrie;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt64;
import org.apache.tuweni.units.ethereum.Gas;
import org.apache.tuweni.units.ethereum.Wei;

public class GenesisFile {
    private final Bytes nonce;
    private final UInt256 difficulty;
    private final Hash mixhash;
    private final Address coinbase;
    private final Instant timestamp;
    private final Bytes extraData;
    private final Gas gasLimit;
    private final Map<Address, Wei> allocs;
    private final int chainId;
    private final List<Long> forks;

    public GenesisFile(String nonce, String difficulty, String mixhash, String coinbase, String timestamp, String extraData, String gasLimit, String parentHash, Map<String, String> allocs, int chainId, List<Long> forks) {
        if (nonce == null) {
            throw new IllegalArgumentException("nonce must be provided");
        }
        if (difficulty == null) {
            throw new IllegalArgumentException("difficulty must be provided");
        }
        if (mixhash == null) {
            throw new IllegalArgumentException("mixhash must be provided");
        }
        if (coinbase == null) {
            throw new IllegalArgumentException("coinbase must be provided");
        }
        if (timestamp == null) {
            throw new IllegalArgumentException("timestamp must be provided");
        }
        if (extraData == null) {
            throw new IllegalArgumentException("extraData must be provided");
        }
        if (gasLimit == null) {
            throw new IllegalArgumentException("gasLimit must be provided");
        }
        this.nonce = Bytes.fromHexStringLenient((CharSequence)nonce);
        this.difficulty = UInt256.fromHexString((String)difficulty);
        this.mixhash = Hash.fromHexString(mixhash);
        this.coinbase = Address.fromHexString(coinbase);
        this.timestamp = "0x0".equals(timestamp) ? Instant.ofEpochSecond(0L) : Instant.ofEpochSecond(Bytes.fromHexStringLenient((CharSequence)timestamp).toLong());
        this.extraData = Bytes.fromHexString((CharSequence)extraData);
        this.gasLimit = Gas.valueOf((long)Bytes.fromHexStringLenient((CharSequence)gasLimit).toLong());
        this.allocs = new HashMap<Address, Wei>();
        for (Map.Entry<String, String> entry : allocs.entrySet()) {
            Address addr = null;
            try {
                addr = Address.fromHexString(entry.getKey());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid address " + entry.getKey(), e);
            }
            Wei value = null;
            if (entry.getValue().startsWith("0x")) {
                try {
                    value = Wei.valueOf((UInt256)UInt256.fromHexString((String)entry.getValue()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid balance " + entry.getValue(), e);
                }
            }
            try {
                value = Wei.valueOf((UInt256)UInt256.valueOf((BigInteger)new BigInteger(entry.getValue())));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid balance " + entry.getValue(), e);
            }
            this.allocs.put(addr, value);
        }
        this.chainId = chainId;
        this.forks = forks;
    }

    public static GenesisFile read(byte[] contents) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(contents);
        int chainId = 0;
        String nonce = null;
        String difficulty = null;
        String mixhash = null;
        String coinbase = null;
        String timestamp = null;
        String extraData = null;
        String gasLimit = null;
        String parentHash = null;
        Map<String, String> allocs = null;
        TreeSet<Long> collectedForks = new TreeSet<Long>();
        while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            if (!JsonToken.FIELD_NAME.equals((Object)jsonToken)) continue;
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("nonce".equalsIgnoreCase(fieldName)) {
                nonce = parser.getValueAsString();
                continue;
            }
            if ("difficulty".equalsIgnoreCase(fieldName)) {
                difficulty = parser.getValueAsString();
                continue;
            }
            if ("mixHash".equalsIgnoreCase(fieldName)) {
                mixhash = parser.getValueAsString();
                continue;
            }
            if ("coinbase".equalsIgnoreCase(fieldName)) {
                coinbase = parser.getValueAsString();
                continue;
            }
            if ("gasLimit".equalsIgnoreCase(fieldName)) {
                gasLimit = parser.getValueAsString();
                continue;
            }
            if ("timestamp".equalsIgnoreCase(fieldName)) {
                timestamp = parser.getValueAsString();
                continue;
            }
            if ("extraData".equalsIgnoreCase(fieldName)) {
                extraData = parser.getValueAsString();
                continue;
            }
            if ("parentHash".equalsIgnoreCase(fieldName)) {
                parentHash = parser.getValueAsString();
                continue;
            }
            if ("alloc".equalsIgnoreCase(fieldName)) {
                allocs = GenesisFile.readAlloc(parser);
                continue;
            }
            if ("chainId".equalsIgnoreCase(fieldName)) {
                chainId = parser.getValueAsInt();
                continue;
            }
            if (!fieldName.contains("Block")) continue;
            collectedForks.add(parser.getValueAsLong());
        }
        ArrayList<Long> forks = new ArrayList<Long>(collectedForks);
        Collections.sort(forks);
        return new GenesisFile(nonce, difficulty, mixhash, coinbase, timestamp, extraData, gasLimit, parentHash, allocs, chainId, forks);
    }

    private static Map<String, String> readAlloc(JsonParser parser) throws IOException {
        HashMap<String, String> allocs = new HashMap<String, String>();
        String name = null;
        String value = null;
        int depth = 1;
        while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            if (JsonToken.FIELD_NAME.equals((Object)jsonToken)) {
                String fieldName = parser.getCurrentName();
                if ("balance".equals(fieldName)) {
                    parser.nextToken();
                    value = parser.getValueAsString();
                    allocs.put(name, value);
                    name = null;
                    continue;
                }
                if (depth != 1) continue;
                name = parser.getValueAsString();
                continue;
            }
            if (JsonToken.END_OBJECT.equals((Object)jsonToken)) {
                if (--depth != 0) continue;
                return allocs;
            }
            if (!JsonToken.START_OBJECT.equals((Object)jsonToken)) continue;
            ++depth;
        }
        return allocs;
    }

    public Block toBlock() {
        Hash emptyListHash = Hash.hash(RLP.encodeList(writer -> {}));
        Hash emptyHash = Hash.hash(RLP.encode(writer -> writer.writeValue(Bytes.EMPTY)));
        Hash empty = Hash.hash(Bytes.EMPTY);
        MerklePatriciaTrie stateTree = new MerklePatriciaTrie(AccountState::toBytes);
        ArrayList<AsyncCompletion> futures = new ArrayList<AsyncCompletion>();
        for (Map.Entry<Address, Wei> entry : this.allocs.entrySet()) {
            AccountState accountState = new AccountState(UInt256.ZERO, entry.getValue(), emptyHash, empty);
            futures.add(stateTree.putAsync((Bytes)Hash.hash((Bytes)entry.getKey()), (Object)accountState));
        }
        try {
            AsyncCompletion.allOf(futures).join(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Creating the account states took more than 10 seconds.");
        }
        return new Block(new BlockHeader(null, emptyListHash, this.coinbase, Hash.fromBytes(stateTree.rootHash()), emptyHash, emptyHash, Bytes.wrap((byte[])new byte[256]), this.difficulty, UInt256.ZERO, this.gasLimit, Gas.valueOf((long)0L), this.timestamp, this.extraData, this.mixhash, UInt64.fromBytes((Bytes)this.nonce)), new BlockBody(new ArrayList<Transaction>(), new ArrayList<BlockHeader>()));
    }

    public Map<Address, Wei> getAllocations() {
        return this.allocs;
    }

    public List<Long> getForks() {
        return this.forks;
    }

    public int getChainId() {
        return this.chainId;
    }
}

