/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;

public final class BlockBody {
    private final List<Transaction> transactions;
    private final List<BlockHeader> ommers;

    public static BlockBody fromBytes(Bytes encoded) {
        Objects.requireNonNull(encoded);
        return (BlockBody)RLP.decodeList((Bytes)encoded, BlockBody::readFrom);
    }

    public static BlockBody readFrom(RLPReader reader) {
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        reader.readList((listReader, l) -> {
            while (!listReader.isComplete()) {
                txs.add((Transaction)listReader.readList(Transaction::readFrom));
            }
        });
        ArrayList<BlockHeader> ommers = new ArrayList<BlockHeader>();
        reader.readList((listReader, l) -> {
            while (!listReader.isComplete()) {
                ommers.add((BlockHeader)listReader.readList(BlockHeader::readFrom));
            }
        });
        return new BlockBody(txs, ommers);
    }

    public BlockBody(List<Transaction> transactions, List<BlockHeader> ommers) {
        Objects.requireNonNull(transactions);
        Objects.requireNonNull(ommers);
        this.transactions = transactions;
        this.ommers = ommers;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public List<BlockHeader> getOmmers() {
        return this.ommers;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockBody)) {
            return false;
        }
        BlockBody other = (BlockBody)obj;
        return this.transactions.equals(other.transactions) && this.ommers.equals(other.ommers);
    }

    public int hashCode() {
        return Objects.hash(this.transactions, this.ommers);
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::writeTo);
    }

    public String toString() {
        return "BlockBody{transactions=" + this.transactions + ", ommers=" + this.ommers + "}";
    }

    public void writeTo(RLPWriter writer) {
        writer.writeList(listWriter -> {
            for (Transaction tx : this.transactions) {
                listWriter.writeList(tx::writeTo);
            }
        });
        writer.writeList(listWriter -> {
            for (BlockHeader ommer : this.ommers) {
                listWriter.writeList(ommer::writeTo);
            }
        });
    }
}

