/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.DelegatingBytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.units.bigints.UInt256;

public final class Address
extends DelegatingBytes {
    public static final Address ZERO = Address.fromBytes(Bytes.repeat((byte)0, (int)20));
    private static final int SIZE = 20;

    public static Address fromSenderAndNonce(Address sender, UInt256 nonce) {
        Bytes encoded = RLP.encodeList(writer -> {
            writer.writeValue((Bytes)sender);
            writer.writeValue(nonce.toMinimalBytes());
        });
        return Address.fromBytes(Hash.hash(encoded).slice(12));
    }

    public static Address fromTransaction(Transaction transaction) {
        if (transaction.getSender() == null) {
            throw new IllegalArgumentException("Invalid transaction signature, cannot recover sender");
        }
        return Address.fromSenderAndNonce(transaction.getSender(), transaction.getNonce());
    }

    public static Address fromPublicKey(SECP256K1.PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        return Address.fromPublicKeyBytes(publicKey.bytes());
    }

    public static Address fromPublicKeyBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        Bytes32 value = org.apache.tuweni.crypto.Hash.keccak256((Bytes)bytes);
        return new Address(value.slice(12));
    }

    public static Address fromBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        if (bytes.size() != 20) {
            throw new IllegalArgumentException(String.format("Expected %s bytes but got %s", 20, bytes.size()));
        }
        return new Address(bytes);
    }

    public static Address fromHexString(String str) {
        return Address.fromBytes(Bytes.fromHexString((CharSequence)str));
    }

    private Address(Bytes value) {
        super(value);
    }
}

