/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.eth.ForkInfo;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\b\u0010\t\u001a\u00020\u0003H&J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH&J\b\u0010\u000f\u001a\u00020\u0005H&J\b\u0010\u0010\u001a\u00020\u0005H&\u00a8\u0006\u0011"}, d2={"Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;", "", "bestHash", "Lorg/apache/tuweni/eth/Hash;", "bestNumber", "Lorg/apache/tuweni/units/bigints/UInt256;", "forks", "", "", "genesisHash", "getForkHashes", "Lorg/apache/tuweni/bytes/Bytes;", "getLastestApplicableFork", "Lorg/apache/tuweni/devp2p/eth/ForkInfo;", "number", "networkID", "totalDifficulty", "devp2p-eth"})
public interface BlockchainInformation {
    @NotNull
    public UInt256 networkID();

    @NotNull
    public UInt256 totalDifficulty();

    @NotNull
    public Hash bestHash();

    @NotNull
    public UInt256 bestNumber();

    @NotNull
    public Hash genesisHash();

    @NotNull
    public List<Long> forks();

    @NotNull
    public List<Bytes> getForkHashes();

    @NotNull
    public ForkInfo getLastestApplicableFork(long var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static List<Bytes> getForkHashes(@NotNull BlockchainInformation this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            CRC32 crc = new CRC32();
            crc.update(this_.genesisHash().toArrayUnsafe());
            ArrayList<Bytes> forkHashes = new ArrayList<Bytes>(CollectionsKt.listOf((Object)Bytes.ofUnsignedInt((long)crc.getValue())));
            Iterator<Long> iterator = this_.forks().iterator();
            while (iterator.hasNext()) {
                long fork = ((Number)iterator.next()).longValue();
                Bytes byteRepresentationFork = UInt64.valueOf((long)fork).toBytes();
                crc.update(byteRepresentationFork.toArrayUnsafe(), 0, byteRepresentationFork.size());
                forkHashes.add(Bytes.ofUnsignedInt((long)crc.getValue()));
            }
            return forkHashes;
        }
    }
}

