/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Identity;

final class SECP256K1KeyPairIdentity
implements Identity {
    private final SECP256K1.KeyPair keyPair;

    SECP256K1KeyPairIdentity(SECP256K1.KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    public Bytes sign(Bytes message) {
        return SECP256K1.sign((Bytes)message, (SECP256K1.KeyPair)this.keyPair).bytes();
    }

    @Override
    public boolean verify(Bytes signature, Bytes message) {
        return SECP256K1.verify((Bytes)message, (SECP256K1.Signature)SECP256K1.Signature.fromBytes((Bytes)signature), (SECP256K1.PublicKey)this.keyPair.publicKey());
    }

    @Override
    public String publicKeyAsBase64String() {
        return this.keyPair.publicKey().bytes().toBase64String();
    }

    @Override
    public Identity.Curve curve() {
        return Identity.Curve.SECP256K1;
    }

    @Override
    public Signature.PublicKey ed25519PublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SECP256K1.PublicKey secp256k1PublicKey() {
        return this.keyPair.publicKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SECP256K1KeyPairIdentity identity = (SECP256K1KeyPairIdentity)o;
        return this.keyPair.equals((Object)identity.keyPair);
    }

    public int hashCode() {
        return Objects.hash(this.keyPair);
    }

    public String toString() {
        return this.toCanonicalForm();
    }
}

