/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.net.InetSocketAddress;

@VertxGen
public interface SocketAddress {
    public static SocketAddress inetSocketAddress(int port, String host) {
        return new SocketAddressImpl(port, host);
    }

    public static SocketAddress domainSocketAddress(String path) {
        return new SocketAddressImpl(path);
    }

    @GenIgnore(value={"permitted-type"})
    public static SocketAddress inetSocketAddress(InetSocketAddress address) {
        return new SocketAddressImpl(address);
    }

    @CacheReturn
    public String host();

    @CacheReturn
    public String hostName();

    @CacheReturn
    public String hostAddress();

    @CacheReturn
    public int port();

    @CacheReturn
    public String path();

    @CacheReturn
    public boolean isInetSocket();

    @CacheReturn
    public boolean isDomainSocket();
}

