/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx.wire;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlpx.wire.DisconnectReason;
import org.apache.tuweni.rlpx.wire.WireProtocolMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DisconnectMessage
implements WireProtocolMessage {
    private static final Logger logger = LoggerFactory.getLogger(DisconnectMessage.class);
    private final DisconnectReason reason;

    static DisconnectMessage read(Bytes data) {
        try {
            return (DisconnectMessage)RLP.decode((Bytes)data, reader -> {
                if (reader.nextIsList()) {
                    return (DisconnectMessage)reader.readList(source -> new DisconnectMessage(source.readInt()));
                }
                return new DisconnectMessage(DisconnectReason.NOT_PROVIDED);
            });
        }
        catch (RLPException e) {
            logger.warn("Error reading disconnect message " + data.toHexString(), (Throwable)e);
            return new DisconnectMessage(DisconnectReason.NOT_PROVIDED);
        }
    }

    DisconnectMessage(int reason) {
        this(DisconnectReason.valueOf(reason));
    }

    DisconnectMessage(DisconnectReason reason) {
        this.reason = reason;
    }

    @Override
    public Bytes toBytes() {
        return RLP.encodeList(writer -> writer.writeInt(this.reason.code));
    }

    @Override
    public int messageType() {
        return 1;
    }

    int reason() {
        return this.reason.code;
    }

    DisconnectReason disconnectReason() {
        return this.reason;
    }

    public String toString() {
        return "DisconnectMessage reason=" + this.reason.text;
    }
}

