/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlpx.HandshakeMessage;

final class InitiatorHandshakeMessage
implements HandshakeMessage {
    static final int VERSION = 4;
    private final SECP256K1.PublicKey publicKey;
    private final SECP256K1.Signature signature;
    private final SECP256K1.PublicKey ephemeralPublicKey;
    private final Bytes32 nonce;

    private InitiatorHandshakeMessage(SECP256K1.PublicKey publicKey, SECP256K1.Signature signature, SECP256K1.PublicKey ephemeralPublicKey, Bytes32 nonce) {
        this.publicKey = publicKey;
        this.signature = signature;
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.nonce = nonce;
    }

    static InitiatorHandshakeMessage create(SECP256K1.PublicKey ourPubKey, SECP256K1.KeyPair ephemeralKeyPair, Bytes32 staticSharedSecret, Bytes32 nonce) {
        Bytes32 toSign = staticSharedSecret.xor(nonce);
        return new InitiatorHandshakeMessage(ourPubKey, SECP256K1.signHashed((Bytes32)toSign, (SECP256K1.KeyPair)ephemeralKeyPair), ephemeralKeyPair.publicKey(), nonce);
    }

    static InitiatorHandshakeMessage decode(Bytes payload, SECP256K1.SecretKey privateKey) {
        return (InitiatorHandshakeMessage)RLP.decodeList((Bytes)payload, reader -> {
            SECP256K1.Signature signature = SECP256K1.Signature.fromBytes((Bytes)reader.readValue());
            SECP256K1.PublicKey pubKey = SECP256K1.PublicKey.fromBytes((Bytes)reader.readValue());
            Bytes32 nonce = Bytes32.wrap((Bytes)reader.readValue());
            Bytes32 staticSharedSecret = SECP256K1.calculateKeyAgreement((SECP256K1.SecretKey)privateKey, (SECP256K1.PublicKey)pubKey);
            Bytes32 toSign = staticSharedSecret.xor(nonce);
            SECP256K1.PublicKey ephemeralPublicKey = SECP256K1.PublicKey.recoverFromHashAndSignature((Bytes32)toSign, (SECP256K1.Signature)signature);
            return new InitiatorHandshakeMessage(pubKey, signature, ephemeralPublicKey, nonce);
        });
    }

    Bytes encode() {
        return RLP.encodeList(writer -> {
            writer.writeValue(this.signature.bytes());
            writer.writeValue(this.publicKey.bytes());
            writer.writeValue((Bytes)this.nonce);
            writer.writeInt(4);
        });
    }

    SECP256K1.PublicKey publicKey() {
        return this.publicKey;
    }

    @Override
    public SECP256K1.PublicKey ephemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    @Override
    public Bytes32 nonce() {
        return this.nonce;
    }
}

