/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evmdsl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.evmdsl.Instruction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/evmdsl/Push;", "Lorg/apache/tuweni/evmdsl/Instruction;", "bytes", "Lorg/apache/tuweni/bytes/Bytes;", "(Lorg/apache/tuweni/bytes/Bytes;)V", "bytesToPush", "getBytesToPush", "()Lorg/apache/tuweni/bytes/Bytes;", "stackItemsConsumed", "", "stackItemsProduced", "toBytes", "toString", "", "evm-dsl"})
public final class Push
implements Instruction {
    @NotNull
    private final Bytes bytesToPush;

    public Push(@NotNull Bytes bytes) {
        Bytes bytes2;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.size() > 32) {
            throw new IllegalArgumentException("Push can push at most 32 bytes, " + bytes.size() + " provided");
        }
        if (bytes.isEmpty()) {
            throw new IllegalArgumentException("Push requires at least one byte");
        }
        Bytes trimmedBytes = bytes.trimLeadingZeros();
        if (trimmedBytes.isEmpty()) {
            Bytes bytes3 = Bytes.fromHexString((CharSequence)"0x00");
            Intrinsics.checkNotNullExpressionValue((Object)bytes3, (String)"{\n      Bytes.fromHexString(\"0x00\")\n    }");
            bytes2 = bytes3;
        } else {
            Bytes bytes4 = trimmedBytes;
            Intrinsics.checkNotNullExpressionValue((Object)bytes4, (String)"{\n      trimmedBytes\n    }");
            bytes2 = bytes4;
        }
        this.bytesToPush = bytes2;
    }

    @NotNull
    public final Bytes getBytesToPush() {
        return this.bytesToPush;
    }

    @Override
    @NotNull
    public Bytes toBytes() {
        Bytes[] bytesArray = new Bytes[2];
        byte[] byArray = new byte[]{(byte)(96 + this.bytesToPush.size() - 1)};
        bytesArray[0] = Bytes.of((byte[])byArray);
        bytesArray[1] = this.bytesToPush;
        Bytes bytes = Bytes.wrap((Bytes[])bytesArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"wrap(Bytes.of((0x60 + by\u2026).toByte()), bytesToPush)");
        return bytes;
    }

    @NotNull
    public String toString() {
        return "PUSH " + this.bytesToPush.toHexString();
    }

    @Override
    public int stackItemsConsumed() {
        return 0;
    }

    @Override
    public int stackItemsProduced() {
        return 1;
    }

    @Override
    public int stackItemsNeeded() {
        return Instruction.DefaultImpls.stackItemsNeeded(this);
    }

    @Override
    public boolean end() {
        return Instruction.DefaultImpls.end(this);
    }
}

