/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.trace.SpanLimits;

public final class SpanLimitsBuilder {
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 128;
    private int maxNumAttributes = 128;
    private int maxNumEvents = 128;
    private int maxNumLinks = 128;
    private int maxNumAttributesPerEvent = 128;
    private int maxNumAttributesPerLink = 128;

    SpanLimitsBuilder() {
    }

    public SpanLimitsBuilder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
        Utils.checkArgument((maxNumberOfAttributes > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributes must be greater than 0");
        this.maxNumAttributes = maxNumberOfAttributes;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfEvents(int maxNumberOfEvents) {
        Utils.checkArgument((maxNumberOfEvents > 0 ? 1 : 0) != 0, (String)"maxNumberOfEvents must be greater than 0");
        this.maxNumEvents = maxNumberOfEvents;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfLinks(int maxNumberOfLinks) {
        Utils.checkArgument((maxNumberOfLinks > 0 ? 1 : 0) != 0, (String)"maxNumberOfLinks must be greater than 0");
        this.maxNumLinks = maxNumberOfLinks;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerEvent(int maxNumberOfAttributesPerEvent) {
        Utils.checkArgument((maxNumberOfAttributesPerEvent > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributesPerEvent must be greater than 0");
        this.maxNumAttributesPerEvent = maxNumberOfAttributesPerEvent;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerLink(int maxNumberOfAttributesPerLink) {
        Utils.checkArgument((maxNumberOfAttributesPerLink > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributesPerLink must be greater than 0");
        this.maxNumAttributesPerLink = maxNumberOfAttributesPerLink;
        return this;
    }

    public SpanLimits build() {
        return SpanLimits.create(this.maxNumAttributes, this.maxNumEvents, this.maxNumLinks, this.maxNumAttributesPerEvent, this.maxNumAttributesPerLink);
    }
}

