/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlp;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.rlp.ByteBufferRLPWriter;
import org.apache.tuweni.rlp.BytesRLPReader;
import org.apache.tuweni.rlp.BytesRLPWriter;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;

public final class RLP {
    private static final byte[] EMPTY_VALUE = new byte[]{-128};

    private RLP() {
    }

    public static Bytes encode(Consumer<RLPWriter> fn) {
        Objects.requireNonNull(fn);
        BytesRLPWriter writer = new BytesRLPWriter();
        fn.accept(writer);
        return writer.toBytes();
    }

    public static <T extends ByteBuffer> T encodeTo(T buffer, Consumer<RLPWriter> fn) {
        Objects.requireNonNull(fn);
        ByteBufferRLPWriter writer = new ByteBufferRLPWriter(buffer);
        fn.accept(writer);
        return buffer;
    }

    public static Bytes encodeList(Consumer<RLPWriter> fn) {
        Objects.requireNonNull(fn);
        BytesRLPWriter writer = new BytesRLPWriter();
        writer.writeList(fn);
        return writer.toBytes();
    }

    public static <T> Bytes encodeList(List<T> elements, BiConsumer<RLPWriter, T> fn) {
        Objects.requireNonNull(fn);
        BytesRLPWriter writer = new BytesRLPWriter();
        writer.writeList(elements, fn);
        return writer.toBytes();
    }

    public static <T extends ByteBuffer> T encodeListTo(T buffer, Consumer<RLPWriter> fn) {
        Objects.requireNonNull(fn);
        ByteBufferRLPWriter writer = new ByteBufferRLPWriter(buffer);
        writer.writeList(fn);
        return buffer;
    }

    public static Bytes encodeValue(Bytes value) {
        Objects.requireNonNull(value);
        return RLP.encodeValue(value.toArrayUnsafe());
    }

    public static Bytes encodeByteArray(byte[] value) {
        Objects.requireNonNull(value);
        return RLP.encodeValue(value);
    }

    private static Bytes encodeValue(byte[] value) {
        int maxSize = value.length + 5;
        ByteBuffer buffer = ByteBuffer.allocate(maxSize);
        RLP.encodeByteArray(value, buffer::put);
        return Bytes.wrap((byte[])buffer.array(), (int)0, (int)buffer.position());
    }

    static void encodeByteArray(byte[] value, Consumer<byte[]> appender) {
        byte b;
        Objects.requireNonNull(value);
        int size = value.length;
        if (size == 0) {
            appender.accept(EMPTY_VALUE);
            return;
        }
        if (size == 1 && ((b = value[0]) & 0xFF) <= 127) {
            appender.accept(value);
            return;
        }
        appender.accept(RLP.encodeLength(size, 128));
        appender.accept(value);
    }

    public static Bytes encodeInt(int value) {
        return RLP.encodeLong(value);
    }

    public static Bytes encodeLong(long value) {
        return Bytes.wrap((byte[])RLP.encodeNumber(value));
    }

    static byte[] encodeNumber(long value) {
        if (value == 0L) {
            return EMPTY_VALUE;
        }
        if (value <= 127L) {
            return new byte[]{(byte)(value & 0xFFL)};
        }
        return RLP.encodeLongBytes(value, 128);
    }

    private static byte[] encodeLongBytes(long value, int offset) {
        int zeros = Long.numberOfLeadingZeros(value);
        int resultBytes = 8 - zeros / 8;
        byte[] encoded = new byte[resultBytes + 1];
        encoded[0] = (byte)(offset + resultBytes & 0xFF);
        int shift = 0;
        for (int i = 0; i < resultBytes; ++i) {
            encoded[resultBytes - i] = (byte)(value >> shift & 0xFFL);
            shift += 8;
        }
        return encoded;
    }

    public static Bytes encodeBigInteger(BigInteger value) {
        Objects.requireNonNull(value);
        return RLP.encode(writer -> writer.writeBigInteger(value));
    }

    public static Bytes encodeString(String str) {
        Objects.requireNonNull(str);
        return RLP.encodeByteArray(str.getBytes(StandardCharsets.UTF_8));
    }

    static byte[] encodeLength(int length, int offset) {
        if (length <= 55) {
            return new byte[]{(byte)(offset + length & 0xFF)};
        }
        return RLP.encodeLongBytes(length, offset + 55);
    }

    public static <T> T decode(Bytes source, Function<RLPReader, T> fn) {
        return RLP.decode(source, false, fn);
    }

    public static <T> T decode(Bytes source, boolean lenient, Function<RLPReader, T> fn) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(fn);
        return fn.apply(new BytesRLPReader(source, lenient));
    }

    public static <T> T decodeList(Bytes source, Function<RLPReader, T> fn) {
        return RLP.decodeList(source, false, fn);
    }

    public static <T> T decodeList(Bytes source, boolean lenient, Function<RLPReader, T> fn) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(fn);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("source is empty");
        }
        return (T)RLP.decode(source, lenient, reader -> reader.readList(fn));
    }

    public static List<Object> decodeToList(Bytes source, BiConsumer<RLPReader, List<Object>> fn) {
        return RLP.decodeToList(source, false, fn);
    }

    public static List<Object> decodeToList(Bytes source, boolean lenient, BiConsumer<RLPReader, List<Object>> fn) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(fn);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("source is empty");
        }
        return RLP.decode(source, lenient, reader -> reader.readList(fn));
    }

    public static <T> List<T> decodeToList(Bytes source, Function<RLPReader, T> fn) {
        return RLP.decodeToList(source, false, fn);
    }

    public static <T> List<T> decodeToList(Bytes source, boolean lenient, Function<RLPReader, T> fn) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(fn);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("source is empty");
        }
        return RLP.decode(source, lenient, reader -> reader.readListContents(fn));
    }

    public static Bytes decodeValue(Bytes source) {
        return RLP.decodeValue(source, false);
    }

    public static Bytes decodeValue(Bytes source, boolean lenient) {
        Objects.requireNonNull(source);
        return RLP.decode(source, lenient, RLPReader::readValue);
    }

    public static int decodeInt(Bytes source) {
        return RLP.decodeInt(source, false);
    }

    public static int decodeInt(Bytes source, boolean lenient) {
        Objects.requireNonNull(source);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("source is empty");
        }
        return RLP.decode(source, lenient, RLPReader::readInt);
    }

    public static long decodeLong(Bytes source) {
        return RLP.decodeLong(source, false);
    }

    public static long decodeLong(Bytes source, boolean lenient) {
        Objects.requireNonNull(source);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("source is empty");
        }
        return RLP.decode(source, lenient, RLPReader::readLong);
    }

    public static BigInteger decodeBigInteger(Bytes source) {
        return RLP.decodeBigInteger(source, false);
    }

    public static BigInteger decodeBigInteger(Bytes source, boolean lenient) {
        Objects.requireNonNull(source);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("source is empty");
        }
        return RLP.decode(source, lenient, RLPReader::readBigInteger);
    }

    public static String decodeString(Bytes source) {
        return RLP.decodeString(source, false);
    }

    public static String decodeString(Bytes source, boolean lenient) {
        Objects.requireNonNull(source);
        if (source.isEmpty()) {
            throw new IllegalArgumentException("source is empty");
        }
        return RLP.decode(source, lenient, RLPReader::readString);
    }

    public static boolean isList(Bytes value) {
        Objects.requireNonNull(value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("value is empty");
        }
        return RLP.decode(value, RLPReader::nextIsList);
    }
}

