/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlp;

import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.rlp.EndOfRLPException;
import org.apache.tuweni.rlp.InvalidRLPEncodingException;
import org.apache.tuweni.rlp.InvalidRLPTypeException;
import org.apache.tuweni.rlp.RLPReader;

final class BytesRLPReader
implements RLPReader {
    private final Bytes content;
    private boolean lenient;
    private int index = 0;

    BytesRLPReader(Bytes content, boolean lenient) {
        this.content = content;
        this.lenient = lenient;
    }

    @Override
    public boolean isLenient() {
        return this.lenient;
    }

    @Override
    public Bytes readRemaining() {
        int remaining = this.content.size() - this.index;
        if (remaining == 0) {
            return Bytes.EMPTY;
        }
        return this.content.slice(this.index++, remaining);
    }

    @Override
    public Bytes readValue(boolean lenient) {
        int remaining = this.content.size() - this.index;
        if (remaining == 0) {
            throw new EndOfRLPException();
        }
        int prefix = this.content.get(this.index) & 0xFF;
        if (prefix <= 127) {
            return this.content.slice(this.index++, 1);
        }
        --remaining;
        if (prefix <= 183) {
            int length = prefix - 128;
            if (remaining < length) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + length + " but have only " + remaining);
            }
            Bytes bytes = this.content.slice(this.index + 1, length);
            if (!lenient && length == 1 && (bytes.get(0) & 0xFF) <= 127) {
                throw new InvalidRLPEncodingException("Value should have been encoded as a single byte " + bytes.toHexString());
            }
            this.index += 1 + length;
            return bytes;
        }
        if (prefix <= 191) {
            int lengthOfLength = prefix - 183;
            if (remaining < lengthOfLength) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + lengthOfLength + " but have only " + remaining);
            }
            int length = this.getLength(lengthOfLength, lenient, "value");
            if ((remaining -= lengthOfLength) < length) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + length + " but have only " + remaining);
            }
            this.index += 1 + lengthOfLength;
            Bytes bytes = this.content.slice(this.index, length);
            this.index += length;
            return bytes;
        }
        throw new InvalidRLPTypeException("Attempted to read a value but next item is a list");
    }

    @Override
    public boolean nextIsList() {
        int remaining = this.content.size() - this.index;
        if (remaining == 0) {
            throw new EndOfRLPException();
        }
        int prefix = this.content.get(this.index) & 0xFF;
        return prefix > 191;
    }

    @Override
    public boolean nextIsEmpty() {
        int remaining = this.content.size() - this.index;
        if (remaining == 0) {
            throw new EndOfRLPException();
        }
        int prefix = this.content.get(this.index) & 0xFF;
        return prefix == 128;
    }

    @Override
    public <T> T readList(boolean lenient, Function<RLPReader, T> fn) {
        return fn.apply(new BytesRLPReader(this.readList(lenient), lenient));
    }

    @Override
    public void skipNext(boolean lenient) {
        int remaining = this.content.size() - this.index;
        if (remaining == 0) {
            throw new EndOfRLPException();
        }
        int prefix = this.content.get(this.index) & 0xFF;
        if (prefix <= 127) {
            ++this.index;
            return;
        }
        --remaining;
        if (prefix <= 183) {
            int length = prefix - 128;
            if (remaining < length) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + length + " but have only " + remaining);
            }
            if (!lenient && length == 1 && (this.content.get(this.index + 1) & 0xFF) <= 127) {
                throw new InvalidRLPEncodingException("Value should have been encoded as a single byte " + this.content.slice(this.index + 1, 1).toHexString());
            }
            this.index += 1 + length;
            return;
        }
        if (prefix <= 191) {
            int lengthOfLength = prefix - 183;
            if (remaining < lengthOfLength) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + lengthOfLength + " but have only " + remaining);
            }
            int length = this.getLength(lengthOfLength, lenient, "value");
            if ((remaining -= lengthOfLength) < length) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + length + " but have only " + remaining);
            }
            this.index += 1 + lengthOfLength + length;
            return;
        }
        if (prefix <= 247) {
            int length = prefix - 192;
            if (remaining < length) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + length + " but have only " + remaining);
            }
            this.index += 1 + length;
            return;
        }
        int lengthOfLength = prefix - 247;
        if (remaining < lengthOfLength) {
            throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + lengthOfLength + " but have only " + remaining);
        }
        int length = this.getLength(lengthOfLength, lenient, "list");
        if ((remaining -= lengthOfLength) < length) {
            throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + lengthOfLength + " but have only " + remaining);
        }
        this.index += 1 + lengthOfLength + length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remaining() {
        int oldIndex = this.index;
        try {
            int count = 0;
            while (!this.isComplete()) {
                ++count;
                this.skipNext();
            }
            int n = count;
            return n;
        }
        finally {
            this.index = oldIndex;
        }
    }

    @Override
    public boolean isComplete() {
        return this.content.size() - this.index == 0;
    }

    @Override
    public int position() {
        return this.index;
    }

    private Bytes readList(boolean lenient) {
        int remaining = this.content.size() - this.index;
        if (remaining == 0) {
            throw new EndOfRLPException();
        }
        int prefix = this.content.get(this.index) & 0xFF;
        if (prefix <= 191) {
            throw new InvalidRLPTypeException("Attempted to read a list but next item is a value");
        }
        --remaining;
        if (prefix <= 247) {
            int length = prefix - 192;
            if (remaining < length) {
                throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + length + " but have only " + remaining);
            }
            ++this.index;
            Bytes bytes = this.content.slice(this.index, length);
            this.index += length;
            return bytes;
        }
        int lengthOfLength = prefix - 247;
        if (remaining < lengthOfLength) {
            throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + lengthOfLength + " but have only " + remaining);
        }
        int length = this.getLength(lengthOfLength, lenient, "list");
        if ((remaining -= lengthOfLength) < length) {
            throw new InvalidRLPEncodingException("Insufficient bytes in RLP encoding: expected " + length + " but have only " + remaining);
        }
        this.index += 1 + lengthOfLength;
        Bytes bytes = this.content.slice(this.index, length);
        this.index += length;
        return bytes;
    }

    private int getLength(int lengthOfLength, boolean lenient, String type) {
        Bytes lengthBytes = this.content.slice(this.index + 1, lengthOfLength);
        if (!lenient) {
            if (lengthBytes.hasLeadingZeroByte()) {
                throw new InvalidRLPEncodingException("RLP " + type + " length contains leading zero bytes");
            }
        } else {
            lengthBytes = lengthBytes.trimLeadingZeros();
        }
        if (lengthBytes.size() == 0) {
            throw new InvalidRLPEncodingException("RLP " + type + " length is zero");
        }
        if (lengthBytes.size() > 4) {
            throw new InvalidRLPEncodingException("RLP " + type + " length is oversized");
        }
        int length = lengthBytes.toInt();
        if (length < 0) {
            throw new InvalidRLPEncodingException("RLP " + type + " length is oversized");
        }
        assert (length > 0);
        if (!lenient && length <= 55) {
            throw new InvalidRLPEncodingException("RLP " + type + " length of " + length + " was not minimally encoded");
        }
        return length;
    }
}

