/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.eth.EthJsonModule;
import org.apache.tuweni.eth.crawler.ClientInfo;
import org.apache.tuweni.eth.crawler.ClientReadyStats;
import org.apache.tuweni.eth.crawler.RESTMetrics;
import org.apache.tuweni.eth.crawler.StatsJob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="clients")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\nH\u0007R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/eth/crawler/rest/ClientsService;", "", "()V", "context", "Ljavax/servlet/ServletContext;", "getContext", "()Ljavax/servlet/ServletContext;", "setContext", "(Ljavax/servlet/ServletContext;)V", "getClientIds", "", "getClientStats", "upgrade", "Companion", "eth-crawler"})
public final class ClientsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Context
    @Nullable
    private ServletContext context;
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    @Nullable
    public final ServletContext getContext() {
        return this.context;
    }

    public final void setContext(@Nullable ServletContext servletContext) {
        this.context = servletContext;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="all")
    @NotNull
    public final String getClientIds() {
        ServletContext servletContext = this.context;
        Intrinsics.checkNotNull((Object)servletContext);
        Object object = servletContext.getAttribute("stats");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.StatsJob");
        }
        StatsJob stats = (StatsJob)object;
        ServletContext servletContext2 = this.context;
        Intrinsics.checkNotNull((Object)servletContext2);
        Object object2 = servletContext2.getAttribute("metrics");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.RESTMetrics");
        }
        RESTMetrics metrics = (RESTMetrics)object2;
        metrics.getClientsCounter().add(1L);
        List<ClientInfo> peers = stats.getClientIds$eth_crawler();
        String result = mapper.writeValueAsString(peers);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    @Path(value="{upgrade}/stats")
    @NotNull
    public final String getClientStats(@PathParam(value="upgrade") @NotNull String upgrade) {
        Intrinsics.checkNotNullParameter((Object)upgrade, (String)"upgrade");
        ServletContext servletContext = this.context;
        Intrinsics.checkNotNull((Object)servletContext);
        Object object = servletContext.getAttribute("stats");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.StatsJob");
        }
        StatsJob stats = (StatsJob)object;
        ClientReadyStats peers = stats.getUpgradeStats$eth_crawler().get(upgrade);
        String result = mapper.writeValueAsString((Object)peers);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="stats")
    @NotNull
    public final String getClientStats() {
        ServletContext servletContext = this.context;
        Intrinsics.checkNotNull((Object)servletContext);
        Object object = servletContext.getAttribute("stats");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.eth.crawler.StatsJob");
        }
        StatsJob statsjob = (StatsJob)object;
        Map<String, Map<String, Long>> stats = statsjob.getClientStats$eth_crawler();
        String result = mapper.writeValueAsString(stats);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    static {
        mapper.registerModule((Module)new EthJsonModule());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/eth/crawler/rest/ClientsService$Companion;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "eth-crawler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

