/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethstats;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.eth.EthJsonModule;
import org.apache.tuweni.ethstats.BlockStats;
import org.apache.tuweni.ethstats.EthStatsReporter;
import org.apache.tuweni.ethstats.EthStatsServer;
import org.apache.tuweni.ethstats.EthStatsServerController;
import org.apache.tuweni.ethstats.NodeInfo;
import org.apache.tuweni.ethstats.NodeStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 (2\u00020\u0001:\u0001(BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020!H\u0002J\u0011\u0010%\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u0011\u0010'\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsServer;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "networkInterface", "", "port", "", "secret", "timeSupplier", "Lkotlin/Function0;", "Ljava/time/Instant;", "controller", "Lorg/apache/tuweni/ethstats/EthStatsServerController;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function0;Lorg/apache/tuweni/ethstats/EthStatsServerController;Lkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getNetworkInterface", "()Ljava/lang/String;", "getPort", "()I", "setPort", "(I)V", "getSecret", "server", "Lio/vertx/core/http/HttpServer;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connect", "", "serverWebSocket", "Lio/vertx/core/http/ServerWebSocket;", "handleMessage", "message", "websocket", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "Companion", "ethstats"})
public final class EthStatsServer
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final String networkInterface;
    private int port;
    @NotNull
    private final String secret;
    @NotNull
    private final Function0<Instant> timeSupplier;
    @NotNull
    private final EthStatsServerController controller;
    @NotNull
    private final CoroutineContext coroutineContext;
    @Nullable
    private HttpServer server;
    @NotNull
    private final AtomicBoolean started;
    private static final Logger logger = LoggerFactory.getLogger(EthStatsServer.class);
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    public EthStatsServer(@NotNull Vertx vertx, @NotNull String networkInterface, int port, @NotNull String secret, @NotNull Function0<Instant> timeSupplier, @NotNull EthStatsServerController controller, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter(timeSupplier, (String)"timeSupplier");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.networkInterface = networkInterface;
        this.port = port;
        this.secret = secret;
        this.timeSupplier = timeSupplier;
        this.controller = controller;
        this.coroutineContext = coroutineContext;
        this.started = new AtomicBoolean(false);
    }

    public /* synthetic */ EthStatsServer(Vertx vertx, String string, int n, String string2, Function0 function0, EthStatsServerController ethStatsServerController, CoroutineContext coroutineContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n2 & 0x40) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(vertx, string, n, string2, (Function0<Instant>)function0, ethStatsServerController, coroutineContext);
    }

    @NotNull
    public final String getNetworkInterface() {
        return this.networkInterface;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getSecret() {
        return this.secret;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ EthStatsServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.started.compareAndSet(false, true)) ** GOTO lbl27
                var3_5 = this;
                var2_6 = this.vertx.createHttpServer().webSocketHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, connect(io.vertx.core.http.ServerWebSocket ), (Lio/vertx/core/http/ServerWebSocket;)V)((EthStatsServer)this)).exceptionHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, start$lambda-0(java.lang.Throwable ), (Ljava/lang/Throwable;)V)()).listen(this.getPort(), this.getNetworkInterface());
                Intrinsics.checkNotNullExpressionValue((Object)var2_6, (String)"vertx.createHttpServer()\u2026n(port, networkInterface)");
                $continuation.L$0 = var3_5;
                $continuation.label = 1;
                v0 = VertxCoroutineKt.await((Future)var2_6, (Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                var3_5 = (EthStatsServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                var3_5.server = (HttpServer)v0;
lbl27:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        if (this.started.compareAndSet(true, false)) {
            Object v1;
            HttpServer httpServer = this.server;
            if (httpServer == null) {
                v1 = null;
            } else {
                Future future = httpServer.close();
                if (future == null) {
                    v1 = null;
                } else {
                    Object object = VertxCoroutineKt.await((Future)future, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            }
            if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return v1;
            }
        }
        return Unit.INSTANCE;
    }

    public final void connect(@NotNull ServerWebSocket serverWebSocket) {
        Intrinsics.checkNotNullParameter((Object)serverWebSocket, (String)"serverWebSocket");
        logger.debug("New connection");
        ServerWebSocket websocket = serverWebSocket;
        websocket.accept();
        websocket.exceptionHandler(arg_0 -> EthStatsServer.connect$lambda-1(websocket, arg_0));
        websocket.textMessageHandler(arg_0 -> EthStatsServer.connect$lambda-2(this, websocket, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final void handleMessage(String message, ServerWebSocket websocket) {
        EthStatsServer.logger.debug("Received {}", (Object)message);
        v0 = EthStatsServer.mapper.readTree(message).get("emit");
        if (v0 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
        }
        event = (ArrayNode)v0;
        command = event.get(0).textValue();
        var5_5 = command;
        if (var5_5 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var5_5.hashCode()) {
            case 109757599: {
                if (var5_5.equals("stats")) {
                    tmp = 1;
                }
                break;
            }
            case -46576386: {
                if (var5_5.equals("latency")) {
                    tmp = 2;
                }
                break;
            }
            case -682587753: {
                if (var5_5.equals("pending")) {
                    tmp = 3;
                }
                break;
            }
            case -838846263: {
                if (var5_5.equals("update")) {
                    tmp = 4;
                }
                break;
            }
            case 100571: {
                if (var5_5.equals("end")) {
                    tmp = 5;
                }
                break;
            }
            case 93832333: {
                if (var5_5.equals("block")) {
                    tmp = 6;
                }
                break;
            }
            case 99162322: {
                if (var5_5.equals("hello")) {
                    tmp = 7;
                }
                break;
            }
            case 926934164: {
                if (var5_5.equals("history")) {
                    tmp = 4;
                }
                break;
            }
            case 419522141: {
                if (var5_5.equals("node-ping")) {
                    tmp = 8;
                }
                break;
            }
        }
        switch (tmp) {
            case 7: {
                clientSecret = event.get(1).get("secret").textValue();
                if (!Intrinsics.areEqual((Object)clientSecret, (Object)this.secret)) {
                    EthStatsServer.logger.info("Client {} connected with wrong secret {}, disconnecting", (Object)websocket.remoteAddress(), (Object)clientSecret);
                    websocket.close();
                    return;
                }
                websocket.writeTextMessage("{\"emit\":[\"ready\"]}");
                id = event.get(1).get("id").textValue();
                nodeInfo = (NodeInfo)EthStatsServer.mapper.readerFor(NodeInfo.class).readValue(event.get(1).get("info"));
                v1 = websocket.remoteAddress().toString();
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                Intrinsics.checkNotNullExpressionValue((Object)nodeInfo, (String)"nodeInfo");
                this.controller.readNodeInfo(v1, id, nodeInfo);
                websocket.closeHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, handleMessage$lambda-3(org.apache.tuweni.ethstats.EthStatsServer io.vertx.core.http.ServerWebSocket java.lang.String java.lang.Void ), (Ljava/lang/Void;)V)((EthStatsServer)this, (ServerWebSocket)websocket, (String)id));
                break;
            }
            case 8: {
                EthStatsServer.logger.debug("Received a ping {}", (Object)event.get(1));
                clientTime = event.get(1).get("clientTime").longValue();
                var9_20 = new Pair[]{new Pair((Object)"clientTime", (Object)clientTime), new Pair((Object)"serverTime", (Object)((Instant)this.timeSupplier.invoke()).toEpochMilli())};
                payload = MapsKt.mapOf((Pair[])var9_20);
                var10_21 = new Object[]{"node-pong", payload};
                response = EthStatsServer.mapper.writer().writeValueAsString((Object)MapsKt.mapOf((Pair)new Pair((Object)"emit", (Object)CollectionsKt.listOf((Object[])var10_21))));
                EthStatsReporter.Companion.getLogger().debug("Sending {} message {}", (Object)command, (Object)message);
                websocket.writeTextMessage(response);
                break;
            }
            case 2: {
                id = event.get(1).get("id").textValue();
                latency = event.get(1).get("latency").longValue();
                v2 = websocket.remoteAddress().toString();
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                this.controller.readLatency(v2, id, latency);
                break;
            }
            case 5: {
                id = event.get(1).get("id").textValue();
                v3 = websocket.remoteAddress().toString();
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                this.controller.readDisconnect(v3, id);
                break;
            }
            case 1: {
                id = event.get(1).get("id").textValue();
                nodeStats = (NodeStats)EthStatsServer.mapper.readerFor(NodeStats.class).readValue(event.get(1).get("stats"));
                v4 = websocket.remoteAddress().toString();
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                Intrinsics.checkNotNullExpressionValue((Object)nodeStats, (String)"nodeStats");
                this.controller.readNodeStats(v4, id, nodeStats);
                break;
            }
            case 3: {
                id = event.get(1).get("id").textValue();
                pendingTx = event.get(1).get("stats").get("pending").longValue();
                v5 = websocket.remoteAddress().toString();
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                this.controller.readPendingTx(v5, id, pendingTx);
                break;
            }
            case 6: {
                id = event.get(1).get("id").textValue();
                block = (BlockStats)EthStatsServer.mapper.readerFor(BlockStats.class).readValue(event.get(1).get("block"));
                v6 = websocket.remoteAddress().toString();
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"block");
                this.controller.readBlock(v6, id, block);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                EthStatsServer.logger.error("Unknown command: {}", (Object)message);
                websocket.close();
            }
            case 4: 
        }
    }

    private static final void start$lambda-0(Throwable it) {
        logger.error("Exception occurred", it);
    }

    private static final void connect$lambda-1(ServerWebSocket $websocket, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$websocket, (String)"$websocket");
        logger.debug("Error reading message", it);
        $websocket.close();
    }

    private static final void connect$lambda-2(EthStatsServer this$0, ServerWebSocket $websocket, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$websocket, (String)"$websocket");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this$0.handleMessage(it, $websocket);
        }
        catch (IOException e) {
            logger.debug("Invalid payload", (Throwable)e);
            $websocket.close();
        }
    }

    private static final void handleMessage$lambda-3(EthStatsServer this$0, ServerWebSocket $websocket, String $id, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$websocket, (String)"$websocket");
        EthStatsServerController ethStatsServerController = this$0.controller;
        String string = $websocket.remoteAddress().toString();
        Intrinsics.checkNotNullExpressionValue((Object)$id, (String)"id");
        ethStatsServerController.readDisconnect(string, $id);
    }

    static {
        mapper.registerModule((Module)new EthJsonModule());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsServer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "ethstats"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

