/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.CollectionAttributeCopier;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexReaderConfiguration;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.parsing.Element;

public class IndexingConfiguration
extends AbstractTypedPropertiesConfiguration
implements Matchable<IndexingConfiguration>,
ConfigurationInfo {
    @Deprecated
    public static final AttributeDefinition<Index> INDEX = AttributeDefinition.builder((String)"index", null, Index.class).immutable().build();
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    @Deprecated
    public static final AttributeDefinition<Boolean> AUTO_CONFIG = AttributeDefinition.builder((String)"autoConfig", (Object)false).immutable().build();
    public static final AttributeDefinition<Map<Class<?>, Class<?>>> KEY_TRANSFORMERS = AttributeDefinition.builder((String)"key-transformers", null, Map.class).copier(CollectionAttributeCopier.INSTANCE).initializer(HashMap::new).immutable().build();
    public static final AttributeDefinition<Set<String>> INDEXED_ENTITIES = AttributeDefinition.builder((String)"indexed-entities", null, Set.class).copier(CollectionAttributeCopier.INSTANCE).initializer(HashSet::new).immutable().build();
    public static final AttributeDefinition<IndexStorage> STORAGE = AttributeDefinition.builder((String)"storage", (Object)((Object)IndexStorage.FILESYSTEM)).serializer((AttributeSerializer)new AttributeSerializer<IndexStorage, ConfigurationInfo, ConfigurationBuilderInfo>(){

        public Object readAttributeValue(String enclosingElement, AttributeDefinition attributeDefinition, Object attrValue, ConfigurationBuilderInfo builderInfo) {
            return IndexStorage.valueOf(attrValue.toString().replace("-", "_").toUpperCase());
        }
    }).immutable().build();
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder((String)"path", null, String.class).immutable().build();
    static final ElementDefinition<IndexingConfiguration> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.INDEXING.getLocalName());
    @Deprecated
    private final Attribute<Index> index;
    @Deprecated
    private final Attribute<Boolean> autoConfig;
    private final Attribute<Map<Class<?>, Class<?>>> keyTransformers;
    private final Attribute<Set<String>> indexedEntities;
    private final Set<Class<?>> resolvedIndexedClasses;
    private final Attribute<Boolean> enabled;
    private final Attribute<IndexStorage> storage;
    private final Attribute<String> path;
    private final IndexReaderConfiguration readerConfiguration;
    private final IndexWriterConfiguration writerConfiguration;
    private final List<ConfigurationInfo> subElements = new ArrayList<ConfigurationInfo>();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexingConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), new AttributeDefinition[]{INDEX, AUTO_CONFIG, KEY_TRANSFORMERS, INDEXED_ENTITIES, ENABLED, STORAGE, PATH});
    }

    IndexingConfiguration(AttributeSet attributes, Set<Class<?>> resolvedIndexedClasses, IndexReaderConfiguration readerConfiguration, IndexWriterConfiguration writerConfiguration) {
        super(attributes);
        this.readerConfiguration = readerConfiguration;
        this.writerConfiguration = writerConfiguration;
        this.resolvedIndexedClasses = resolvedIndexedClasses;
        this.index = attributes.attribute(INDEX);
        this.autoConfig = attributes.attribute(AUTO_CONFIG);
        this.keyTransformers = attributes.attribute(KEY_TRANSFORMERS);
        this.indexedEntities = attributes.attribute(INDEXED_ENTITIES);
        this.enabled = attributes.attribute(ENABLED);
        this.storage = attributes.attribute(STORAGE);
        this.path = attributes.attribute(PATH);
        this.subElements.add(readerConfiguration);
        this.subElements.add(writerConfiguration);
    }

    public ElementDefinition<IndexingConfiguration> getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    @Deprecated
    public TypedProperties properties() {
        return super.properties();
    }

    @Deprecated
    public Index index() {
        return (Index)((Object)this.index.get());
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    @Deprecated
    public boolean autoConfig() {
        return (Boolean)this.autoConfig.get();
    }

    public IndexStorage storage() {
        return (IndexStorage)((Object)this.storage.get());
    }

    public String path() {
        return (String)this.path.get();
    }

    public Map<Class<?>, Class<?>> keyTransformers() {
        return (Map)this.keyTransformers.get();
    }

    @Deprecated
    public Set<Class<?>> indexedEntities() {
        return this.resolvedIndexedClasses;
    }

    public Set<String> indexedEntityTypes() {
        return (Set)this.indexedEntities.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Deprecated
    public final boolean indexShareable() {
        return false;
    }

    public IndexReaderConfiguration reader() {
        return this.readerConfiguration;
    }

    public IndexWriterConfiguration writer() {
        return this.writerConfiguration;
    }

    public boolean isVolatile() {
        return ((IndexStorage)((Object)this.storage.get())).equals((Object)IndexStorage.LOCAL_HEAP);
    }

    public String toString() {
        return "IndexingConfiguration{readerConfiguration=" + this.readerConfiguration + ", writerConfiguration=" + this.writerConfiguration + ", attributes=" + this.attributes + '}';
    }
}

