/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.precompiles;

import com.sun.jna.ptr.IntByReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.precompiles.PrecompileContract;
import org.apache.tuweni.eth.precompiles.Result;
import org.hyperledger.besu.nativelib.bls12_381.LibEthPairings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/apache/tuweni/eth/precompiles/AltBN128PrecompiledContract;", "Lorg/apache/tuweni/eth/precompiles/PrecompileContract;", "operation", "", "inputLen", "", "baseCost", "", "pairingGasCost", "(BIJJ)V", "getBaseCost", "()J", "getInputLen", "()I", "getPairingGasCost", "run", "Lorg/apache/tuweni/eth/precompiles/Result;", "input", "Lorg/apache/tuweni/bytes/Bytes;", "eth-precompiles"})
public final class AltBN128PrecompiledContract
implements PrecompileContract {
    private final byte operation;
    private final int inputLen;
    private final long baseCost;
    private final long pairingGasCost;

    public AltBN128PrecompiledContract(byte operation, int inputLen, long baseCost, long pairingGasCost) {
        this.operation = operation;
        this.inputLen = inputLen;
        this.baseCost = baseCost;
        this.pairingGasCost = pairingGasCost;
    }

    public final int getInputLen() {
        return this.inputLen;
    }

    public final long getBaseCost() {
        return this.baseCost;
    }

    public final long getPairingGasCost() {
        return this.pairingGasCost;
    }

    @Override
    @NotNull
    public Result run(@NotNull Bytes input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int parameters = input.size() / 192;
        long gasCost = this.pairingGasCost * (long)parameters + this.baseCost;
        byte[] result = new byte[64];
        byte[] error = new byte[256];
        IntByReference o_len = new IntByReference(64);
        IntByReference err_len = new IntByReference(256);
        int inputSize = Math.min(this.inputLen, input.size());
        int errorNo = LibEthPairings.eip196_perform_operation((byte)this.operation, (byte[])input.slice(0, inputSize).toArrayUnsafe(), (int)inputSize, (byte[])result, (IntByReference)o_len, (byte[])error, (IntByReference)err_len);
        return errorNo == 0 ? new Result(gasCost, Bytes.wrap((byte[])result, (int)0, (int)o_len.getValue())) : new Result(gasCost, Bytes.EMPTY);
    }
}

