/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.blake2bf;

import java.nio.ByteOrder;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import org.bouncycastle.util.Pack;

public class Blake2bfMessageDigest
extends BCMessageDigest
implements Cloneable {
    public Blake2bfMessageDigest() {
        super((Digest)new Blake2bfDigest());
    }

    public static class Blake2bfDigest
    implements Digest {
        public static final int MESSAGE_LENGTH_BYTES = 213;
        private static final long[] IV = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};
        private static final byte[][] PRECOMPUTED = new byte[][]{{0, 2, 4, 6, 1, 3, 5, 7, 8, 10, 12, 14, 9, 11, 13, 15}, {14, 4, 9, 13, 10, 8, 15, 6, 1, 0, 11, 5, 12, 2, 7, 3}, {11, 12, 5, 15, 8, 0, 2, 13, 10, 3, 7, 9, 14, 6, 1, 4}, {7, 3, 13, 11, 9, 1, 12, 14, 2, 5, 4, 15, 6, 10, 0, 8}, {9, 5, 2, 10, 0, 7, 4, 15, 14, 11, 6, 3, 1, 12, 8, 13}, {2, 6, 0, 8, 12, 10, 11, 3, 4, 7, 15, 1, 13, 5, 14, 9}, {12, 1, 14, 4, 5, 15, 13, 10, 0, 6, 9, 8, 7, 3, 2, 11}, {13, 7, 12, 3, 11, 14, 1, 9, 5, 15, 8, 2, 0, 4, 6, 10}, {6, 14, 11, 0, 15, 9, 3, 8, 12, 13, 1, 10, 2, 7, 4, 5}, {10, 8, 7, 1, 2, 4, 6, 5, 15, 9, 3, 13, 11, 14, 12, 0}};
        private static final int DIGEST_LENGTH = 64;
        private Bytes buffer = Bytes.EMPTY;

        Blake2bfDigest() {
        }

        Blake2bfDigest(long[] h, long[] m, long[] t, boolean f, long rounds) {
            assert (rounds <= 0xFFFFFFFFL);
        }

        public String getAlgorithmName() {
            return "BLAKE2f";
        }

        public int getDigestSize() {
            return 64;
        }

        public void update(byte in) {
            if (this.buffer.size() == 213) {
                throw new IllegalArgumentException();
            }
            this.buffer = Bytes.wrap((Bytes[])new Bytes[]{this.buffer, Bytes.of((byte[])new byte[]{in})});
        }

        public void update(byte[] in, int offset, int len) {
            Bytes value = Bytes.wrap((byte[])in, (int)offset, (int)len);
            if (value.size() > 213 - this.buffer.size()) {
                throw new IllegalArgumentException("Attempting to update buffer with " + value.size() + " byte(s) but there is " + (213 - value.size()) + " byte(s) left to fill");
            }
            MutableBytes mutable = MutableBytes.create((int)(this.buffer.size() + value.size()));
            mutable.set(0, this.buffer);
            mutable.set(this.buffer.size(), value);
            this.buffer = mutable;
        }

        public int doFinal(byte[] out, int offset) {
            if (this.buffer.size() != 213) {
                throw new IllegalStateException("The buffer must be filled with 213 bytes");
            }
            this.compress(out);
            this.reset();
            return 0;
        }

        public void reset() {
            this.buffer = Bytes.EMPTY;
        }

        private void compress(byte[] out) {
            int offset;
            int i;
            long rounds = Integer.toUnsignedLong(this.buffer.getInt(0));
            long[] h = new long[8];
            long[] m = new long[16];
            long[] t = new long[2];
            long[] v = new long[16];
            for (i = 0; i < h.length; ++i) {
                offset = 4 + i * 8;
                h[i] = this.buffer.getLong(offset, ByteOrder.LITTLE_ENDIAN);
            }
            for (i = 0; i < 16; ++i) {
                offset = 68 + i * 8;
                m[i] = this.buffer.getLong(offset, ByteOrder.LITTLE_ENDIAN);
            }
            t[0] = this.buffer.getLong(196, ByteOrder.LITTLE_ENDIAN);
            t[1] = this.buffer.getLong(204, ByteOrder.LITTLE_ENDIAN);
            boolean f = this.buffer.get(212) != 0;
            long t0 = t[0];
            long t1 = t[1];
            System.arraycopy(h, 0, v, 0, 8);
            System.arraycopy(IV, 0, v, 8, 8);
            v[12] = v[12] ^ t0;
            v[13] = v[13] ^ t1;
            if (f) {
                v[14] = v[14] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            for (long j = 0L; j < rounds; ++j) {
                byte[] s = PRECOMPUTED[(int)(j % 10L)];
                this.mix(v, m[s[0]], m[s[4]], 0, 4, 8, 12);
                this.mix(v, m[s[1]], m[s[5]], 1, 5, 9, 13);
                this.mix(v, m[s[2]], m[s[6]], 2, 6, 10, 14);
                this.mix(v, m[s[3]], m[s[7]], 3, 7, 11, 15);
                this.mix(v, m[s[8]], m[s[12]], 0, 5, 10, 15);
                this.mix(v, m[s[9]], m[s[13]], 1, 6, 11, 12);
                this.mix(v, m[s[10]], m[s[14]], 2, 7, 8, 13);
                this.mix(v, m[s[11]], m[s[15]], 3, 4, 9, 14);
            }
            for (int offset2 = 0; offset2 < h.length; ++offset2) {
                int n = offset2;
                h[n] = h[n] ^ (v[offset2] ^ v[offset2 + 8]);
            }
            for (int i2 = 0; i2 < h.length; ++i2) {
                System.arraycopy(Pack.longToLittleEndian((long)h[i2]), 0, out, i2 * 8, 8);
            }
        }

        private void mix(long[] v, long a, long b, int i, int j, int k, int l) {
            int n = i;
            v[n] = v[n] + (a + v[j]);
            v[l] = Long.rotateLeft(v[l] ^ v[i], -32);
            int n2 = k;
            v[n2] = v[n2] + v[l];
            v[j] = Long.rotateLeft(v[j] ^ v[k], -24);
            int n3 = i;
            v[n3] = v[n3] + (b + v[j]);
            v[l] = Long.rotateLeft(v[l] ^ v[i], -16);
            int n4 = k;
            v[n4] = v[n4] + v[l];
            v[j] = Long.rotateLeft(v[j] ^ v[k], -63);
        }
    }
}

