/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.genesis;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.EthJsonModule;
import org.apache.tuweni.genesis.QuorumConfig;
import org.apache.tuweni.genesis.QuorumGenesisConfig;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "genesis"})
public final class MainKt {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Security.addProvider((Provider)new BouncyCastleProvider());
        Bytes32 bytes32 = Bytes32.random();
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"random()");
        Bytes32 bytes322 = bytes32;
        QuorumGenesisConfig quorumGenesisConfig = new QuorumGenesisConfig(Integer.parseInt(args[0]), 0, 0, 0, 0, 0, 0, null, 0, 0, 1022, null);
        bytes32 = UInt256.fromBytes((Bytes)((Bytes)Bytes32.rightPad((Bytes)Bytes.fromHexString((CharSequence)"0x10"))));
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"fromBytes(Bytes32.rightP\u2026s.fromHexString(\"0x10\")))");
        QuorumConfig config = QuorumConfig.Companion.generate$default(QuorumConfig.Companion, null, null, bytes322, null, 0L, 0L, null, null, quorumGenesisConfig, 4, 100, (UInt256)bytes32, 251, null);
        JsonMapper mapper = new JsonMapper();
        mapper.registerModule((Module)new EthJsonModule());
        byte[] contents = mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)config.getGenesis());
        Files.write(Paths.get("genesis.json", new String[0]), contents, new OpenOption[0]);
        Path path = Paths.get("accounts.csv", new String[0]);
        String string = config.allocsToCsv();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
        Path path2 = Paths.get("validators.csv", new String[0]);
        string = config.validatorsToCsv();
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        Files.write(path2, byArray2, new OpenOption[0]);
    }
}

