/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.genesis;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Block;
import org.apache.tuweni.eth.BlockBody;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.genesis.GenesisConfig;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt64;
import org.apache.tuweni.units.ethereum.Gas;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonPropertyOrder(value={"config", "nonce", "timestamp", "extraData", "gasLimit", "difficulty", "number", "gasUsed", "mixHash", "coinbase", "parentHash", "alloc"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u00100\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010#\u001a\u00020\u0011J\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010%\u001a\u00020\u0011R)\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/apache/tuweni/genesis/Genesis;", "", "nonce", "Lorg/apache/tuweni/bytes/Bytes;", "difficulty", "Lorg/apache/tuweni/units/bigints/UInt256;", "mixHash", "Lorg/apache/tuweni/bytes/Bytes32;", "coinbase", "Lorg/apache/tuweni/eth/Address;", "parentHash", "timestamp", "", "extraData", "gasLimit", "alloc", "", "", "config", "Lorg/apache/tuweni/genesis/GenesisConfig;", "(Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/bytes/Bytes32;Lorg/apache/tuweni/eth/Address;Lorg/apache/tuweni/bytes/Bytes32;JLorg/apache/tuweni/bytes/Bytes;JLjava/util/Map;Lorg/apache/tuweni/genesis/GenesisConfig;)V", "getAlloc", "()Ljava/util/Map;", "getCoinbase", "()Lorg/apache/tuweni/eth/Address;", "getConfig", "()Lorg/apache/tuweni/genesis/GenesisConfig;", "getDifficulty", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getExtraData", "()Lorg/apache/tuweni/bytes/Bytes;", "getMixHash", "()Lorg/apache/tuweni/bytes/Bytes32;", "getNonce", "getParentHash", "getGasLimit", "getNumber", "getTimestamp", "Companion", "genesis"})
public final class Genesis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bytes nonce;
    @NotNull
    private final UInt256 difficulty;
    @NotNull
    private final Bytes32 mixHash;
    @NotNull
    private final Address coinbase;
    @NotNull
    private final Bytes32 parentHash;
    private final long timestamp;
    @NotNull
    private final Bytes extraData;
    private final long gasLimit;
    @NotNull
    private final Map<Address, Map<String, UInt256>> alloc;
    @NotNull
    private final GenesisConfig config;
    private static final Hash emptyListHash = Hash.hash((Bytes)RLP.encodeList(Genesis::emptyListHash$lambda-0));
    private static final Hash emptyHash = Hash.hash((Bytes)RLP.encode(Genesis::emptyHash$lambda-1));
    private static final Hash emptyTrieHash = Hash.hash((Bytes)RLP.encodeValue((Bytes)Bytes.EMPTY));

    public Genesis(@NotNull Bytes nonce, @NotNull UInt256 difficulty, @NotNull Bytes32 mixHash, @NotNull Address coinbase, @NotNull Bytes32 parentHash, long timestamp, @NotNull Bytes extraData, long gasLimit, @NotNull Map<Address, ? extends Map<String, UInt256>> alloc, @NotNull GenesisConfig config) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)mixHash, (String)"mixHash");
        Intrinsics.checkNotNullParameter((Object)coinbase, (String)"coinbase");
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter(alloc, (String)"alloc");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.nonce = nonce;
        this.difficulty = difficulty;
        this.mixHash = mixHash;
        this.coinbase = coinbase;
        this.parentHash = parentHash;
        this.timestamp = timestamp;
        this.extraData = extraData;
        this.gasLimit = gasLimit;
        this.alloc = alloc;
        this.config = config;
    }

    @NotNull
    public final Bytes getNonce() {
        return this.nonce;
    }

    @NotNull
    public final UInt256 getDifficulty() {
        return this.difficulty;
    }

    @NotNull
    public final Bytes32 getMixHash() {
        return this.mixHash;
    }

    @NotNull
    public final Address getCoinbase() {
        return this.coinbase;
    }

    @NotNull
    public final Bytes32 getParentHash() {
        return this.parentHash;
    }

    @NotNull
    public final Bytes getExtraData() {
        return this.extraData;
    }

    @NotNull
    public final Map<Address, Map<String, UInt256>> getAlloc() {
        return this.alloc;
    }

    @NotNull
    public final GenesisConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final String getTimestamp() {
        if (this.timestamp == 0L) {
            return "0x0";
        }
        String string = Bytes.ofUnsignedLong((long)this.timestamp).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofUnsignedLong(timestamp).toHexString()");
        return string;
    }

    @NotNull
    public final String getGasLimit() {
        String string = Bytes.ofUnsignedLong((long)this.gasLimit).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofUnsignedLong(gasLimit).toHexString()");
        return string;
    }

    @NotNull
    public final String getNumber() {
        return "0x0";
    }

    private static final void emptyListHash$lambda-0(RLPWriter it) {
    }

    private static final void emptyHash$lambda-1(RLPWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.writeValue(Bytes.EMPTY);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/genesis/Genesis$Companion;", "", "()V", "emptyHash", "Lorg/apache/tuweni/eth/Hash;", "kotlin.jvm.PlatformType", "getEmptyHash", "()Lorg/apache/tuweni/eth/Hash;", "emptyListHash", "getEmptyListHash", "emptyTrieHash", "getEmptyTrieHash", "dev", "Lorg/apache/tuweni/eth/Block;", "genesis", "Lorg/apache/tuweni/genesis/Genesis;"})
    public static final class Companion {
        private Companion() {
        }

        public final Hash getEmptyListHash() {
            return emptyListHash;
        }

        public final Hash getEmptyHash() {
            return emptyHash;
        }

        public final Hash getEmptyTrieHash() {
            return emptyTrieHash;
        }

        @NotNull
        public final Block dev(@NotNull Genesis genesis) {
            Intrinsics.checkNotNullParameter((Object)genesis, (String)"genesis");
            return new Block(new BlockHeader(Hash.fromBytes((Bytes32)genesis.getParentHash()), this.getEmptyListHash(), genesis.getCoinbase(), this.getEmptyTrieHash(), this.getEmptyHash(), this.getEmptyHash(), Bytes.wrap((byte[])new byte[256]), genesis.getDifficulty(), UInt256.ZERO, Gas.valueOf((long)genesis.gasLimit), Gas.valueOf((long)0L), Instant.ofEpochSecond(genesis.timestamp), genesis.getExtraData(), Hash.fromBytes((Bytes32)genesis.getMixHash()), UInt64.fromBytes((Bytes)genesis.getNonce())), new BlockBody((List)new ArrayList(), (List)new ArrayList()));
        }

        public static /* synthetic */ Block dev$default(Companion companion, Genesis genesis, int n, Object object) {
            if ((n & 1) != 0) {
                Bytes bytes = Bytes.ofUnsignedLong((long)0L);
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ofUnsignedLong(0)");
                Bytes bytes2 = bytes;
                bytes = UInt256.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ONE");
                Bytes bytes3 = bytes;
                bytes = Bytes32.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ZERO");
                Bytes bytes4 = bytes;
                bytes = Address.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ZERO");
                Bytes bytes5 = bytes;
                bytes = Bytes32.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"ZERO");
                Bytes bytes6 = bytes;
                bytes = Bytes.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"EMPTY");
                genesis = new Genesis(bytes2, (UInt256)bytes3, (Bytes32)bytes4, (Address)bytes5, (Bytes32)bytes6, 0L, bytes, 1000000L, MapsKt.emptyMap(), new GenesisConfig(1337, 0, 0, 0, 0, 0, 0, 96, null));
            }
            return companion.dev(genesis);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

