/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc.app;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.vertx.core.Vertx;
import io.vertx.core.net.TrustOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.apache.tuweni.eth.JSONRPCRequest;
import org.apache.tuweni.eth.JSONRPCResponse;
import org.apache.tuweni.eth.JSONRPCResponseKt;
import org.apache.tuweni.eth.StringOrLong;
import org.apache.tuweni.jsonrpc.JSONRPCClient;
import org.apache.tuweni.jsonrpc.JSONRPCServer;
import org.apache.tuweni.jsonrpc.app.JSONRPCAppKt;
import org.apache.tuweni.jsonrpc.app.JSONRPCConfig;
import org.apache.tuweni.jsonrpc.app.PersistenceMarshaller;
import org.apache.tuweni.jsonrpc.methods.CachingHandler;
import org.apache.tuweni.jsonrpc.methods.LoggingHandler;
import org.apache.tuweni.jsonrpc.methods.MeteredHandler;
import org.apache.tuweni.jsonrpc.methods.MethodAllowListHandler;
import org.apache.tuweni.jsonrpc.methods.ThrottlingHandler;
import org.apache.tuweni.kv.InfinispanKeyValueStore;
import org.apache.tuweni.kv.KeyValueStore;
import org.apache.tuweni.metrics.MetricsService;
import org.apache.tuweni.net.ip.IPRangeChecker;
import org.apache.tuweni.net.tls.VertxTrustOptions;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/apache/tuweni/jsonrpc/app/JSONRPCApplication;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lorg/apache/tuweni/jsonrpc/app/JSONRPCConfig;", "metricsService", "Lorg/apache/tuweni/metrics/MetricsService;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;Lorg/apache/tuweni/jsonrpc/app/JSONRPCConfig;Lorg/apache/tuweni/metrics/MetricsService;Lkotlin/coroutines/CoroutineContext;)V", "getConfig", "()Lorg/apache/tuweni/jsonrpc/app/JSONRPCConfig;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getMetricsService", "()Lorg/apache/tuweni/metrics/MetricsService;", "getVertx", "()Lio/vertx/core/Vertx;", "run", "", "jsonrpc-app"})
public final class JSONRPCApplication
implements CoroutineScope {
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final JSONRPCConfig config;
    @NotNull
    private final MetricsService metricsService;
    @NotNull
    private final CoroutineContext coroutineContext;

    public JSONRPCApplication(@NotNull Vertx vertx, @NotNull JSONRPCConfig config, @NotNull MetricsService metricsService, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)metricsService, (String)"metricsService");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.config = config;
        this.metricsService = metricsService;
        this.coroutineContext = coroutineContext;
    }

    public /* synthetic */ JSONRPCApplication(Vertx vertx, JSONRPCConfig jSONRPCConfig, MetricsService metricsService, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getUnconfined();
        }
        this(vertx, jSONRPCConfig, metricsService, coroutineContext);
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public final JSONRPCConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final MetricsService getMetricsService() {
        return this.metricsService;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public final void run() {
        KFunction kFunction;
        Object object;
        JSONRPCAppKt.getLogger().info("JSON-RPC proxy starting");
        String string = this.config.endpointUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.endpointUrl()");
        String string2 = string;
        boolean bl = this.config.endpointBasicAuthEnabled();
        string = this.config.endpointBasicAuthUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.endpointBasicAuthUsername()");
        String string3 = string;
        string = this.config.endpointBasicAuthPassword();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.endpointBasicAuthPassword()");
        JSONRPCClient client = new JSONRPCClient(this.vertx, string2, null, bl, string3, string, null, 68, null);
        TrustOptions trustOptions = VertxTrustOptions.recordClientFingerprints((Path)this.config.clientFingerprintsFile());
        List<String> list = this.config.allowedMethods();
        Intrinsics.checkNotNullExpressionValue(list, (String)"config.allowedMethods()");
        MethodAllowListHandler allowListHandler2 = new MethodAllowListHandler(list, (Function2)new Function2<JSONRPCRequest, Continuation<? super JSONRPCResponse>, Object>(client, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ JSONRPCClient $client;
            {
                this.$client = $client;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        req = (JSONRPCRequest)this.L$0;
                        this.L$0 = req;
                        this.label = 1;
                        v0 = this.$client.sendRequest(req, (Continuation)this);
                        ** if (v0 != var5_2) goto lbl13
lbl12:
                        // 1 sources

                        return var5_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        req = (JSONRPCRequest)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        this.L$0 = req;
                        this.label = 2;
                        v1 = ((Deferred)v0).await((Continuation)this);
                        ** if (v1 != var5_2) goto lbl25
lbl24:
                        // 1 sources

                        return var5_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl32
                    }
                    case 2: {
                        req = (JSONRPCRequest)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl32:
                            // 2 sources

                            var3_4 = (JSONRPCResponse)v1;
                        }
                        catch (Exception e) {
                            JSONRPCAppKt.getLogger().error("Error sending JSON-RPC request", (Throwable)e);
                            var3_4 = JSONRPCResponse.copy$default((JSONRPCResponse)JSONRPCResponseKt.getInternalError(), (StringOrLong)req.getId(), null, null, null, (int)14, null);
                        }
                        return var3_4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull JSONRPCRequest p1, @Nullable Continuation<? super JSONRPCResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        Meter meter = this.metricsService.getMeterSdkProvider().get("jsonrpc");
        LongCounter successCounter = meter.longCounterBuilder("success").build();
        LongCounter failureCounter = meter.longCounterBuilder("failure").build();
        if (this.config.cacheEnabled()) {
            SerializationConfigurationBuilder builder = new GlobalConfigurationBuilder().serialization().marshaller((Marshaller)new PersistenceMarshaller());
            DefaultCacheManager manager = new DefaultCacheManager(builder.build());
            object = new String[]{"storage"};
            RocksDBStoreConfigurationBuilder rocksDBStoreConfigurationBuilder = ((RocksDBStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(RocksDBStoreConfigurationBuilder.class)).location(((Object)Paths.get(this.config.cacheStoragePath(), (String[])object).toAbsolutePath()).toString());
            object = new String[]{"expired"};
            Cache cache = manager.createCache("responses", rocksDBStoreConfigurationBuilder.expiredLocation(((Object)Paths.get(this.config.cacheStoragePath(), (String[])object).toAbsolutePath()).toString()).expiration().lifespan(this.config.cacheLifespan()).maxIdle(this.config.cacheMaxIdle()).build());
            Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"manager.createCache(\n   \u2026axIdle()).build()\n      )");
            Cache cache2 = cache;
            object = this.config.cachedMethods();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"config.cachedMethods()");
            Object object2 = object;
            KeyValueStore keyValueStore = (KeyValueStore)new InfinispanKeyValueStore(cache2, null, 2, null);
            object = meter.longCounterBuilder("cacheHits").build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"meter.longCounterBuilder(\"cacheHits\").build()");
            IPRangeChecker iPRangeChecker = object;
            object = meter.longCounterBuilder("cacheMisses").build();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"meter.longCounterBuilder(\"cacheMisses\").build()");
            CachingHandler cachingHandler2 = new CachingHandler((List)object2, keyValueStore, (LongCounter)iPRangeChecker, (LongCounter)object, (Function2)new Function2<JSONRPCRequest, JSONRPCResponse>((Object)allowListHandler2){

                @Nullable
                public final Object invoke(@NotNull JSONRPCRequest p0, @NotNull Continuation<? super JSONRPCResponse> $completion) {
                    return ((MethodAllowListHandler)this.receiver).handleRequest(p0, $completion);
                }
            });
            kFunction = (KFunction)new Function2<JSONRPCRequest, JSONRPCResponse>((Object)cachingHandler2){

                @Nullable
                public final Object invoke(@NotNull JSONRPCRequest p0, @NotNull Continuation<? super JSONRPCResponse> $completion) {
                    return ((CachingHandler)this.receiver).handleRequest(p0, $completion);
                }
            };
        } else {
            kFunction = (KFunction)new Function2<JSONRPCRequest, JSONRPCResponse>((Object)allowListHandler2){

                @Nullable
                public final Object invoke(@NotNull JSONRPCRequest p0, @NotNull Continuation<? super JSONRPCResponse> $completion) {
                    return ((MethodAllowListHandler)this.receiver).handleRequest(p0, $completion);
                }
            };
        }
        KFunction nextHandler2 = kFunction;
        ThrottlingHandler throttlingHandler = new ThrottlingHandler(this.config.maxConcurrentRequests(), (Function2)nextHandler2);
        LoggingHandler loggingHandler2 = new LoggingHandler((Function2)new Function2<JSONRPCRequest, JSONRPCResponse>((Object)throttlingHandler){

            @Nullable
            public final Object invoke(@NotNull JSONRPCRequest p0, @NotNull Continuation<? super JSONRPCResponse> $completion) {
                return ((ThrottlingHandler)this.receiver).handleRequest(p0, $completion);
            }
        }, "jsonrpclog");
        Intrinsics.checkNotNullExpressionValue((Object)successCounter, (String)"successCounter");
        Intrinsics.checkNotNullExpressionValue((Object)failureCounter, (String)"failureCounter");
        MeteredHandler handler2 = new MeteredHandler(successCounter, failureCounter, (Function2)new Function2<JSONRPCRequest, JSONRPCResponse>((Object)loggingHandler2){

            @Nullable
            public final Object invoke(@NotNull JSONRPCRequest p0, @NotNull Continuation<? super JSONRPCResponse> $completion) {
                return ((LoggingHandler)this.receiver).handleRequest(p0, $completion);
            }
        });
        int n = this.config.port();
        object = this.config.networkInterface();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"config.networkInterface()");
        Object object3 = object;
        boolean bl2 = this.config.ssl();
        boolean bl3 = this.config.useBasicAuthentication();
        String string4 = this.config.basicAuthUsername();
        String string5 = this.config.basicAuthPassword();
        object = this.config.basicAuthRealm();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"config.basicAuthRealm()");
        Object object4 = object;
        object = IPRangeChecker.create(this.config.allowedRanges(), this.config.rejectedRanges());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(config.allowedRan\u2026 config.rejectedRanges())");
        IPRangeChecker iPRangeChecker = object;
        OpenTelemetry openTelemetry = (OpenTelemetry)this.metricsService.getOpenTelemetry();
        object = Executors.newFixedThreadPool(this.config.numberOfThreads(), JSONRPCApplication::run$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newFixedThreadPool(\n    \u2026ue\n        thread\n      }");
        JSONRPCServer server2 = new JSONRPCServer(this.vertx, n, (String)object3, bl2, trustOptions, bl3, string4, string5, (String)object4, iPRangeChecker, openTelemetry, (CoroutineContext)ExecutorsKt.from((ExecutorService)object), (Function2)new Function2<JSONRPCRequest, JSONRPCResponse>((Object)handler2){

            @Nullable
            public final Object invoke(@NotNull JSONRPCRequest p0, @NotNull Continuation<? super JSONRPCResponse> $completion) {
                return ((MeteredHandler)this.receiver).handleRequest(p0, $completion);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> JSONRPCApplication.run$lambda-1(server2, client)));
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(server2, null){
            int label;
            final /* synthetic */ JSONRPCServer $server;
            {
                this.$server = $server;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$server.start((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        JSONRPCAppKt.getLogger().info("JSON-RPC server started");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final Thread run$lambda-0(Runnable it) {
        Thread thread = new Thread("jsonrpc");
        thread.setDaemon(true);
        return thread;
    }

    private static final void run$lambda-1(JSONRPCServer $server, JSONRPCClient $client) {
        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($server, $client, null){
            int label;
            final /* synthetic */ JSONRPCServer $server;
            final /* synthetic */ JSONRPCClient $client;
            {
                this.$server = $server;
                this.$client = $client;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$server.stop((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.$client.close();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }
}

