/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc.app;

import io.opentelemetry.api.OpenTelemetry;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.tracing.opentelemetry.OpenTelemetryOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.app.commons.ApplicationUtils;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.jsonrpc.app.JSONRPCApplication;
import org.apache.tuweni.jsonrpc.app.JSONRPCConfig;
import org.apache.tuweni.metrics.MetricsService;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/apache/tuweni/jsonrpc/app/JSONRPCApp;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "jsonrpc-app"})
public final class JSONRPCApp {
    @NotNull
    public static final JSONRPCApp INSTANCE = new JSONRPCApp();

    private JSONRPCApp() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (ArraysKt.contains((Object[])args, (Object)"--version")) {
            System.out.println((Object)("Apache Tuweni JSON-RPC proxy " + ApplicationUtils.INSTANCE.getVersion()));
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        if (ArraysKt.contains((Object[])args, (Object)"--help") || ArraysKt.contains((Object[])args, (Object)"-h")) {
            System.out.println((Object)"USAGE: jsonrpc <config file>");
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        ApplicationUtils.INSTANCE.renderBanner("Loading JSON-RPC proxy");
        Path configFile = Paths.get(!(args.length == 0) ? args[0] : "config.toml", new String[0]);
        Security.addProvider((Provider)new BouncyCastleProvider());
        JSONRPCConfig config = new JSONRPCConfig(configFile);
        if (config.getConfig().hasErrors()) {
            for (ConfigurationError error : config.getConfig().errors()) {
                System.out.println((Object)error.getMessage());
            }
            System.exit(1);
        }
        int error = config.metricsPort();
        String string = config.metricsNetworkInterface();
        boolean bl = config.metricsGrpcPushEnabled();
        boolean bl2 = config.metricsPrometheusEnabled();
        String string2 = config.metricsGrpcEndpoint();
        long l = config.metricsGrpcTimeout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"metricsNetworkInterface()");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"metricsGrpcEndpoint()");
        MetricsService metricsService = new MetricsService("json-rpc", 0L, error, string, bl2, bl, string2, l, 2, null);
        Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setTracingOptions((TracingOptions)new OpenTelemetryOptions((OpenTelemetry)metricsService.getOpenTelemetry())));
        Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
        JSONRPCApplication app = new JSONRPCApplication(vertx, config, metricsService, null, 8, null);
        app.run();
    }
}

