/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.hash;

import io.vertx.ext.auth.HashString;
import io.vertx.ext.auth.HashingAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public abstract class AbstractMDHash
implements HashingAlgorithm {
    private static final Base64.Encoder B64ENC = Base64.getEncoder().withoutPadding();
    private final MessageDigest md;

    AbstractMDHash(String algorithm) {
        try {
            this.md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(algorithm + " is not available", nsae);
        }
    }

    @Override
    public String hash(HashString hashString, String password) {
        return B64ENC.encodeToString(this.md.digest(password.getBytes(StandardCharsets.UTF_8)));
    }
}

