/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.blockprocessor;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.blockprocessor.ProtoBlockBody;
import org.apache.tuweni.blockprocessor.SealableHeader;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Block;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.TransactionReceipt;
import org.apache.tuweni.eth.repository.TransientStateRepository;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt64;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJD\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/apache/tuweni/blockprocessor/ProtoBlock;", "", "header", "Lorg/apache/tuweni/blockprocessor/SealableHeader;", "body", "Lorg/apache/tuweni/blockprocessor/ProtoBlockBody;", "transactionReceipts", "", "Lorg/apache/tuweni/eth/TransactionReceipt;", "stateChanges", "Lorg/apache/tuweni/eth/repository/TransientStateRepository;", "(Lorg/apache/tuweni/blockprocessor/SealableHeader;Lorg/apache/tuweni/blockprocessor/ProtoBlockBody;Ljava/util/List;Lorg/apache/tuweni/eth/repository/TransientStateRepository;)V", "getBody", "()Lorg/apache/tuweni/blockprocessor/ProtoBlockBody;", "getHeader", "()Lorg/apache/tuweni/blockprocessor/SealableHeader;", "getStateChanges", "()Lorg/apache/tuweni/eth/repository/TransientStateRepository;", "getTransactionReceipts", "()Ljava/util/List;", "toBlock", "Lorg/apache/tuweni/eth/Block;", "ommers", "Lorg/apache/tuweni/eth/BlockHeader;", "coinbase", "Lorg/apache/tuweni/eth/Address;", "difficulty", "Lorg/apache/tuweni/units/bigints/UInt256;", "timestamp", "Ljava/time/Instant;", "extraData", "Lorg/apache/tuweni/bytes/Bytes;", "mixHash", "Lorg/apache/tuweni/eth/Hash;", "nonce", "Lorg/apache/tuweni/units/bigints/UInt64;", "eth-blockprocessor"})
public final class ProtoBlock {
    @NotNull
    private final SealableHeader header;
    @NotNull
    private final ProtoBlockBody body;
    @NotNull
    private final List<TransactionReceipt> transactionReceipts;
    @NotNull
    private final TransientStateRepository stateChanges;

    public ProtoBlock(@NotNull SealableHeader header, @NotNull ProtoBlockBody body, @NotNull List<TransactionReceipt> transactionReceipts, @NotNull TransientStateRepository stateChanges) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(transactionReceipts, (String)"transactionReceipts");
        Intrinsics.checkNotNullParameter((Object)stateChanges, (String)"stateChanges");
        this.header = header;
        this.body = body;
        this.transactionReceipts = transactionReceipts;
        this.stateChanges = stateChanges;
    }

    @NotNull
    public final SealableHeader getHeader() {
        return this.header;
    }

    @NotNull
    public final ProtoBlockBody getBody() {
        return this.body;
    }

    @NotNull
    public final List<TransactionReceipt> getTransactionReceipts() {
        return this.transactionReceipts;
    }

    @NotNull
    public final TransientStateRepository getStateChanges() {
        return this.stateChanges;
    }

    @NotNull
    public final Block toBlock(@NotNull List<BlockHeader> ommers, @NotNull Address coinbase, @NotNull UInt256 difficulty, @NotNull Instant timestamp, @NotNull Bytes extraData, @NotNull Hash mixHash, @NotNull UInt64 nonce) {
        Intrinsics.checkNotNullParameter(ommers, (String)"ommers");
        Intrinsics.checkNotNullParameter((Object)coinbase, (String)"coinbase");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter((Object)mixHash, (String)"mixHash");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Hash ommersHash = Hash.hash((Bytes)RLP.encodeList(arg_0 -> ProtoBlock.toBlock$lambda-1(ommers, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)ommersHash, (String)"ommersHash");
        return new Block(this.header.toHeader(ommersHash, coinbase, difficulty, timestamp, extraData, mixHash, nonce), this.body.toBlockBody(ommers));
    }

    private static final void toBlock$lambda-1(List $ommers, RLPWriter writer) {
        Intrinsics.checkNotNullParameter((Object)$ommers, (String)"$ommers");
        Iterable $this$forEach$iv = $ommers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockHeader it = (BlockHeader)element$iv;
            boolean bl = false;
            writer.writeValue((Bytes)it.getHash());
        }
    }
}

