/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.Cache;
import org.infinispan.security.Security;
import org.infinispan.security.impl.SecureCacheImpl;

final class SecurityActions {
    private SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : Security.doPrivileged(action);
    }

    static <K, V> Cache<K, V> getUnwrappedCache(Cache<K, V> cache) {
        if (cache instanceof SecureCacheImpl) {
            return SecurityActions.doPrivileged(((SecureCacheImpl)cache)::getDelegate);
        }
        return cache;
    }
}

