/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.opentelemetry.api.metrics.BoundLongCounter;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.exporter.otlp.internal.SpanAdapter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import io.opentelemetry.proto.collector.trace.v1.TraceServiceGrpc;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private static final String EXPORTER_NAME = OtlpGrpcSpanExporter.class.getSimpleName();
    private static final Labels EXPORTER_NAME_LABELS = Labels.of((String)"exporter", (String)EXPORTER_NAME);
    private static final Labels EXPORT_SUCCESS_LABELS = Labels.of((String)"exporter", (String)EXPORTER_NAME, (String)"success", (String)"true");
    private static final Labels EXPORT_FAILURE_LABELS = Labels.of((String)"exporter", (String)EXPORTER_NAME, (String)"success", (String)"false");
    private final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(OtlpGrpcSpanExporter.class.getName()));
    private final TraceServiceGrpc.TraceServiceFutureStub traceService;
    private final ManagedChannel managedChannel;
    private final long timeoutNanos;
    private final BoundLongCounter spansSeen;
    private final BoundLongCounter spansExportedSuccess;
    private final BoundLongCounter spansExportedFailure;

    OtlpGrpcSpanExporter(ManagedChannel channel, long timeoutNanos) {
        Meter meter = GlobalMeterProvider.getMeter((String)"io.opentelemetry.exporters.otlp");
        this.spansSeen = meter.longCounterBuilder("spansSeenByExporter").build().bind(EXPORTER_NAME_LABELS);
        LongCounter spansExportedCounter = meter.longCounterBuilder("spansExportedByExporter").build();
        this.spansExportedSuccess = spansExportedCounter.bind(EXPORT_SUCCESS_LABELS);
        this.spansExportedFailure = spansExportedCounter.bind(EXPORT_FAILURE_LABELS);
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        this.traceService = TraceServiceGrpc.newFutureStub((Channel)channel);
    }

    public CompletableResultCode export(final Collection<SpanData> spans) {
        this.spansSeen.add((long)spans.size());
        ExportTraceServiceRequest exportTraceServiceRequest = ExportTraceServiceRequest.newBuilder().addAllResourceSpans((Iterable)SpanAdapter.toProtoResourceSpans(spans)).build();
        final CompletableResultCode result = new CompletableResultCode();
        TraceServiceGrpc.TraceServiceFutureStub exporter = this.timeoutNanos > 0L ? (TraceServiceGrpc.TraceServiceFutureStub)this.traceService.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS) : this.traceService;
        Futures.addCallback((ListenableFuture)exporter.export(exportTraceServiceRequest), (FutureCallback)new FutureCallback<ExportTraceServiceResponse>(){

            public void onSuccess(@Nullable ExportTraceServiceResponse response) {
                OtlpGrpcSpanExporter.this.spansExportedSuccess.add((long)spans.size());
                result.succeed();
            }

            public void onFailure(Throwable t) {
                OtlpGrpcSpanExporter.this.spansExportedFailure.add((long)spans.size());
                Status status = Status.fromThrowable((Throwable)t);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.SEVERE, "Failed to export spans. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. Full error message: " + t.getMessage());
                        break;
                    }
                    case UNAVAILABLE: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.SEVERE, "Failed to export spans. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + t.getMessage());
                        break;
                    }
                    default: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.WARNING, "Failed to export spans. Error message: " + t.getMessage());
                    }
                }
                if (OtlpGrpcSpanExporter.this.logger.isLoggable(Level.FINEST)) {
                    OtlpGrpcSpanExporter.this.logger.log(Level.FINEST, "Failed to export spans. Details follow: " + t);
                }
                result.fail();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        this.managedChannel.notifyWhenStateChanged(ConnectivityState.SHUTDOWN, () -> ((CompletableResultCode)result).succeed());
        this.managedChannel.shutdown();
        this.spansSeen.unbind();
        this.spansExportedSuccess.unbind();
        this.spansExportedFailure.unbind();
        return result;
    }

    long getTimeoutNanos() {
        return this.timeoutNanos;
    }
}

