/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.api.metrics.Meter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.apache.tuweni.eth.crawler.ClientIdInfo;
import org.apache.tuweni.eth.crawler.ClientInfo;
import org.apache.tuweni.eth.crawler.ClientReadyStats;
import org.apache.tuweni.eth.crawler.RelationalPeerRepository;
import org.apache.tuweni.eth.crawler.UpgradeConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0000\u00a2\u0006\u0002\b\"J%\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u00140\u0014H\u0000\u00a2\u0006\u0002\b$J\u0019\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u001fH\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020(J\u0011\u0010*\u001a\u00020(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u001c\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0014\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u0010*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006-"}, d2={"Lorg/apache/tuweni/eth/crawler/StatsJob;", "Lkotlinx/coroutines/CoroutineScope;", "repo", "Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository;", "upgradeConfigs", "", "Lorg/apache/tuweni/eth/crawler/UpgradeConfig;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "clientsStatsDelay", "", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository;Ljava/util/List;Lio/opentelemetry/api/metrics/Meter;JLkotlin/coroutines/CoroutineContext;)V", "clientCalculationsCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "clientIds", "Lorg/apache/tuweni/eth/crawler/ClientInfo;", "clientsStats", "", "", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "job", "Lkotlinx/coroutines/Job;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "totalClientsGauge", "Lio/opentelemetry/api/metrics/LongValueRecorder;", "upgradeStats", "", "Lorg/apache/tuweni/eth/crawler/ClientReadyStats;", "getClientIds", "getClientIds$eth_crawler", "getClientStats", "getClientStats$eth_crawler", "getUpgradeStats", "getUpgradeStats$eth_crawler", "runStats", "", "start", "stop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "eth-crawler"})
public final class StatsJob
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RelationalPeerRepository repo;
    @NotNull
    private final List<UpgradeConfig> upgradeConfigs;
    @NotNull
    private final Meter meter;
    private final long clientsStatsDelay;
    @NotNull
    private final CoroutineContext coroutineContext;
    @Nullable
    private List<ClientInfo> clientIds;
    @Nullable
    private Map<String, ? extends Map<String, Long>> clientsStats;
    @NotNull
    private Map<String, ClientReadyStats> upgradeStats;
    @NotNull
    private final AtomicBoolean started;
    @Nullable
    private Job job;
    private final LongValueRecorder totalClientsGauge;
    private final LongCounter clientCalculationsCounter;
    private static final Logger logger = LoggerFactory.getLogger(StatsJob.class);

    public StatsJob(@NotNull RelationalPeerRepository repo, @NotNull List<UpgradeConfig> upgradeConfigs, @NotNull Meter meter, long clientsStatsDelay, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter(upgradeConfigs, (String)"upgradeConfigs");
        Intrinsics.checkNotNullParameter((Object)meter, (String)"meter");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.repo = repo;
        this.upgradeConfigs = upgradeConfigs;
        this.meter = meter;
        this.clientsStatsDelay = clientsStatsDelay;
        this.coroutineContext = coroutineContext;
        this.upgradeStats = new LinkedHashMap();
        this.started = new AtomicBoolean(false);
        this.totalClientsGauge = this.meter.longValueRecorderBuilder("totalClients").setDescription("Number of nodes used to compute client stats").build();
        this.clientCalculationsCounter = this.meter.longCounterBuilder("clients").setDescription("Number of times clients were computed").build();
    }

    public /* synthetic */ StatsJob(RelationalPeerRepository relationalPeerRepository, List list, Meter meter, long l, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            l = 30000L;
        }
        if ((n & 0x10) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(relationalPeerRepository, list, meter, l, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public final void start() {
        logger.info("Starting stats job");
        this.job = BuildersKt.launch((CoroutineScope)this, (CoroutineContext)this.getCoroutineContext(), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StatsJob this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        StatsJob.Companion.getLogger$eth_crawler().info("Computing client ids");
                        StatsJob.access$getStarted$p(this.this$0).set(true);
lbl7:
                        // 3 sources

                        while (StatsJob.access$getStarted$p(this.this$0).get()) {
                            try {
                                StatsJob.access$runStats(this.this$0);
                            }
                            catch (Exception e) {
                                StatsJob.Companion.getLogger$eth_crawler().error("Error while computing stats", (Throwable)e);
                            }
                            this.label = 1;
                            v0 = DelayKt.delay((long)StatsJob.access$getClientsStatsDelay$p(this.this$0), (Continuation)((Continuation)this));
                            if (v0 != var3_2) continue;
                            return var3_2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void runStats() {
        logger.info("runStats");
        List<ClientInfo> newClientIds = this.repo.getClientIdsInternal$eth_crawler();
        logger.info("Found client ids " + newClientIds.size());
        this.clientIds = newClientIds;
        Map newClientsStats = new LinkedHashMap();
        int total = newClientIds.stream().mapToInt(StatsJob::runStats$lambda-0).sum();
        Iterable $this$forEach$iv = newClientIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientInfo newClientCount = (ClientInfo)element$iv;
            boolean bl = false;
            ClientIdInfo clientIdInfo = new ClientIdInfo(newClientCount.getClientId());
            Map map = newClientsStats.computeIfAbsent(clientIdInfo.getName(), StatsJob::runStats$lambda-2$lambda-1);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"newClientsStats.computeI\u2026.name) { mutableMapOf() }");
            Map versionStats = map;
            Long l = (Long)versionStats.get(clientIdInfo.getVersion());
            long statsCount = l == null ? 0L : l;
            versionStats.put(clientIdInfo.getVersion(), statsCount + (long)newClientCount.getCount());
        }
        for (UpgradeConfig upgradeConfig : this.upgradeConfigs) {
            int upgradeReady = 0;
            Iterable $this$forEach$iv2 = newClientIds;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String upgradeVersion;
                ClientInfo newClientCount = (ClientInfo)element$iv;
                boolean bl = false;
                ClientIdInfo clientIdInfo = new ClientIdInfo(newClientCount.getClientId());
                Map<String, String> map = upgradeConfig.getVersions();
                String statsCount = clientIdInfo.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)statsCount, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (map.get(statsCount) == null) continue;
                boolean bl2 = false;
                if (clientIdInfo.compareTo(upgradeVersion) < 0) continue;
                upgradeReady += newClientCount.getCount();
            }
            this.upgradeStats.put(upgradeConfig.getName(), new ClientReadyStats(total, upgradeReady));
        }
        this.clientsStats = newClientsStats;
        this.totalClientsGauge.record((long)total);
        this.clientCalculationsCounter.add(1L);
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        this.started.set(false);
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        Job job2 = this.job;
        if (job2 != null) {
            Object object = job2.join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (null == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return null;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final Map<String, ClientReadyStats> getUpgradeStats$eth_crawler() {
        return this.upgradeStats;
    }

    @NotNull
    public final List<ClientInfo> getClientIds$eth_crawler() {
        List<ClientInfo> list = this.clientIds;
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @NotNull
    public final Map<String, Map<String, Long>> getClientStats$eth_crawler() {
        Map<String, Map<String, Long>> map = this.clientsStats;
        return map == null ? MapsKt.emptyMap() : map;
    }

    private static final int runStats$lambda-0(ClientInfo it) {
        return it.getCount();
    }

    private static final Map runStats$lambda-2$lambda-1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    public static final /* synthetic */ AtomicBoolean access$getStarted$p(StatsJob $this) {
        return $this.started;
    }

    public static final /* synthetic */ void access$runStats(StatsJob $this) {
        $this.runStats();
    }

    public static final /* synthetic */ long access$getClientsStatsDelay$p(StatsJob $this) {
        return $this.clientsStatsDelay;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/eth/crawler/StatsJob$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger$eth_crawler", "()Lorg/slf4j/Logger;", "eth-crawler"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$eth_crawler() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

