/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.ExpiringMap;
import org.apache.tuweni.concurrent.coroutines.AsyncResultKt;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.EnodeUriComponents;
import org.apache.tuweni.devp2p.EnodeUriKt;
import org.apache.tuweni.devp2p.Peer;
import org.apache.tuweni.devp2p.PeerRepository;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.eth.crawler.ClientInfo;
import org.apache.tuweni.eth.crawler.PeerConnectionInfo;
import org.apache.tuweni.eth.crawler.PeerConnectionInfoDetails;
import org.apache.tuweni.eth.crawler.RelationalPeerRepository;
import org.apache.tuweni.eth.crawler.RepositoryPeer;
import org.apache.tuweni.rlpx.wire.HelloMessage;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0001=B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0016\u001a\u00020\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0019\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100$2\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0013\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0000\u00a2\u0006\u0002\b(J\u001f\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b-J5\u0010.\u001a\b\u0012\u0004\u0012\u00020/0&2\u0006\u0010+\u001a\u00020\u00062\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0004\b2\u00103J5\u00104\u001a\b\u0012\u0004\u0012\u00020*0&2\u0006\u0010+\u001a\u00020\u00062\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0004\b5\u00103J'\u00106\u001a\b\u0012\u0004\u0012\u00020/0&2\b\b\u0002\u00100\u001a\u00020\u001e2\b\b\u0002\u00101\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b7J\u0018\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006>"}, d2={"Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/apache/tuweni/devp2p/PeerRepository;", "dataSource", "Ljavax/sql/DataSource;", "expiration", "", "clientIdsInterval", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljavax/sql/DataSource;JJLkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "listeners", "", "Lkotlin/Function1;", "Lorg/apache/tuweni/devp2p/Peer;", "", "peerCache", "Lorg/apache/tuweni/concurrent/ExpiringMap;", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "", "addListener", "listener", "get", "uri", "Ljava/net/URI;", "(Ljava/net/URI;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "host", "port", "", "nodeId", "(Ljava/lang/String;ILorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endpoint", "Lorg/apache/tuweni/devp2p/Endpoint;", "getAsync", "Lorg/apache/tuweni/concurrent/AsyncResult;", "getClientIdsInternal", "", "Lorg/apache/tuweni/eth/crawler/ClientInfo;", "getClientIdsInternal$eth_crawler", "getPeerWithInfo", "Lorg/apache/tuweni/eth/crawler/PeerConnectionInfoDetails;", "infoCollected", "publicKey", "getPeerWithInfo$eth_crawler", "getPeers", "Lorg/apache/tuweni/eth/crawler/PeerConnectionInfo;", "from", "limit", "getPeers$eth_crawler", "(JLjava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "getPeersWithInfo", "getPeersWithInfo$eth_crawler", "getPendingPeers", "getPendingPeers$eth_crawler", "recordInfo", "wireConnection", "Lorg/apache/tuweni/rlpx/wire/WireConnection;", "status", "Lorg/apache/tuweni/devp2p/eth/Status;", "Companion", "eth-crawler"})
public class RelationalPeerRepository
implements CoroutineScope,
PeerRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSource dataSource;
    private final long expiration;
    private final long clientIdsInterval;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final List<Function1<Peer, Unit>> listeners;
    @NotNull
    private final ExpiringMap<SECP256K1.PublicKey, String> peerCache;
    private static final Logger logger = LoggerFactory.getLogger(RelationalPeerRepository.class);

    public RelationalPeerRepository(@NotNull DataSource dataSource, long expiration, long clientIdsInterval, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.dataSource = dataSource;
        this.expiration = expiration;
        this.clientIdsInterval = clientIdsInterval;
        this.coroutineContext = coroutineContext;
        this.listeners = new ArrayList();
        this.peerCache = new ExpiringMap();
    }

    public /* synthetic */ RelationalPeerRepository(DataSource dataSource, long l, long l2, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 300000L;
        }
        if ((n & 4) != 0) {
            l2 = 172800000L;
        }
        if ((n & 8) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(dataSource, l, l2, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public void addListener(@NotNull Function1<? super Peer, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Nullable
    public Object get(@NotNull String host, int port, @NotNull SECP256K1.PublicKey nodeId, @NotNull Continuation<? super Peer> $completion) {
        return this.get(nodeId, new Endpoint(host, port, null, 4, null));
    }

    @NotNull
    public final Peer get(@NotNull SECP256K1.PublicKey nodeId, @NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String id = (String)this.peerCache.computeIfAbsent((Object)nodeId, this.expiration, arg_0 -> RelationalPeerRepository.get$lambda-2(this, nodeId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
        return new RepositoryPeer(nodeId, id, endpoint, this.dataSource);
    }

    @Nullable
    public Object get(@NotNull URI uri, @NotNull Continuation<? super Peer> $completion) {
        return RelationalPeerRepository.get$suspendImpl(this, uri, $completion);
    }

    static /* synthetic */ Object get$suspendImpl(RelationalPeerRepository this_, URI uri, Continuation $completion) {
        EnodeUriComponents enodeUriComponents = EnodeUriKt.parseEnodeUri((URI)uri);
        SECP256K1.PublicKey nodeId = enodeUriComponents.component1();
        Endpoint endpoint = enodeUriComponents.component2();
        return this_.get(nodeId, endpoint);
    }

    @NotNull
    public AsyncResult<Peer> getAsync(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return AsyncResultKt.asyncResult$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Peer>, Object>(this, uri, null){
            int label;
            final /* synthetic */ RelationalPeerRepository this$0;
            final /* synthetic */ URI $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.get(this.$uri, (Continuation<? super Peer>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Peer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public AsyncResult<Peer> getAsync(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return AsyncResultKt.asyncResult$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Peer>, Object>(this, uri, null){
            int label;
            final /* synthetic */ RelationalPeerRepository this$0;
            final /* synthetic */ String $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.get(this.$uri, (Continuation<? super Peer>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Peer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordInfo(@NotNull WireConnection wireConnection, @Nullable Status status) {
        Intrinsics.checkNotNullParameter((Object)wireConnection, (String)"wireConnection");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection conn = (Connection)autoCloseable;
            boolean bl2 = false;
            Object object = wireConnection.peerPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wireConnection.peerPublicKey()");
            SECP256K1.PublicKey publicKey = object;
            object = wireConnection.peerHost();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wireConnection.peerHost()");
            RepositoryPeer peer = (RepositoryPeer)this.get(publicKey, new Endpoint((String)object, wireConnection.peerPort(), null, 4, null));
            PreparedStatement stmt = conn.prepareStatement("insert into nodeInfo(id, createdAt, host, port, publickey, p2pVersion, clientId, capabilities, genesisHash, bestHash, totalDifficulty, identity, disconnectReason) values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                int n;
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl3 = false;
                HelloMessage peerHello = wireConnection.getPeerHello();
                it.setString(1, UUID.randomUUID().toString());
                it.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                it.setString(3, wireConnection.peerHost());
                it.setInt(4, wireConnection.peerPort());
                it.setBytes(5, wireConnection.peerPublicKey().bytesArray());
                HelloMessage helloMessage = peerHello;
                it.setInt(6, helloMessage == null ? 0 : (n = helloMessage.p2pVersion()));
                HelloMessage helloMessage2 = peerHello;
                if (helloMessage2 == null) {
                    string5 = "";
                } else {
                    string5 = helloMessage2.clientId();
                    if (string5 == null) {
                        string5 = "";
                    }
                }
                it.setString(7, string5);
                HelloMessage helloMessage3 = peerHello;
                if (helloMessage3 == null) {
                    string4 = "";
                } else {
                    List list = helloMessage3.capabilities();
                    if (list == null) {
                        string4 = "";
                    } else {
                        string4 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)recordInfo.1.1.1.INSTANCE, (int)30, null);
                        if (string4 == null) {
                            string4 = "";
                        }
                    }
                }
                it.setString(8, string4);
                Status status2 = status;
                if (status2 == null) {
                    string3 = null;
                } else {
                    Bytes32 bytes32 = status2.getGenesisHash();
                    string3 = bytes32 == null ? null : bytes32.toHexString();
                }
                it.setString(9, string3);
                Status status3 = status;
                if (status3 == null) {
                    string2 = null;
                } else {
                    Bytes32 bytes32 = status3.getBestHash();
                    string2 = bytes32 == null ? null : bytes32.toHexString();
                }
                it.setString(10, string2);
                Status status4 = status;
                if (status4 == null) {
                    string = null;
                } else {
                    UInt256 uInt256 = status4.getTotalDifficulty();
                    string = uInt256 == null ? null : uInt256.toHexString();
                }
                it.setString(11, string);
                it.setString(12, peer.getId());
                it.setString(13, wireConnection.getDisconnectReason().text);
                bl = it.execute();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            boolean bl4 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PeerConnectionInfo> getPeers$eth_crawler(long infoCollected, @Nullable Integer from, @Nullable Integer limit) {
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            List list;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            Object query = "select distinct nodeinfo.host, nodeinfo.port, nodeinfo.publickey from nodeinfo \n  inner join (select id, max(createdAt) as maxCreatedAt from nodeinfo group by id) maxSeen \n  on nodeinfo.id = maxSeen.id and nodeinfo.createdAt = maxSeen.maxCreatedAt where createdAt < ?";
            if (from != null && limit != null) {
                query = (String)query + " limit " + limit + " offset " + from;
            }
            PreparedStatement stmt = conn.prepareStatement((String)query);
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                it.setTimestamp(1, new Timestamp(infoCollected));
                ResultSet rs = stmt.executeQuery();
                List result = new ArrayList();
                while (rs.next()) {
                    SECP256K1.PublicKey pubkey = SECP256K1.PublicKey.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(3)));
                    int port = rs.getInt(2);
                    String host = rs.getString(1);
                    Intrinsics.checkNotNullExpressionValue((Object)pubkey, (String)"pubkey");
                    Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
                    result.add(new PeerConnectionInfo(pubkey, host, port));
                }
                list = result;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            List list2 = list;
            return list2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ List getPeers$eth_crawler$default(RelationalPeerRepository relationalPeerRepository, long l, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPeers");
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return relationalPeerRepository.getPeers$eth_crawler(l, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PeerConnectionInfoDetails> getPeersWithInfo$eth_crawler(long infoCollected, @Nullable Integer from, @Nullable Integer limit) {
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            List list;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            Object query = "select distinct nodeinfo.createdAt, nodeinfo.publickey, nodeinfo.p2pversion, nodeinfo.clientId, nodeinfo.capabilities, nodeinfo.genesisHash, nodeinfo.besthash, nodeinfo.totalDifficulty from nodeinfo   inner join (select identity, max(createdAt) as maxCreatedAt from nodeinfo group by identity) maxSeen   on nodeinfo.identity = maxSeen.identity and nodeinfo.createdAt = maxSeen.maxCreatedAt where createdAt < ? order by nodeInfo.createdAt desc";
            if (from != null && limit != null) {
                query = (String)query + " limit " + limit + " offset " + from;
            }
            PreparedStatement stmt = conn.prepareStatement((String)query);
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                it.setTimestamp(1, new Timestamp(infoCollected));
                ResultSet rs = stmt.executeQuery();
                List result = new ArrayList();
                while (rs.next()) {
                    String string;
                    String bestHash;
                    String string2;
                    String genesisHash;
                    String string3;
                    String capabilities;
                    String string4;
                    String clientId;
                    long createdAt = rs.getTimestamp(1).toInstant().toEpochMilli();
                    SECP256K1.PublicKey pubkey = SECP256K1.PublicKey.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(2)));
                    int p2pVersion = rs.getInt(3);
                    String string5 = rs.getString(4);
                    if (string5 == null) {
                        string5 = clientId = "";
                    }
                    if ((string4 = rs.getString(5)) == null) {
                        string4 = capabilities = "";
                    }
                    if ((string3 = rs.getString(6)) == null) {
                        string3 = genesisHash = "";
                    }
                    if ((string2 = rs.getString(7)) == null) {
                        string2 = bestHash = "";
                    }
                    if ((string = rs.getString(8)) == null) {
                        string = "";
                    }
                    String totalDifficulty = string;
                    Intrinsics.checkNotNullExpressionValue((Object)pubkey, (String)"pubkey");
                    result.add(new PeerConnectionInfoDetails(createdAt, pubkey, p2pVersion, clientId, capabilities, genesisHash, bestHash, totalDifficulty));
                }
                list = result;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            List list2 = list;
            return list2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ List getPeersWithInfo$eth_crawler$default(RelationalPeerRepository relationalPeerRepository, long l, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPeersWithInfo");
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return relationalPeerRepository.getPeersWithInfo$eth_crawler(l, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PeerConnectionInfo> getPendingPeers$eth_crawler(int from, int limit) {
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            List list;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            PreparedStatement stmt = conn.prepareStatement("select endpoint.host, endpoint.port, identity.publickey from endpoint inner join identity on (endpoint.identity = identity.id) where endpoint.identity NOT IN (select identity from nodeinfo) order by endpoint.lastSeen desc limit " + limit + " offset " + from);
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                ResultSet rs = stmt.executeQuery();
                List result = new ArrayList();
                while (rs.next()) {
                    SECP256K1.PublicKey pubkey = SECP256K1.PublicKey.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(3)));
                    int port = rs.getInt(2);
                    String host = rs.getString(1);
                    Intrinsics.checkNotNullExpressionValue((Object)pubkey, (String)"pubkey");
                    Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
                    result.add(new PeerConnectionInfo(pubkey, host, port));
                }
                list = result;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            List list2 = list;
            return list2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ List getPendingPeers$eth_crawler$default(RelationalPeerRepository relationalPeerRepository, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPendingPeers");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 100;
        }
        return relationalPeerRepository.getPendingPeers$eth_crawler(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ClientInfo> getClientIdsInternal$eth_crawler() {
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            List list;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            String sql = "select clients.clientId, count(clients.clientId) from (select nodeinfo.clientId, nodeInfo.createdAt from nodeinfo inner join (select identity, max(createdAt) as maxCreatedAt from nodeinfo group by identity) maxSeen on nodeinfo.identity = maxSeen.identity and nodeinfo.createdAt = maxSeen.maxCreatedAt) as clients where clients.createdAt > ? group by clients.clientId";
            PreparedStatement stmt = conn.prepareStatement(sql);
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                long time = System.currentTimeMillis() - this.clientIdsInterval;
                logger.info("Logging client ids query: " + sql + " with " + time);
                it.setTimestamp(1, new Timestamp(time));
                ResultSet rs = stmt.executeQuery();
                List result = new ArrayList();
                while (rs.next()) {
                    String clientId = rs.getString(1);
                    int count = rs.getInt(2);
                    Intrinsics.checkNotNullExpressionValue((Object)clientId, (String)"clientId");
                    result.add(new ClientInfo(clientId, count));
                }
                list = result;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            List list2 = list;
            return list2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PeerConnectionInfoDetails getPeerWithInfo$eth_crawler(long infoCollected, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            PeerConnectionInfoDetails peerConnectionInfoDetails;
            Throwable throwable2;
            AutoCloseable autoCloseable2;
            block17: {
                String string;
                String bestHash;
                String string2;
                String genesisHash;
                String string3;
                String capabilities;
                String string4;
                String clientId;
                Connection conn = (Connection)autoCloseable;
                boolean bl = false;
                String query = "select distinct nodeinfo.createdAt, nodeinfo.publickey, nodeinfo.p2pversion, nodeinfo.clientId, nodeinfo.capabilities, nodeinfo.genesisHash, nodeinfo.besthash, nodeinfo.totalDifficulty from nodeinfo   inner join (select identity, max(createdAt) as maxCreatedAt from nodeinfo group by identity) maxSeen   on nodeinfo.identity = maxSeen.identity and nodeinfo.createdAt = maxSeen.maxCreatedAt where createdAt < ? and nodeinfo.publickey = ? order by nodeInfo.createdAt desc";
                PreparedStatement stmt = conn.prepareStatement(query);
                autoCloseable2 = stmt;
                throwable2 = null;
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                it.setTimestamp(1, new Timestamp(infoCollected));
                it.setBytes(2, Bytes.fromHexString((CharSequence)publicKey).toArrayUnsafe());
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block17;
                long createdAt = rs.getTimestamp(1).toInstant().toEpochMilli();
                SECP256K1.PublicKey pubkey = SECP256K1.PublicKey.fromBytes((Bytes)Bytes.wrap((byte[])rs.getBytes(2)));
                int p2pVersion = rs.getInt(3);
                String string5 = rs.getString(4);
                if (string5 == null) {
                    string5 = clientId = "";
                }
                if ((string4 = rs.getString(5)) == null) {
                    string4 = capabilities = "";
                }
                if ((string3 = rs.getString(6)) == null) {
                    string3 = genesisHash = "";
                }
                if ((string2 = rs.getString(7)) == null) {
                    string2 = bestHash = "";
                }
                if ((string = rs.getString(8)) == null) {
                    string = "";
                }
                String totalDifficulty = string;
                Intrinsics.checkNotNullExpressionValue((Object)pubkey, (String)"pubkey");
                PeerConnectionInfoDetails peerConnectionInfoDetails2 = new PeerConnectionInfoDetails(createdAt, pubkey, p2pVersion, clientId, capabilities, genesisHash, bestHash, totalDifficulty);
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                PeerConnectionInfoDetails peerConnectionInfoDetails3 = peerConnectionInfoDetails2;
                return peerConnectionInfoDetails3;
            }
            try {
                peerConnectionInfoDetails = null;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            PeerConnectionInfoDetails peerConnectionInfoDetails4 = peerConnectionInfoDetails;
            return peerConnectionInfoDetails4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Nullable
    public Object get(@NotNull String uri, @NotNull Continuation<? super Peer> $completion) {
        return PeerRepository.DefaultImpls.get((PeerRepository)this, (String)uri, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String get$lambda-2(RelationalPeerRepository this$0, SECP256K1.PublicKey $nodeId, SECP256K1.PublicKey it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nodeId, (String)"$nodeId");
        AutoCloseable autoCloseable = this$0.dataSource.getConnection();
        Throwable throwable = null;
        try {
            String string2;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            logger.trace("Get peer with " + $nodeId);
            PreparedStatement stmt = conn.prepareStatement("select id,publickey from identity where publickey=?");
            stmt.setBytes(1, $nodeId.bytes().toArrayUnsafe());
            ResultSet rs = stmt.executeQuery();
            AutoCloseable autoCloseable2 = rs;
            Throwable throwable2 = null;
            try {
                String string3;
                ResultSet it2 = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                if (!rs.next()) {
                    logger.debug("Creating new peer with public key " + $nodeId.toHexString());
                    String string4 = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"randomUUID().toString()");
                    String id = string4;
                    PreparedStatement insert = conn.prepareStatement("insert into identity(id, publickey) values(?, ?)");
                    insert.setString(1, id);
                    insert.setBytes(2, $nodeId.bytes().toArrayUnsafe());
                    insert.execute();
                    string3 = id;
                } else {
                    String id;
                    logger.trace("Found existing peer with public key " + $nodeId.toHexString());
                    string3 = id = rs.getString(1);
                }
                string2 = string3;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger$eth_crawler", "()Lorg/slf4j/Logger;", "eth-crawler"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$eth_crawler() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

