/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.net.tls;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.net.tls.TLSEnvironmentException;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public final class TLS {
    private TLS() {
    }

    public static boolean createSelfSignedCertificateIfMissing(Path key, Path certificate) throws IOException {
        return TLS.createSelfSignedCertificateIfMissing(key, certificate, null);
    }

    public static boolean createSelfSignedCertificateIfMissing(Path key, Path certificate, String commonName) throws IOException {
        if (Files.exists(certificate, new LinkOption[0]) || Files.exists(key, new LinkOption[0])) {
            return false;
        }
        Files.createDirectories(certificate.getParent(), new FileAttribute[0]);
        Files.createDirectories(key.getParent(), new FileAttribute[0]);
        Path keyFile = Files.createTempFile(key.getParent(), "client-key", ".tmp", new FileAttribute[0]);
        Path certFile = Files.createTempFile(certificate.getParent(), "client-cert", ".tmp", new FileAttribute[0]);
        try {
            TLS.createSelfSignedCertificate(new Date(), keyFile, certFile, commonName);
        }
        catch (NoSuchAlgorithmException | CertificateException | OperatorCreationException e) {
            throw new TLSEnvironmentException("Could not generate certificate: " + e.getMessage(), e);
        }
        Files.move(keyFile, key, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        Files.move(certFile, certificate, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    private static void createSelfSignedCertificate(Date now, Path key, Path certificate, String commonName) throws NoSuchAlgorithmException, IOException, OperatorCreationException, CertificateException {
        PemWriter pemWriter;
        KeyPairGenerator rsa = KeyPairGenerator.getInstance("RSA");
        rsa.initialize(2048, new SecureRandom());
        KeyPair keyPair = rsa.generateKeyPair();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(1, 1);
        Date yearFromNow = cal.getTime();
        if (commonName == null || ((String)commonName).isEmpty()) {
            commonName = UUID.randomUUID().toString() + ".com";
        }
        X500Name dn = new X500Name("CN=" + (String)commonName);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(dn, new BigInteger(64, new SecureRandom()), now, yearFromNow, dn, keyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(keyPair.getPrivate());
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(builder.build(signer));
        try (BufferedWriter writer = Files.newBufferedWriter(key, StandardCharsets.UTF_8, new OpenOption[0]);){
            pemWriter = new PemWriter((Writer)writer);
            try {
                pemWriter.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", keyPair.getPrivate().getEncoded()));
            }
            finally {
                pemWriter.close();
            }
        }
        writer = Files.newBufferedWriter(certificate, StandardCharsets.UTF_8, new OpenOption[0]);
        try {
            pemWriter = new PemWriter((Writer)writer);
            try {
                pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", x509Certificate.getEncoded()));
            }
            finally {
                pemWriter.close();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static byte[] readPemFile(Path certificate) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(certificate, StandardCharsets.UTF_8);){
            byte[] byArray;
            try (PemReader pemReader = new PemReader((Reader)reader);){
                PemObject pemObject = pemReader.readPemObject();
                byArray = pemObject.getContent();
            }
            return byArray;
        }
    }

    public static byte[] certificateFingerprint(Path certificate) throws IOException {
        return Hash.sha2_256((byte[])TLS.readPemFile(certificate));
    }

    public static String certificateHexFingerprint(Path certificate) throws IOException {
        return Bytes.wrap((byte[])TLS.certificateFingerprint(certificate)).toHexString().substring(2).toLowerCase();
    }

    public static byte[] certificateFingerprint(Certificate certificate) throws CertificateEncodingException {
        return Hash.sha2_256((byte[])certificate.getEncoded());
    }

    public static String certificateHexFingerprint(Certificate certificate) throws CertificateEncodingException {
        return Bytes.wrap((byte[])TLS.certificateFingerprint(certificate)).toHexString().substring(2).toLowerCase();
    }
}

