/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.concurrent;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ExpiringMap<K, V>
implements Map<K, V> {
    private final ConcurrentHashMap<K, ExpiringEntry<K, V>> storage = new ConcurrentHashMap();
    private final PriorityBlockingQueue<ExpiringEntry<K, V>> expiryQueue = new PriorityBlockingQueue();
    private final LongSupplier currentTimeSupplier;
    private final Long defaultTimeout;

    public ExpiringMap() {
        this(System::currentTimeMillis, Long.MAX_VALUE);
    }

    public ExpiringMap(Long defaultTimeout) {
        this(System::currentTimeMillis, defaultTimeout);
    }

    ExpiringMap(LongSupplier currentTimeSupplier, Long defaultTimeout) {
        this.currentTimeSupplier = currentTimeSupplier;
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    @Nullable
    public V get(Object key) {
        Objects.requireNonNull(key);
        this.purgeExpired();
        ExpiringEntry<K, V> entry = this.storage.get(key);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        return v != null ? v : defaultValue;
    }

    @Override
    public boolean containsKey(Object key) {
        Objects.requireNonNull(key);
        this.purgeExpired();
        return this.storage.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        this.purgeExpired();
        return this.storage.values().stream().anyMatch(e -> e.value.equals(value));
    }

    @Override
    public int size() {
        this.purgeExpired();
        return this.storage.size();
    }

    @Override
    public boolean isEmpty() {
        this.purgeExpired();
        return this.storage.isEmpty();
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.purgeExpired();
        ExpiringEntry<K, V> oldEntry = this.storage.put(key, new ExpiringEntry<K, V>(key, value, this.defaultTimeout, null));
        return oldEntry == null ? null : (V)oldEntry.value;
    }

    @Nullable
    public V put(K key, V value, long expiry) {
        return this.put(key, value, expiry, null);
    }

    @Nullable
    public V put(K key, V value, long expiry, @Nullable BiConsumer<K, V> expiryListener) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (expiry >= Long.MAX_VALUE) {
            return this.put(key, value);
        }
        long now = this.currentTimeSupplier.getAsLong();
        this.purgeExpired(now);
        if (expiry <= now) {
            V previous = this.remove(key);
            if (expiryListener != null) {
                expiryListener.accept(key, value);
            }
            return previous;
        }
        ExpiringEntry<K, V> newEntry = new ExpiringEntry<K, V>(key, value, expiry, expiryListener);
        ExpiringEntry<K, V> oldEntry = this.storage.put(key, newEntry);
        this.expiryQueue.offer(newEntry);
        if (oldEntry != null && oldEntry.expiry < Long.MAX_VALUE) {
            this.expiryQueue.remove(oldEntry);
        }
        return oldEntry == null ? null : (V)oldEntry.value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Objects.requireNonNull(m);
        this.purgeExpired();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.storage.put(e.getKey(), new ExpiringEntry<K, V>(e.getKey(), e.getValue(), this.defaultTimeout, null));
        }
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.purgeExpired();
        ExpiringEntry<K, V> oldEntry = this.storage.putIfAbsent(key, new ExpiringEntry<K, V>(key, value, this.defaultTimeout, null));
        return oldEntry == null ? null : (V)oldEntry.value;
    }

    @Nullable
    public V putIfAbsent(K key, V value, long expiry) {
        return this.putIfAbsent(key, value, expiry, null);
    }

    @Nullable
    public V putIfAbsent(K key, V value, long expiry, @Nullable BiConsumer<K, V> expiryListener) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (expiry >= Long.MAX_VALUE) {
            return this.put(key, value);
        }
        long now = this.currentTimeSupplier.getAsLong();
        this.purgeExpired(now);
        if (expiry <= now) {
            V previous = this.remove(key);
            if (expiryListener != null) {
                expiryListener.accept(key, value);
            }
            return previous;
        }
        ExpiringEntry<K, V> newEntry = new ExpiringEntry<K, V>(key, value, expiry, expiryListener);
        ExpiringEntry<K, V> oldEntry = this.storage.putIfAbsent(key, newEntry);
        if (oldEntry == null) {
            this.expiryQueue.offer(newEntry);
            return null;
        }
        return oldEntry.value;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        ExpiringEntry newEntry = this.storage.compute(key, (k, oldEntry) -> {
            if (oldEntry != null && oldEntry.expiry < Long.MAX_VALUE) {
                this.expiryQueue.remove(oldEntry);
            }
            Object oldValue = oldEntry == null ? null : (Object)oldEntry.value;
            Object newValue = remappingFunction.apply((K)k, (V)oldValue);
            return newValue == null ? null : new ExpiringEntry(k, newValue, this.defaultTimeout, null);
        });
        return newEntry == null ? null : (V)newEntry.value;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, this.defaultTimeout, mappingFunction);
    }

    public V computeIfAbsent(K key, long expiration, Function<? super K, ? extends V> mappingFunction) {
        ExpiringEntry newEntry = this.storage.computeIfAbsent(key, k -> {
            Object newValue = mappingFunction.apply((Object)k);
            return newValue == null ? null : new ExpiringEntry(k, newValue, expiration, null);
        });
        return newEntry == null ? null : (V)newEntry.value;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        ExpiringEntry newEntry = this.storage.computeIfPresent(key, (k, oldEntry) -> {
            Object newValue;
            if (oldEntry.expiry < Long.MAX_VALUE) {
                this.expiryQueue.remove(oldEntry);
            }
            return (newValue = remappingFunction.apply((K)k, (V)oldEntry.value)) == null ? null : new ExpiringEntry(k, newValue, this.defaultTimeout, null);
        });
        return newEntry == null ? null : (V)newEntry.value;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        ExpiringEntry entry = this.storage.merge(key, new ExpiringEntry<K, V>(key, value, this.defaultTimeout, null), (oldEntry, newEntry) -> {
            Object newValue;
            if (oldEntry.expiry < Long.MAX_VALUE) {
                this.expiryQueue.remove(oldEntry);
            }
            return (newValue = remappingFunction.apply((V)oldEntry.value, (V)newEntry.value)) == null ? null : new ExpiringEntry(key, newValue, this.defaultTimeout, null);
        });
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public V replace(K key, V value) {
        ExpiringEntry<K, V> oldEntry = this.storage.replace(key, new ExpiringEntry<K, V>(key, value, this.defaultTimeout, null));
        if (oldEntry != null) {
            if (oldEntry.expiry < Long.MAX_VALUE) {
                this.expiryQueue.remove(oldEntry);
            }
            return oldEntry.value;
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Objects.requireNonNull(oldValue);
        Objects.requireNonNull(newValue);
        ExpiringEntry entry = this.storage.computeIfPresent(key, (k, oldEntry) -> {
            if (oldEntry.value.equals(oldValue)) {
                if (oldEntry.expiry < Long.MAX_VALUE) {
                    this.expiryQueue.remove(oldEntry);
                }
                return new ExpiringEntry<Object, Object>(k, newValue, this.defaultTimeout, null);
            }
            return oldEntry;
        });
        return entry != null && entry.value.equals(newValue);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.storage.replaceAll((k, oldEntry) -> {
            if (oldEntry.expiry < Long.MAX_VALUE) {
                this.expiryQueue.remove(oldEntry);
            }
            return new ExpiringEntry(k, Objects.requireNonNull(function.apply((K)k, (V)oldEntry.value)), this.defaultTimeout, null);
        });
    }

    @Override
    public V remove(Object key) {
        Objects.requireNonNull(key);
        this.purgeExpired();
        ExpiringEntry<K, V> entry = this.storage.remove(key);
        if (entry == null) {
            return null;
        }
        if (entry.expiry < Long.MAX_VALUE) {
            this.expiryQueue.remove(entry);
        }
        return entry.value;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.purgeExpired();
        ExpiringEntry<K, V> entry = this.storage.get(key);
        if (entry == null || !value.equals(entry.value)) {
            return false;
        }
        if (!this.storage.remove(key, entry)) {
            return false;
        }
        if (entry.expiry < Long.MAX_VALUE) {
            this.expiryQueue.remove(entry);
        }
        return true;
    }

    @Override
    public void clear() {
        this.expiryQueue.clear();
        this.storage.clear();
    }

    @Override
    public Set<K> keySet() {
        this.purgeExpired();
        return this.storage.keySet();
    }

    @Override
    public Collection<V> values() {
        this.purgeExpired();
        return this.storage.values().stream().map(e -> e.value).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.purgeExpired();
        return this.storage.entrySet().stream().map(e -> new Map.Entry<K, V>(){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            @Override
            public K getKey() {
                return this.val$e.getKey();
            }

            @Override
            public V getValue() {
                return ((ExpiringEntry)this.val$e.getValue()).value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.storage.forEach((k, v) -> action.accept((Object)k, (Object)v.value));
    }

    public long purgeExpired() {
        return this.purgeExpired(this.currentTimeSupplier.getAsLong());
    }

    private long purgeExpired(long oldest) {
        ExpiringEntry<K, V> entry;
        while ((entry = this.expiryQueue.peek()) != null && entry.expiry <= oldest) {
            if (!this.expiryQueue.remove(entry) || !this.storage.remove(entry.key, entry) || entry.expiryListener == null) continue;
            entry.expiryListener.accept(entry.key, entry.value);
        }
        return entry == null ? Long.MAX_VALUE : entry.expiry;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExpiringMap)) {
            return false;
        }
        ExpiringMap other = (ExpiringMap)obj;
        return this.storage.equals(other.storage);
    }

    @Override
    public int hashCode() {
        return this.storage.hashCode();
    }

    private static final class ExpiringEntry<K, V>
    implements Comparable<ExpiringEntry<K, V>> {
        private K key;
        private V value;
        private long expiry;
        @Nullable
        private BiConsumer<K, V> expiryListener;

        ExpiringEntry(K key, V value, long expiry, @Nullable BiConsumer<K, V> expiryListener) {
            this.key = key;
            this.value = value;
            this.expiry = expiry;
            this.expiryListener = expiryListener;
        }

        @Override
        public int compareTo(ExpiringEntry<K, V> o) {
            return Long.compare(this.expiry, o.expiry);
        }
    }
}

