/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.repository;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.BytesRef;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.Log;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.eth.TransactionReceipt;
import org.apache.tuweni.eth.repository.BlockHeaderFields;
import org.apache.tuweni.eth.repository.BlockchainIndexReader;
import org.apache.tuweni.eth.repository.BlockchainIndexWriter;
import org.apache.tuweni.eth.repository.IndexReadException;
import org.apache.tuweni.eth.repository.IndexResult;
import org.apache.tuweni.eth.repository.IndexWriteException;
import org.apache.tuweni.eth.repository.TransactionReceiptFields;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Gas;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001dH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0018\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\"0$J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0016J(\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u001a\u00103\u001a\u00020&2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020&0$J\u0016\u00104\u001a\b\u0012\u0004\u0012\u0002050\u000b2\u0006\u00106\u001a\u000207H\u0002J$\u00104\u001a\b\u0012\u0004\u0012\u0002050\u000b2\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00106\u001a\u000207H\u0002J$\u0010:\u001a\b\u0012\u0004\u0012\u0002050\u000b2\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002050\u000b2\u0006\u00106\u001a\u000207H\u0002J$\u0010;\u001a\b\u0012\u0004\u0012\u0002050\u000b2\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00106\u001a\u000207H\u0002J$\u0010=\u001a\b\u0012\u0004\u0012\u0002050\u000b2\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020>0\u000bH\u0002J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u0011H\u0002J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\tH\u0002J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010B\u001a\u00020\u0013H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\t2\u0006\u0010D\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/apache/tuweni/eth/repository/BlockchainIndex;", "Lorg/apache/tuweni/eth/repository/BlockchainIndexWriter;", "Lorg/apache/tuweni/eth/repository/BlockchainIndexReader;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "(Lorg/apache/lucene/index/IndexWriter;)V", "searcherManager", "Lorg/apache/lucene/search/SearcherManager;", "chainHeadTotalDifficulty", "Lorg/apache/tuweni/units/bigints/UInt256;", "findBy", "", "Lorg/apache/tuweni/eth/Hash;", "field", "Lorg/apache/tuweni/eth/repository/BlockHeaderFields;", "value", "", "Lorg/apache/tuweni/bytes/Bytes;", "Lorg/apache/tuweni/eth/Address;", "Lorg/apache/tuweni/units/ethereum/Gas;", "Lorg/apache/tuweni/eth/repository/TransactionReceiptFields;", "", "findByBlockHashAndIndex", "blockHash", "index", "findByHashOrNumber", "hashOrNumber", "findByLargest", "findByOneTerm", "Lorg/apache/lucene/util/BytesRef;", "findInRange", "minValue", "maxValue", "findLargestTotalDifficulty", "", "indexer", "Lkotlin/Function1;", "indexBlockHeader", "Lorg/apache/tuweni/eth/repository/IndexResult;", "blockHeader", "Lorg/apache/tuweni/eth/BlockHeader;", "indexTotalDifficulty", "", "indexTransaction", "transaction", "Lorg/apache/tuweni/eth/Transaction;", "indexTransactionReceipt", "txReceipt", "Lorg/apache/tuweni/eth/TransactionReceipt;", "txIndex", "txHash", "indexWithResult", "queryBlockDocs", "Lorg/apache/lucene/document/Document;", "query", "Lorg/apache/lucene/search/Query;", "fields", "queryBlocks", "queryDiffDocs", "queryTxReceiptDocs", "queryTxReceipts", "search", "", "toBytesRef", "bytes", "uint", "gas", "totalDifficulty", "hash", "Companion", "eth-repository"})
public final class BlockchainIndex
implements BlockchainIndexWriter,
BlockchainIndexReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexWriter indexWriter;
    @NotNull
    private final SearcherManager searcherManager;
    private static final int HITS = 1;

    public BlockchainIndex(@NotNull IndexWriter indexWriter) {
        Intrinsics.checkNotNullParameter((Object)indexWriter, (String)"indexWriter");
        this.indexWriter = indexWriter;
        if (!this.indexWriter.isOpen()) {
            throw new IllegalArgumentException("Index writer should be opened");
        }
        try {
            this.searcherManager = new SearcherManager(this.indexWriter, new SearcherFactory());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void index(@NotNull Function1<? super BlockchainIndexWriter, Unit> indexer) {
        Intrinsics.checkNotNullParameter(indexer, (String)"indexer");
        try {
            indexer.invoke((Object)this);
            try {
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
            }
            catch (IOException e) {
                throw new IndexWriteException(e);
            }
        }
        catch (Throwable t) {
            try {
                this.indexWriter.rollback();
            }
            catch (IOException e) {
                throw new IndexWriteException(e);
            }
            throw t;
        }
    }

    @NotNull
    public final IndexResult indexWithResult(@NotNull Function1<? super BlockchainIndexWriter, IndexResult> indexer) {
        Intrinsics.checkNotNullParameter(indexer, (String)"indexer");
        try {
            IndexResult result = (IndexResult)indexer.invoke((Object)this);
            try {
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
            }
            catch (IOException e) {
                throw new IndexWriteException(e);
            }
            return result;
        }
        catch (Throwable t) {
            try {
                this.indexWriter.rollback();
            }
            catch (IOException e) {
                throw new IndexWriteException(e);
            }
            throw t;
        }
    }

    @Override
    @NotNull
    public IndexResult indexBlockHeader(@NotNull BlockHeader blockHeader, boolean indexTotalDifficulty) {
        Intrinsics.checkNotNullParameter((Object)blockHeader, (String)"blockHeader");
        List document = new ArrayList();
        Hash hash = blockHeader.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"blockHeader.getHash()");
        BytesRef id = this.toBytesRef((Bytes)hash);
        document.add(new StringField("_id", id, Field.Store.YES));
        document.add(new StringField("_type", "block", Field.Store.NO));
        Hash parentHash = blockHeader.getParentHash();
        if (parentHash != null) {
            ((Collection)document).add(new StringField(BlockHeaderFields.PARENT_HASH.getFieldName(), this.toBytesRef((Bytes)parentHash), Field.Store.NO));
        }
        Collection collection = document;
        String string = BlockHeaderFields.OMMERS_HASH.getFieldName();
        Query[] queryArray = blockHeader.getOmmersHash();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getOmmersHash()");
        collection.add(new StringField(string, this.toBytesRef((Bytes)queryArray), Field.Store.NO));
        Collection collection2 = document;
        String string2 = BlockHeaderFields.COINBASE.getFieldName();
        queryArray = blockHeader.getCoinbase();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getCoinbase()");
        collection2.add(new StringField(string2, this.toBytesRef((Bytes)queryArray), Field.Store.NO));
        Collection collection3 = document;
        String string3 = BlockHeaderFields.STATE_ROOT.getFieldName();
        queryArray = blockHeader.getStateRoot();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getStateRoot()");
        collection3.add(new StringField(string3, this.toBytesRef((Bytes)queryArray), Field.Store.NO));
        Collection collection4 = document;
        String string4 = BlockHeaderFields.DIFFICULTY.getFieldName();
        queryArray = blockHeader.getDifficulty();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getDifficulty()");
        collection4.add(new StringField(string4, this.toBytesRef((UInt256)queryArray), Field.Store.YES));
        Collection collection5 = document;
        String string5 = BlockHeaderFields.NUMBER.getFieldName();
        queryArray = blockHeader.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getNumber()");
        collection5.add(new StringField(string5, this.toBytesRef((UInt256)queryArray), Field.Store.NO));
        Collection collection6 = document;
        String string6 = BlockHeaderFields.GAS_LIMIT.getFieldName();
        queryArray = blockHeader.getGasLimit();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getGasLimit()");
        collection6.add(new StringField(string6, this.toBytesRef((Gas)queryArray), Field.Store.NO));
        Collection collection7 = document;
        String string7 = BlockHeaderFields.GAS_USED.getFieldName();
        queryArray = blockHeader.getGasUsed();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getGasUsed()");
        collection7.add(new StringField(string7, this.toBytesRef((Gas)queryArray), Field.Store.NO));
        Collection collection8 = document;
        String string8 = BlockHeaderFields.EXTRA_DATA.getFieldName();
        queryArray = blockHeader.getExtraData();
        Intrinsics.checkNotNullExpressionValue((Object)queryArray, (String)"blockHeader.getExtraData()");
        collection8.add(new StringField(string8, this.toBytesRef((Bytes)queryArray), Field.Store.NO));
        ((Collection)document).add(new NumericDocValuesField(BlockHeaderFields.TIMESTAMP.getFieldName(), blockHeader.getTimestamp().toEpochMilli()));
        try {
            BooleanQuery.Builder query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_id", id)), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_type", "block")), BooleanClause.Occur.MUST);
            queryArray = new Query[]{(Query)query.build()};
            this.indexWriter.deleteDocuments(queryArray);
            this.indexWriter.addDocument((Iterable)document);
        }
        catch (IOException e) {
            throw new IndexWriteException(e);
        }
        boolean totalDifficultyFound = this.indexTotalDifficulty(blockHeader);
        return new IndexResult(totalDifficultyFound);
    }

    @Override
    public boolean indexTotalDifficulty(@NotNull BlockHeader blockHeader) {
        BytesRef bytesRef;
        BytesRef bytesRef2;
        Intrinsics.checkNotNullParameter((Object)blockHeader, (String)"blockHeader");
        List document = new ArrayList();
        Hash hash = blockHeader.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"blockHeader.hash");
        BytesRef id = this.toBytesRef((Bytes)hash);
        document.add(new StringField("_id", id, Field.Store.YES));
        document.add(new StringField("_type", "difficulty", Field.Store.NO));
        boolean totalDifficultyFound = false;
        Hash hash2 = blockHeader.getParentHash();
        if (hash2 == null) {
            bytesRef2 = null;
        } else {
            Hash hash3 = hash2;
            boolean bl = false;
            BytesRef hashRef = this.toBytesRef((Bytes)hash3);
            ((Collection)document).add(new StringField(BlockHeaderFields.PARENT_HASH.getFieldName(), hashRef, Field.Store.NO));
            Document document2 = (Document)CollectionsKt.firstOrNull(this.queryDiffDocs((Query)new TermQuery(new Term("_id", hashRef)), CollectionsKt.listOf((Object)((Object)BlockHeaderFields.TOTAL_DIFFICULTY))));
            if (document2 == null) {
                bytesRef2 = null;
            } else {
                Document it = document2;
                boolean bl2 = false;
                IndexableField indexableField = it.getField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName());
                if (indexableField == null) {
                    bytesRef2 = null;
                } else {
                    IndexableField it2 = indexableField;
                    boolean bl3 = false;
                    UInt256 totalDifficulty = blockHeader.getDifficulty().add(UInt256.fromBytes((Bytes)Bytes.wrap((byte[])it2.binaryValue().bytes)));
                    totalDifficultyFound = true;
                    Intrinsics.checkNotNullExpressionValue((Object)totalDifficulty, (String)"totalDifficulty");
                    bytesRef2 = this.toBytesRef(totalDifficulty);
                }
            }
        }
        BytesRef bytesRef3 = bytesRef2;
        if (bytesRef3 == null) {
            BlockchainIndex $this$indexTotalDifficulty_u24lambda_u2d3 = this;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)blockHeader.getNumber(), (Object)UInt256.ZERO)) {
                totalDifficultyFound = true;
            }
            UInt256 uInt256 = blockHeader.getDifficulty();
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"blockHeader.difficulty");
            bytesRef = $this$indexTotalDifficulty_u24lambda_u2d3.toBytesRef(uInt256);
        } else {
            bytesRef = bytesRef3;
        }
        BytesRef diffBytes = bytesRef;
        ((Collection)document).add(new StringField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), diffBytes, Field.Store.YES));
        ((Collection)document).add(new SortedDocValuesField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), diffBytes));
        ((Collection)document).add(new StoredField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), diffBytes));
        try {
            BooleanQuery.Builder query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("_id", id)), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_type", "difficulty")), BooleanClause.Occur.MUST);
            Query[] queryArray = new Query[]{(Query)query.build()};
            this.indexWriter.deleteDocuments(queryArray);
            this.indexWriter.addDocument((Iterable)document);
        }
        catch (IOException e) {
            throw new IndexWriteException(e);
        }
        return totalDifficultyFound;
    }

    @Override
    public void indexTransaction(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
    }

    @Override
    public void indexTransactionReceipt(@NotNull TransactionReceipt txReceipt, int txIndex, @NotNull Bytes txHash, @NotNull Bytes blockHash) {
        Intrinsics.checkNotNullParameter((Object)txReceipt, (String)"txReceipt");
        Intrinsics.checkNotNullParameter((Object)txHash, (String)"txHash");
        Intrinsics.checkNotNullParameter((Object)blockHash, (String)"blockHash");
        List document = new ArrayList();
        BytesRef id = this.toBytesRef(txHash);
        ((Collection)document).add(new StringField("_id", id, Field.Store.YES));
        ((Collection)document).add(new StringField("_type", "txReceipt", Field.Store.NO));
        ((Collection)document).add(new NumericDocValuesField(TransactionReceiptFields.INDEX.getFieldName(), (long)txIndex));
        ((Collection)document).add(new StringField(TransactionReceiptFields.TRANSACTION_HASH.getFieldName(), id, Field.Store.NO));
        ((Collection)document).add(new StringField(TransactionReceiptFields.BLOCK_HASH.getFieldName(), this.toBytesRef(blockHash), Field.Store.NO));
        for (Log log : txReceipt.getLogs()) {
            Collection collection = document;
            String string = TransactionReceiptFields.LOGGER.getFieldName();
            Address address = log.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)address, (String)"log.getLogger()");
            collection.add(new StringField(string, this.toBytesRef((Bytes)address), Field.Store.NO));
            for (Bytes32 logTopic : log.getTopics()) {
                Collection collection2 = document;
                String string2 = TransactionReceiptFields.LOG_TOPIC.getFieldName();
                Intrinsics.checkNotNullExpressionValue((Object)logTopic, (String)"logTopic");
                collection2.add(new StringField(string2, this.toBytesRef((Bytes)logTopic), Field.Store.NO));
            }
        }
        Bytes32 bytes32 = txReceipt.getStateRoot();
        if (bytes32 != null) {
            Bytes32 it = bytes32;
            boolean bl = false;
            ((Collection)document).add(new StringField(TransactionReceiptFields.STATE_ROOT.getFieldName(), this.toBytesRef((Bytes)it), Field.Store.NO));
        }
        Collection collection = document;
        String string = TransactionReceiptFields.BLOOM_FILTER.getFieldName();
        Bytes bytes = txReceipt.getBloomFilter().toBytes();
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"txReceipt.getBloomFilter().toBytes()");
        collection.add(new StringField(string, this.toBytesRef(bytes), Field.Store.NO));
        ((Collection)document).add(new NumericDocValuesField(TransactionReceiptFields.CUMULATIVE_GAS_USED.getFieldName(), txReceipt.getCumulativeGasUsed()));
        Integer n = txReceipt.getStatus();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ((Collection)document).add(new NumericDocValuesField(TransactionReceiptFields.STATUS.getFieldName(), (long)it));
        }
        try {
            this.indexWriter.updateDocument(new Term("_id", id), (Iterable)document);
        }
        catch (IOException e) {
            throw new IndexWriteException(e);
        }
    }

    private final List<Document> queryBlockDocs(Query query) {
        return this.queryBlockDocs(query, CollectionsKt.emptyList());
    }

    private final List<Document> queryTxReceiptDocs(Query query) {
        return this.queryTxReceiptDocs(query, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Document> queryTxReceiptDocs(Query query, List<? extends BlockHeaderFields> fields) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BooleanQuery txQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_type", "txReceipt")), BooleanClause.Occur.MUST).build();
        Intrinsics.checkNotNullExpressionValue((Object)txQuery, (String)"txQuery");
        Iterable iterable = fields;
        Query query2 = (Query)txQuery;
        BlockchainIndex blockchainIndex = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BlockHeaderFields blockHeaderFields = (BlockHeaderFields)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFieldName());
        }
        collection = (List)destination$iv$iv;
        return blockchainIndex.search(query2, (List<String>)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Document> search(Query query, List<String> fields) {
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            Intrinsics.checkNotNull((Object)indexSearcher);
            TopDocs topDocs = indexSearcher.search(query, HITS);
            List docs = new ArrayList();
            Object object = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topDocs.scoreDocs");
            if (!(((Object[])object).length == 0)) {
                Object object2 = topDocs.scoreDocs;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topDocs.scoreDocs");
                object2 = (Object[])object2;
                int n = 0;
                Document doc = searcher.doc(object2[n].doc, SetsKt.plus((Set)SetsKt.setOf((Object)"_id"), (Iterable)fields));
                object2 = docs;
                object2.add(doc);
            }
            object = docs;
            return object;
        }
        catch (IOException e) {
            throw new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Document> queryBlockDocs(Query query, List<? extends BlockHeaderFields> fields) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BooleanQuery blockQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_type", "block")), BooleanClause.Occur.MUST).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockQuery, (String)"blockQuery");
        Iterable iterable = fields;
        Query query2 = (Query)blockQuery;
        BlockchainIndex blockchainIndex = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BlockHeaderFields blockHeaderFields = (BlockHeaderFields)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFieldName());
        }
        collection = (List)destination$iv$iv;
        return blockchainIndex.search(query2, (List<String>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Document> queryDiffDocs(Query query, List<? extends BlockHeaderFields> fields) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BooleanQuery blockQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_type", "difficulty")), BooleanClause.Occur.MUST).build();
        Intrinsics.checkNotNullExpressionValue((Object)blockQuery, (String)"blockQuery");
        Iterable iterable = fields;
        Query query2 = (Query)blockQuery;
        BlockchainIndex blockchainIndex = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BlockHeaderFields blockHeaderFields = (BlockHeaderFields)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFieldName());
        }
        collection = (List)destination$iv$iv;
        return blockchainIndex.search(query2, (List<String>)collection);
    }

    private final List<Hash> queryBlocks(Query query) {
        List hashes = new ArrayList();
        for (Document doc : this.queryBlockDocs(query)) {
            BytesRef bytes = doc.getBinaryValue("_id");
            Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"fromBytes(Bytes32.wrap(bytes.bytes))");
            hashes.add(hash);
        }
        return hashes;
    }

    private final List<Hash> queryTxReceipts(Query query) {
        List hashes = new ArrayList();
        for (Document doc : this.queryTxReceiptDocs(query)) {
            BytesRef bytes = doc.getBinaryValue("_id");
            Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"fromBytes(Bytes32.wrap(bytes.bytes))");
            hashes.add(hash);
        }
        return hashes;
    }

    @Override
    @NotNull
    public List<Hash> findInRange(@NotNull BlockHeaderFields field, @NotNull UInt256 minValue, @NotNull UInt256 maxValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)minValue, (String)"minValue");
        Intrinsics.checkNotNullParameter((Object)maxValue, (String)"maxValue");
        return this.queryBlocks((Query)new TermRangeQuery(field.getFieldName(), this.toBytesRef(minValue), this.toBytesRef(maxValue), true, true));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Bytes value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, long value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Query query = NumericDocValuesField.newSlowExactQuery((String)field.getFieldName(), (long)value);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"newSlowExactQuery(field.fieldName, value)");
        return this.queryBlocks(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Hash findLargestTotalDifficulty() {
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            Intrinsics.checkNotNull((Object)indexSearcher);
            TopFieldDocs topDocs = indexSearcher.search((Query)new TermQuery(new Term("_type", "difficulty")), HITS, new Sort(new SortField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), SortField.Type.STRING, true)));
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)scoreDocArray, (String)"topDocs.scoreDocs");
            if (((Object[])scoreDocArray).length == 0) {
                scoreDocArray = null;
                return scoreDocArray;
            }
            ScoreDoc[] scoreDocArray2 = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)scoreDocArray2, (String)"topDocs.scoreDocs");
            Document doc = searcher.doc(((ScoreDoc)((Object[])scoreDocArray2)[0]).doc, SetsKt.setOf((Object)"_id"));
            BytesRef bytes = doc.getBinaryValue("_id");
            if (bytes != null) {
                Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
                return hash;
            }
            Hash hash = null;
            return hash;
        }
        catch (IOException e) {
            throw new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Hash findByLargest(@NotNull BlockHeaderFields field) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            Intrinsics.checkNotNull((Object)indexSearcher);
            SortField[] sortFieldArray = new SortField[]{SortField.FIELD_SCORE, new SortField(field.getFieldName(), SortField.Type.DOC, true)};
            TopFieldDocs topDocs = indexSearcher.search((Query)new TermQuery(new Term("_type", "block")), HITS, new Sort(sortFieldArray));
            sortFieldArray = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)sortFieldArray, (String)"topDocs.scoreDocs");
            if (((Object[])sortFieldArray).length == 0) {
                sortFieldArray = null;
                return sortFieldArray;
            }
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)scoreDocArray, (String)"topDocs.scoreDocs");
            Document doc = searcher.doc(((ScoreDoc)((Object[])scoreDocArray)[0]).doc, SetsKt.setOf((Object)"_id"));
            BytesRef bytes = doc.getBinaryValue("_id");
            if (bytes != null) {
                Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
                return hash;
            }
            Hash hash = null;
            return hash;
        }
        catch (IOException e) {
            throw new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UInt256 chainHeadTotalDifficulty() {
        UInt256 uInt256;
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            Intrinsics.checkNotNull((Object)indexSearcher);
            UInt256 uInt2562 = new UInt256[]{SortField.FIELD_SCORE, new SortField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), SortField.Type.DOC, true)};
            TopFieldDocs topDocs = indexSearcher.search((Query)new TermQuery(new Term("_type", "block")), 1, new Sort((SortField[])uInt2562));
            uInt2562 = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)uInt2562, (String)"topDocs.scoreDocs");
            if (((Object[])uInt2562).length == 0) {
                uInt2562 = UInt256.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)uInt2562, (String)"ZERO");
                return uInt2562;
            }
            Document doc = searcher.doc(topDocs.scoreDocs[0].doc, SetsKt.setOf((Object)BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName()));
            BytesRef fieldValue = doc.getBinaryValue(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName());
            uInt256 = UInt256.fromBytes((Bytes)((Bytes)Bytes32.wrap((byte[])fieldValue.bytes)));
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"fromBytes(Bytes32.wrap(fieldValue.bytes))");
        }
        catch (IOException e) {
            throw new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
        return uInt256;
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Gas value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull UInt256 value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Address value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Hash value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @NotNull
    public List<Hash> findInRange(@NotNull TransactionReceiptFields field, @NotNull UInt256 minValue, @NotNull UInt256 maxValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)minValue, (String)"minValue");
        Intrinsics.checkNotNullParameter((Object)maxValue, (String)"maxValue");
        return this.queryBlocks((Query)new TermRangeQuery(field.getFieldName(), this.toBytesRef(minValue), this.toBytesRef(maxValue), true, true));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Bytes value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, int value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        return this.findBy(field, (long)value);
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, long value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Query query = NumericDocValuesField.newSlowExactQuery((String)field.getFieldName(), (long)value);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"newSlowExactQuery(field.fieldName, value)");
        return this.queryTxReceipts(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Hash findByLargest(@NotNull TransactionReceiptFields field) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            Intrinsics.checkNotNull((Object)indexSearcher);
            SortField[] sortFieldArray = new SortField[]{SortField.FIELD_SCORE, new SortField(field.getFieldName(), SortField.Type.DOC, false)};
            TopFieldDocs topDocs = indexSearcher.search((Query)new TermQuery(new Term("_type", "txReceipt")), HITS, new Sort(sortFieldArray));
            sortFieldArray = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)sortFieldArray, (String)"topDocs.scoreDocs");
            if (((Object[])sortFieldArray).length == 0) {
                sortFieldArray = null;
                return sortFieldArray;
            }
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            Intrinsics.checkNotNullExpressionValue((Object)scoreDocArray, (String)"topDocs.scoreDocs");
            Document doc = searcher.doc(((ScoreDoc)((Object[])scoreDocArray)[0]).doc, SetsKt.setOf((Object)"_id"));
            BytesRef bytes = doc.getBinaryValue("_id");
            if (bytes != null) {
                Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
                return hash;
            }
            Hash hash = null;
            return hash;
        }
        catch (IOException e) {
            throw new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Gas value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull UInt256 value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Address value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Hash value) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @Nullable
    public Hash findByBlockHashAndIndex(@NotNull Bytes blockHash, int index) {
        Intrinsics.checkNotNullParameter((Object)blockHash, (String)"blockHash");
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(TransactionReceiptFields.BLOCK_HASH.getFieldName(), this.toBytesRef(blockHash))), BooleanClause.Occur.MUST).add(NumericDocValuesField.newSlowExactQuery((String)TransactionReceiptFields.INDEX.getFieldName(), (long)index), BooleanClause.Occur.MUST).build();
        Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"Builder()\n        .add(\n\u2026ur.MUST\n        ).build()");
        return (Hash)CollectionsKt.firstOrNull(this.queryTxReceipts((Query)booleanQuery));
    }

    @Override
    @NotNull
    public List<Hash> findByHashOrNumber(@NotNull Bytes hashOrNumber) {
        Intrinsics.checkNotNullParameter((Object)hashOrNumber, (String)"hashOrNumber");
        BooleanQuery query = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add(new BooleanClause((Query)new TermQuery(new Term("_id", this.toBytesRef(hashOrNumber))), BooleanClause.Occur.SHOULD)).add(new BooleanClause((Query)new TermQuery(new Term(BlockHeaderFields.NUMBER.getFieldName(), this.toBytesRef(hashOrNumber))), BooleanClause.Occur.SHOULD)).build();
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"query");
        return this.queryBlocks((Query)query);
    }

    @Override
    @Nullable
    public UInt256 totalDifficulty(@NotNull Bytes hash) {
        UInt256 uInt256;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Document document = (Document)CollectionsKt.firstOrNull(this.queryDiffDocs((Query)new TermQuery(new Term("_id", this.toBytesRef(hash))), CollectionsKt.listOf((Object)((Object)BlockHeaderFields.TOTAL_DIFFICULTY))));
        if (document == null) {
            uInt256 = null;
        } else {
            Document it = document;
            boolean bl = false;
            IndexableField indexableField = it.getField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName());
            if (indexableField == null) {
                uInt256 = null;
            } else {
                BytesRef bytesRef = indexableField.binaryValue();
                if (bytesRef == null) {
                    uInt256 = null;
                } else if (bytesRef.bytes == null) {
                    uInt256 = null;
                } else {
                    byte[] bytes = bytesRef.bytes;
                    boolean bl2 = false;
                    uInt256 = UInt256.fromBytes((Bytes)Bytes.wrap((byte[])bytes));
                }
            }
        }
        return uInt256;
    }

    private final List<Hash> findByOneTerm(BlockHeaderFields field, BytesRef value) {
        return this.queryBlocks((Query)new TermQuery(new Term(field.getFieldName(), value)));
    }

    private final List<Hash> findByOneTerm(TransactionReceiptFields field, BytesRef value) {
        return this.queryTxReceipts((Query)new TermQuery(new Term(field.getFieldName(), value)));
    }

    private final BytesRef toBytesRef(Gas gas) {
        return new BytesRef(gas.toBytes().toArrayUnsafe());
    }

    private final BytesRef toBytesRef(Bytes bytes) {
        return new BytesRef(bytes.toArrayUnsafe());
    }

    private final BytesRef toBytesRef(UInt256 uint) {
        Bytes32 bytes32 = uint.toBytes();
        Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"uint.toBytes()");
        return this.toBytesRef((Bytes)bytes32);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/apache/tuweni/eth/repository/BlockchainIndex$Companion;", "", "()V", "HITS", "", "eth-repository"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

