/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.prometheus.PrometheusCollector;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReaderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/apache/tuweni/metrics/MetricsService;", "", "jobName", "", "reportingIntervalMillis", "", "port", "", "networkInterface", "enablePrometheus", "", "enableGrpcPush", "grpcEndpoint", "grpcTimeout", "(Ljava/lang/String;JILjava/lang/String;ZZLjava/lang/String;J)V", "meterSdkProvider", "Lio/opentelemetry/sdk/metrics/SdkMeterProvider;", "getMeterSdkProvider", "()Lio/opentelemetry/sdk/metrics/SdkMeterProvider;", "openTelemetry", "Lio/opentelemetry/sdk/OpenTelemetrySdk;", "getOpenTelemetry", "()Lio/opentelemetry/sdk/OpenTelemetrySdk;", "periodicReader", "Lio/opentelemetry/sdk/metrics/export/IntervalMetricReader;", "server", "Lio/prometheus/client/exporter/HTTPServer;", "spanProcessor", "Lio/opentelemetry/sdk/trace/export/BatchSpanProcessor;", "close", "", "Companion", "metrics"})
public final class MetricsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final HTTPServer server;
    @NotNull
    private final SdkMeterProvider meterSdkProvider;
    @NotNull
    private final OpenTelemetrySdk openTelemetry;
    @NotNull
    private final BatchSpanProcessor spanProcessor;
    @Nullable
    private final IntervalMetricReader periodicReader;
    private static final Logger logger = LoggerFactory.getLogger(MetricsService.class);

    public MetricsService(@NotNull String jobName, long reportingIntervalMillis, int port, @NotNull String networkInterface, boolean enablePrometheus, boolean enableGrpcPush, @NotNull String grpcEndpoint, long grpcTimeout) {
        IntervalMetricReaderBuilder builder;
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)grpcEndpoint, (String)"grpcEndpoint");
        OtlpGrpcMetricExporter exporter = OtlpGrpcMetricExporter.builder().setEndpoint(grpcEndpoint).setTimeout(grpcTimeout, TimeUnit.MILLISECONDS).build();
        logger.info("Starting metrics service");
        Resource resource = Resource.getDefault().merge(Resource.create((Attributes)Attributes.builder().put(ResourceAttributes.SERVICE_NAME, (Object)jobName).build()));
        SdkMeterProvider sdkMeterProvider = SdkMeterProvider.builder().setResource(resource).build();
        Intrinsics.checkNotNullExpressionValue((Object)sdkMeterProvider, (String)"builder().setResource(resource).build()");
        this.meterSdkProvider = sdkMeterProvider;
        if (enableGrpcPush) {
            logger.info("Starting GRPC push metrics service");
            builder = IntervalMetricReader.builder().setExportIntervalMillis(reportingIntervalMillis).setMetricProducers((Collection)SetsKt.setOf((Object)this.meterSdkProvider)).setMetricExporter((MetricExporter)exporter);
            this.periodicReader = builder.buildAndStart();
        } else {
            this.periodicReader = null;
        }
        builder = BatchSpanProcessor.builder((SpanExporter)((SpanExporter)OtlpGrpcSpanExporter.builder().setEndpoint(grpcEndpoint).setTimeout(grpcTimeout, TimeUnit.MILLISECONDS).build())).build();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(\n      OtlpGrpcS\u2026DS).build()\n    ).build()");
        this.spanProcessor = builder;
        builder = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().setResource(resource).addSpanProcessor((SpanProcessor)this.spanProcessor).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()\n      .setTrac\u2026).build())\n      .build()");
        this.openTelemetry = builder;
        if (enablePrometheus) {
            logger.info("Starting Prometheus metrics service");
            CollectorRegistry prometheusRegistry = new CollectorRegistry(true);
            PrometheusCollector.builder().setMetricProducer((MetricProducer)this.meterSdkProvider).build().register(prometheusRegistry);
            this.server = new HTTPServer(new InetSocketAddress(networkInterface, port), prometheusRegistry, true);
        } else {
            this.server = null;
        }
    }

    public /* synthetic */ MetricsService(String string, long l, int n, String string2, boolean bl, boolean bl2, String string3, long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = 5000L;
        }
        if ((n2 & 4) != 0) {
            n = 9090;
        }
        if ((n2 & 8) != 0) {
            string2 = "0.0.0.0";
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x40) != 0) {
            string3 = "http://localhost:4317";
        }
        if ((n2 & 0x80) != 0) {
            l2 = 2000L;
        }
        this(string, l, n, string2, bl, bl2, string3, l2);
    }

    @NotNull
    public final SdkMeterProvider getMeterSdkProvider() {
        return this.meterSdkProvider;
    }

    @NotNull
    public final OpenTelemetrySdk getOpenTelemetry() {
        return this.openTelemetry;
    }

    public final void close() {
        IntervalMetricReader intervalMetricReader = this.periodicReader;
        if (intervalMetricReader != null) {
            intervalMetricReader.shutdown();
        }
        this.spanProcessor.shutdown();
        HTTPServer hTTPServer = this.server;
        if (hTTPServer != null) {
            hTTPServer.stop();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/tuweni/metrics/MetricsService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "metrics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

