/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.lib;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.io.Base64;

public class KeyFileLoader {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private KeyFileLoader() {
    }

    public static Signature.KeyPair getLocalKeys(Path ssbFolder) {
        Path secretPath = ssbFolder.resolve("secret");
        if (!secretPath.toFile().exists()) {
            throw new IllegalArgumentException("Secret file does not exist");
        }
        if (!secretPath.toFile().canRead()) {
            throw new IllegalArgumentException("Secret file cannot be read");
        }
        return KeyFileLoader.loadKeysFromFile(secretPath);
    }

    public static Signature.KeyPair loadKeysFromFile(Path secretPath) {
        try {
            Scanner s = new Scanner(secretPath.toFile(), StandardCharsets.UTF_8.name());
            s.useDelimiter("\n");
            ArrayList<String> list = new ArrayList<String>();
            while (s.hasNext()) {
                String next = s.next();
                if (next.startsWith("#")) continue;
                list.add(next);
            }
            String secretJSON = String.join((CharSequence)"", list);
            HashMap values = (HashMap)objectMapper.readValue(secretJSON, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            String pubKey = ((String)values.get("public")).replace(".ed25519", "");
            String privateKey = ((String)values.get("private")).replace(".ed25519", "");
            Bytes pubKeyBytes = Base64.decode((String)pubKey);
            Bytes privKeyBytes = Base64.decode((String)privateKey);
            Signature.PublicKey pub = Signature.PublicKey.fromBytes((Bytes)pubKeyBytes);
            Signature.SecretKey secretKey = Signature.SecretKey.fromBytes((Bytes)privKeyBytes);
            return new Signature.KeyPair(pub, secretKey);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

