/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.eth.Log;
import org.apache.tuweni.evm.impl.GasManager;
import org.apache.tuweni.evm.impl.Memory;
import org.apache.tuweni.evm.impl.Stack;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0006\u0010#\u001a\u00020\fJ\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lorg/apache/tuweni/evm/EVMState;", "", "gasManager", "Lorg/apache/tuweni/evm/impl/GasManager;", "logs", "", "Lorg/apache/tuweni/eth/Log;", "stack", "Lorg/apache/tuweni/evm/impl/Stack;", "memory", "Lorg/apache/tuweni/evm/impl/Memory;", "output", "Lorg/apache/tuweni/bytes/Bytes;", "(Lorg/apache/tuweni/evm/impl/GasManager;Ljava/util/List;Lorg/apache/tuweni/evm/impl/Stack;Lorg/apache/tuweni/evm/impl/Memory;Lorg/apache/tuweni/bytes/Bytes;)V", "getGasManager", "()Lorg/apache/tuweni/evm/impl/GasManager;", "getLogs", "()Ljava/util/List;", "getMemory", "()Lorg/apache/tuweni/evm/impl/Memory;", "getOutput", "()Lorg/apache/tuweni/bytes/Bytes;", "getStack", "()Lorg/apache/tuweni/evm/impl/Stack;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toBytes", "toString", "", "evm"})
public final class EVMState {
    @NotNull
    private final GasManager gasManager;
    @NotNull
    private final List<Log> logs;
    @NotNull
    private final Stack stack;
    @NotNull
    private final Memory memory;
    @Nullable
    private final Bytes output;

    public EVMState(@NotNull GasManager gasManager, @NotNull List<Log> logs, @NotNull Stack stack, @NotNull Memory memory, @Nullable Bytes output) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        this.gasManager = gasManager;
        this.logs = logs;
        this.stack = stack;
        this.memory = memory;
        this.output = output;
    }

    public /* synthetic */ EVMState(GasManager gasManager, List list, Stack stack, Memory memory, Bytes bytes, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bytes = null;
        }
        this(gasManager, list, stack, memory, bytes);
    }

    @NotNull
    public final GasManager getGasManager() {
        return this.gasManager;
    }

    @NotNull
    public final List<Log> getLogs() {
        return this.logs;
    }

    @NotNull
    public final Stack getStack() {
        return this.stack;
    }

    @NotNull
    public final Memory getMemory() {
        return this.memory;
    }

    @Nullable
    public final Bytes getOutput() {
        return this.output;
    }

    @NotNull
    public final Bytes toBytes() {
        Bytes bytes = RLP.encodeList(arg_0 -> EVMState.toBytes$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"encodeList {\n    it.writ\u2026(log.toBytes())\n    }\n  }");
        return bytes;
    }

    @NotNull
    public final GasManager component1() {
        return this.gasManager;
    }

    @NotNull
    public final List<Log> component2() {
        return this.logs;
    }

    @NotNull
    public final Stack component3() {
        return this.stack;
    }

    @NotNull
    public final Memory component4() {
        return this.memory;
    }

    @Nullable
    public final Bytes component5() {
        return this.output;
    }

    @NotNull
    public final EVMState copy(@NotNull GasManager gasManager, @NotNull List<Log> logs, @NotNull Stack stack, @NotNull Memory memory, @Nullable Bytes output) {
        Intrinsics.checkNotNullParameter((Object)gasManager, (String)"gasManager");
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)memory, (String)"memory");
        return new EVMState(gasManager, logs, stack, memory, output);
    }

    public static /* synthetic */ EVMState copy$default(EVMState eVMState, GasManager gasManager, List list, Stack stack, Memory memory, Bytes bytes, int n, Object object) {
        if ((n & 1) != 0) {
            gasManager = eVMState.gasManager;
        }
        if ((n & 2) != 0) {
            list = eVMState.logs;
        }
        if ((n & 4) != 0) {
            stack = eVMState.stack;
        }
        if ((n & 8) != 0) {
            memory = eVMState.memory;
        }
        if ((n & 0x10) != 0) {
            bytes = eVMState.output;
        }
        return eVMState.copy(gasManager, list, stack, memory, bytes);
    }

    @NotNull
    public String toString() {
        return "EVMState(gasManager=" + this.gasManager + ", logs=" + this.logs + ", stack=" + this.stack + ", memory=" + this.memory + ", output=" + this.output + ")";
    }

    public int hashCode() {
        int result = this.gasManager.hashCode();
        result = result * 31 + ((Object)this.logs).hashCode();
        result = result * 31 + this.stack.hashCode();
        result = result * 31 + this.memory.hashCode();
        result = result * 31 + (this.output == null ? 0 : this.output.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EVMState)) {
            return false;
        }
        EVMState eVMState = (EVMState)other;
        if (!Intrinsics.areEqual((Object)this.gasManager, (Object)eVMState.gasManager)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.logs, eVMState.logs)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stack, (Object)eVMState.stack)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.memory, (Object)eVMState.memory)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.output, (Object)eVMState.output);
    }

    private static final void toBytes$lambda-0(EVMState this$0, RLPWriter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.writeString("gas");
        it.writeValue((Bytes)this$0.gasManager.getGas().toBytes());
        it.writeString("memory");
        MutableBytes mutableBytes = this$0.memory.getMemoryData();
        it.writeValue(mutableBytes == null ? Bytes.EMPTY : (Bytes)mutableBytes);
        it.writeString("stack");
        int n = 0;
        int n2 = this$0.stack.size();
        while (n < n2) {
            int i = n++;
            UInt256 uInt256 = this$0.stack.get(i);
            it.writeValue(uInt256 == null ? Bytes.EMPTY : (Bytes)uInt256);
        }
        it.writeString("output");
        Bytes bytes = this$0.output;
        if (bytes == null) {
            bytes = Bytes.EMPTY;
        }
        it.writeValue(bytes);
        it.writeString("logs");
        for (Log log2 : this$0.logs) {
            it.writeValue(log2.toBytes());
        }
    }
}

