/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.precompiles;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.eth.precompiles.PrecompileContract;
import org.apache.tuweni.eth.precompiles.Result;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/eth/precompiles/ModExpPrecompileContract;", "Lorg/apache/tuweni/eth/precompiles/PrecompileContract;", "()V", "run", "Lorg/apache/tuweni/eth/precompiles/Result;", "input", "Lorg/apache/tuweni/bytes/Bytes;", "Companion", "eth-precompiles"})
public final class ModExpPrecompileContract
implements PrecompileContract {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final BigInteger BASE_OFFSET = BigInteger.valueOf(96L);

    @Override
    @NotNull
    public Result run(@NotNull Bytes input) {
        Bytes bytes;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input.size() < 96) {
            Bytes[] bytesArray = new Bytes[]{Bytes.repeat((byte)0, (int)(96 - input.size())), input};
            bytes = Bytes.wrap((Bytes[])bytesArray);
        } else {
            bytes = input;
        }
        Bytes padded = bytes;
        BigInteger baseLength = padded.slice(0, 32).toUnsignedBigInteger();
        BigInteger exponentLength = padded.slice(32, 32).toUnsignedBigInteger();
        BigInteger modulusLength = padded.slice(64, 32).toUnsignedBigInteger();
        if (Intrinsics.areEqual((Object)baseLength, (Object)BigInteger.ZERO) && Intrinsics.areEqual((Object)modulusLength, (Object)BigInteger.ZERO)) {
            return new Result(0L, Bytes.EMPTY);
        }
        BigInteger exponentOffset = BASE_OFFSET.add(baseLength);
        BigInteger modulusOffset = exponentOffset.add(exponentLength);
        BigInteger bigInteger = BASE_OFFSET;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BASE_OFFSET");
        BigInteger base = Companion.extractParameter(input, bigInteger, baseLength.intValue());
        Intrinsics.checkNotNullExpressionValue((Object)exponentOffset, (String)"exponentOffset");
        BigInteger exp = Companion.extractParameter(input, exponentOffset, exponentLength.intValue());
        Intrinsics.checkNotNullExpressionValue((Object)modulusOffset, (String)"modulusOffset");
        BigInteger mod = Companion.extractParameter(input, modulusOffset, modulusLength.intValue());
        Bytes modExp = mod.compareTo(BigInteger.ZERO) == 0 ? (Bytes)MutableBytes.EMPTY : Bytes.wrap((byte[])base.modPow(exp, mod).toByteArray()).trimLeadingZeros();
        int buffer = modulusLength.intValue() - modExp.size();
        if (buffer < 0) {
            buffer = 0;
        }
        Bytes[] bytesArray = new Bytes[]{Bytes.repeat((byte)0, (int)buffer), modExp};
        return new Result(0L, Bytes.wrap((Bytes[])bytesArray));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/eth/precompiles/ModExpPrecompileContract$Companion;", "", "()V", "BASE_OFFSET", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "getBASE_OFFSET", "()Ljava/math/BigInteger;", "extractParameter", "input", "Lorg/apache/tuweni/bytes/Bytes;", "offset", "length", "", "eth-precompiles"})
    public static final class Companion {
        private Companion() {
        }

        public final BigInteger getBASE_OFFSET() {
            return BASE_OFFSET;
        }

        @NotNull
        public final BigInteger extractParameter(@NotNull Bytes input, @NotNull BigInteger offset, int length) {
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            if (BigInteger.valueOf(input.size()).compareTo(offset) <= 0) {
                BigInteger bigInteger2 = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"{\n        BigInteger.ZERO\n      }");
                bigInteger = bigInteger2;
            } else {
                int min = Math.max(0, Math.min(length, input.size() - offset.intValue() - length));
                Bytes sliced = input.slice(offset.intValue(), min);
                if (sliced.size() > 32) {
                    sliced = sliced.slice(sliced.size() - 32);
                }
                BigInteger bigInteger3 = Bytes32.rightPad((Bytes)sliced).toUnsignedBigInteger();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"{\n        val min = Math\u2026ignedBigInteger()\n      }");
                bigInteger = bigInteger3;
            }
            return bigInteger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

