/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.tuweni.ethclientui

import com.fasterxml.jackson.databind.ObjectMapper
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.Feature
import jakarta.ws.rs.core.FeatureContext
import jakarta.ws.rs.core.MediaType
import jakarta.ws.rs.ext.MessageBodyReader
import jakarta.ws.rs.ext.MessageBodyWriter
import jakarta.ws.rs.ext.Provider
import org.apache.tuweni.eth.EthJsonModule
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.Annotations
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider

@Provider
@Produces(MediaType.APPLICATION_JSON)
class JSONProvider : JacksonJaxbJsonProvider {

  constructor() : super()
  constructor(vararg annotationsToUse: Annotations?) : super(mapper, annotationsToUse)

  companion object {
    val mapper = ObjectMapper()

    init {
      mapper.registerModule(EthJsonModule())
    }
  }

  init {
    setMapper(mapper)
  }
}

class MarshallingFeature : Feature {
  override fun configure(context: FeatureContext): Boolean {
    context.register(JSONProvider::class.java, MessageBodyReader::class.java, MessageBodyWriter::class.java)
    return true
  }
}
