/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.UUID;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.Peer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020\u0019H\u0016J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0019H\u0016J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0019H\u0016J'\u0010+\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00192\b\u0010,\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010-J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0019H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00060"}, d2={"Lorg/apache/tuweni/eth/crawler/RepositoryPeer;", "Lorg/apache/tuweni/devp2p/Peer;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "id", "", "knownEndpoint", "Lorg/apache/tuweni/devp2p/Endpoint;", "dataSource", "Ljavax/sql/DataSource;", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Ljava/lang/String;Lorg/apache/tuweni/devp2p/Endpoint;Ljavax/sql/DataSource;)V", "endpoint", "getEndpoint", "()Lorg/apache/tuweni/devp2p/Endpoint;", "setEndpoint", "(Lorg/apache/tuweni/devp2p/Endpoint;)V", "enr", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "getEnr", "()Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "setEnr", "(Lorg/apache/tuweni/devp2p/EthereumNodeRecord;)V", "getId", "()Ljava/lang/String;", "lastSeen", "", "getLastSeen", "()Ljava/lang/Long;", "setLastSeen", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "lastVerified", "getLastVerified", "setLastVerified", "getNodeId", "()Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "ifVerifiedOnOrAfter", "persist", "", "seenAt", "time", "updateENR", "record", "updateEndpoint", "ifVerifiedBefore", "(Lorg/apache/tuweni/devp2p/Endpoint;JLjava/lang/Long;)Lorg/apache/tuweni/devp2p/Endpoint;", "verifyEndpoint", "", "eth-crawler"})
public final class RepositoryPeer
implements Peer {
    @NotNull
    private final SECP256K1.PublicKey nodeId;
    @NotNull
    private final String id;
    @NotNull
    private final DataSource dataSource;
    @NotNull
    private volatile Endpoint endpoint;
    @Nullable
    private EthereumNodeRecord enr;
    @Nullable
    private volatile Long lastVerified;
    @Nullable
    private volatile Long lastSeen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryPeer(@NotNull SECP256K1.PublicKey nodeId, @NotNull String id, @NotNull Endpoint knownEndpoint, @NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)knownEndpoint, (String)"knownEndpoint");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.nodeId = nodeId;
        this.id = id;
        this.dataSource = dataSource;
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            Connection it = (Connection)autoCloseable;
            boolean bl = false;
            PreparedStatement stmt = it.prepareStatement("select lastSeen,lastVerified,host,port from endpoint where identity=?");
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                PreparedStatement it2 = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                it2.setString(1, this.getId());
                ResultSet rs = it2.executeQuery();
                if (rs.next()) {
                    Timestamp lastSeenStored = rs.getTimestamp(1);
                    Timestamp lastVerifiedStored = rs.getTimestamp(2);
                    String host = rs.getString(3);
                    int port = rs.getInt(4);
                    if (Intrinsics.areEqual((Object)knownEndpoint.getAddress(), (Object)host) && knownEndpoint.getUdpPort() == port) {
                        this.setLastSeen(lastSeenStored.getTime());
                        this.setLastVerified(lastVerifiedStored.getTime());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.endpoint = knownEndpoint;
    }

    @NotNull
    public SECP256K1.PublicKey getNodeId() {
        return this.nodeId;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(@NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"<set-?>");
        this.endpoint = endpoint;
    }

    @Nullable
    public EthereumNodeRecord getEnr() {
        return this.enr;
    }

    public void setEnr(@Nullable EthereumNodeRecord ethereumNodeRecord) {
        this.enr = ethereumNodeRecord;
    }

    @Nullable
    public synchronized Endpoint getEndpoint(long ifVerifiedOnOrAfter) {
        Long l = this.getLastVerified();
        if ((l == null ? 0L : l) >= ifVerifiedOnOrAfter) {
            return this.getEndpoint();
        }
        return null;
    }

    @Nullable
    public Long getLastVerified() {
        return this.lastVerified;
    }

    public void setLastVerified(@Nullable Long l) {
        this.lastVerified = l;
    }

    @Nullable
    public Long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(@Nullable Long l) {
        this.lastSeen = l;
    }

    @NotNull
    public synchronized Endpoint updateEndpoint(@NotNull Endpoint endpoint, long time, @Nullable Long ifVerifiedBefore) {
        Endpoint currentEndpoint;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                currentEndpoint = this.getEndpoint();
                if (Intrinsics.areEqual((Object)currentEndpoint, (Object)endpoint)) {
                    this.seenAt(time);
                    return currentEndpoint;
                }
                if (ifVerifiedBefore == null) break block5;
                Long l = this.getLastVerified();
                if ((l == null ? 0L : l) >= ifVerifiedBefore) break block6;
            }
            if (!Intrinsics.areEqual((Object)currentEndpoint.getAddress(), (Object)endpoint.getAddress()) || currentEndpoint.getUdpPort() != endpoint.getUdpPort()) {
                this.setLastVerified(null);
            }
            this.setEndpoint(endpoint);
            this.seenAt(time);
            return endpoint;
        }
        return currentEndpoint;
    }

    public synchronized boolean verifyEndpoint(@NotNull Endpoint endpoint, long time) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!Intrinsics.areEqual((Object)endpoint, (Object)this.getEndpoint())) {
            return false;
        }
        Long l = this.getLastVerified();
        if ((l == null ? 0L : l) < time) {
            this.setLastVerified(time);
        }
        this.seenAt(time);
        return true;
    }

    public synchronized void seenAt(long time) {
        Long l = this.getLastSeen();
        if ((l == null ? 0L : l) < time) {
            this.setLastSeen(time);
            this.persist();
        }
    }

    public synchronized void updateENR(@NotNull EthereumNodeRecord record, long time) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                if (this.getEnr() == null) break block2;
                EthereumNodeRecord ethereumNodeRecord = this.getEnr();
                Intrinsics.checkNotNull((Object)ethereumNodeRecord);
                if (ethereumNodeRecord.seq() >= record.seq()) break block3;
            }
            this.setEnr(record);
            Peer peer = this;
            String string = record.ip().getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.ip().hostAddress");
            Integer n = record.udp();
            Intrinsics.checkNotNull((Object)n);
            Peer.DefaultImpls.updateEndpoint$default((Peer)peer, (Endpoint)new Endpoint(string, n.intValue(), record.tcp()), (long)time, null, (int)4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persist() {
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection conn = (Connection)autoCloseable;
            boolean bl2 = false;
            PreparedStatement stmt = conn.prepareStatement("insert into endpoint(id, lastSeen, lastVerified, host, port, identity) values(?,?,?,?,?,?)");
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl3 = false;
                it.setString(1, UUID.randomUUID().toString());
                Long l = this.getLastSeen();
                it.setTimestamp(2, new Timestamp(l == null ? 0L : l));
                Long l2 = this.getLastVerified();
                it.setTimestamp(3, new Timestamp(l2 == null ? 0L : l2));
                it.setString(4, this.getEndpoint().getAddress());
                it.setInt(5, this.getEndpoint().getUdpPort());
                it.setString(6, this.getId());
                bl = it.execute();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            boolean bl4 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public String uri() {
        return Peer.DefaultImpls.uri((Peer)this);
    }
}

