/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.ExpiringSet;
import org.apache.tuweni.stratum.server.PoWInput;
import org.apache.tuweni.stratum.server.PoWSolution;
import org.apache.tuweni.stratum.server.Stratum1EthProxyProtocol;
import org.apache.tuweni.stratum.server.Stratum1Protocol;
import org.apache.tuweni.stratum.server.StratumConnection;
import org.apache.tuweni.stratum.server.StratumProtocol;
import org.apache.tuweni.stratum.server.StratumServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u00014B\u0084\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\"\u0010\u000b\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00100\f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200J\u0011\u00101\u001a\u00020+H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u0011\u00103\u001a\u00020+H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lorg/apache/tuweni/stratum/server/StratumServer;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "port", "", "networkInterface", "", "sslOptions", "Lio/vertx/core/net/KeyCertOptions;", "extranonce", "submitCallback", "Lkotlin/Function2;", "Lorg/apache/tuweni/stratum/server/PoWSolution;", "Lkotlin/coroutines/Continuation;", "", "", "seedSupplier", "Lkotlin/Function0;", "Lorg/apache/tuweni/bytes/Bytes32;", "errorThreshold", "denyTimeout", "", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;ILjava/lang/String;Lio/vertx/core/net/KeyCertOptions;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;IJLkotlin/coroutines/CoroutineContext;)V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "denyList", "Lorg/apache/tuweni/concurrent/ExpiringSet;", "getNetworkInterface", "()Ljava/lang/String;", "protocols", "", "Lorg/apache/tuweni/stratum/server/StratumProtocol;", "[Lorg/apache/tuweni/stratum/server/StratumProtocol;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "tcpServer", "Lio/vertx/core/net/NetServer;", "getVertx", "()Lio/vertx/core/Vertx;", "handleConnection", "", "socket", "Lio/vertx/core/net/NetSocket;", "setNewWork", "powInput", "Lorg/apache/tuweni/stratum/server/PoWInput;", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "Companion", "server"})
public final class StratumServer
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    private final int port;
    @NotNull
    private final String networkInterface;
    @Nullable
    private final KeyCertOptions sslOptions;
    private final int errorThreshold;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final StratumProtocol[] protocols;
    @NotNull
    private final AtomicBoolean started;
    @Nullable
    private NetServer tcpServer;
    @NotNull
    private final ExpiringSet<String> denyList;
    private static final Logger logger = LoggerFactory.getLogger(StratumServer.class);

    public StratumServer(@NotNull Vertx vertx, int port, @NotNull String networkInterface, @Nullable KeyCertOptions sslOptions, @NotNull String extranonce, @NotNull Function2<? super PoWSolution, ? super Continuation<? super Boolean>, ? extends Object> submitCallback, @NotNull Function0<? extends Bytes32> seedSupplier, int errorThreshold, long denyTimeout, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)extranonce, (String)"extranonce");
        Intrinsics.checkNotNullParameter(submitCallback, (String)"submitCallback");
        Intrinsics.checkNotNullParameter(seedSupplier, (String)"seedSupplier");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.port = port;
        this.networkInterface = networkInterface;
        this.sslOptions = sslOptions;
        this.errorThreshold = errorThreshold;
        this.coroutineContext = coroutineContext;
        StratumProtocol[] stratumProtocolArray = new StratumProtocol[]{new Stratum1Protocol(extranonce, null, null, submitCallback, seedSupplier, this.getCoroutineContext(), 6, null), new Stratum1EthProxyProtocol(submitCallback, seedSupplier, this.getCoroutineContext())};
        this.protocols = stratumProtocolArray;
        this.started = new AtomicBoolean(false);
        this.denyList = new ExpiringSet(denyTimeout);
    }

    public /* synthetic */ StratumServer(Vertx vertx, int n, String string, KeyCertOptions keyCertOptions, String string2, Function2 function2, Function0 function0, int n2, long l, CoroutineContext coroutineContext, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            string2 = "";
        }
        if ((n3 & 0x80) != 0) {
            n2 = 3;
        }
        if ((n3 & 0x100) != 0) {
            l = 600000L;
        }
        if ((n3 & 0x200) != 0) {
            coroutineContext = (CoroutineContext)VertxCoroutineKt.dispatcher((Vertx)vertx);
        }
        this(vertx, n, string, keyCertOptions, string2, (Function2<? super PoWSolution, ? super Continuation<? super Boolean>, ? extends Object>)function2, (Function0<? extends Bytes32>)function0, n2, l, coroutineContext);
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public final String getNetworkInterface() {
        return this.networkInterface;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public final void setNewWork(@NotNull PoWInput powInput) {
        Intrinsics.checkNotNullParameter((Object)powInput, (String)"powInput");
        for (StratumProtocol protocol : this.protocols) {
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(protocol, powInput, null){
                int label;
                final /* synthetic */ StratumProtocol $protocol;
                final /* synthetic */ PoWInput $powInput;
                {
                    this.$protocol = $protocol;
                    this.$powInput = $powInput;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.$protocol.setCurrentWorkTask(this.$powInput);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ StratumServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.started.compareAndSet(false, true)) ** GOTO lbl41
                options = new NetServerOptions().setPort(this.port).setHost(this.getNetworkInterface()).setTcpKeepAlive(true);
                v0 = this.sslOptions;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-StratumServer$start$2 = false;
                    options.setKeyCertOptions(it);
                }
                server = this.getVertx().createNetServer(options);
                server.exceptionHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, start$lambda-1(java.lang.Throwable ), (Ljava/lang/Throwable;)V)());
                server.connectHandler((Handler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, handleConnection(io.vertx.core.net.NetSocket ), (Lio/vertx/core/net/NetSocket;)V)((StratumServer)this));
                var4_9 = server.listen();
                Intrinsics.checkNotNullExpressionValue((Object)var4_9, (String)"server.listen()");
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.label = 1;
                v1 = VertxCoroutineKt.await((Future)var4_9, (Continuation)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl40
            }
            case 1: {
                server = (NetServer)$continuation.L$1;
                this = (StratumServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                this.tcpServer = server;
lbl41:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleConnection(NetSocket socket) {
        String name = socket.remoteAddress().host() + ":" + socket.remoteAddress().port();
        if (this.denyList.contains((Object)socket.remoteAddress().host())) {
            logger.warn(name + " attempted to reconnect while denied, booting");
            socket.close();
            return;
        }
        socket.exceptionHandler(StratumServer::handleConnection$lambda-2);
        StratumProtocol[] stratumProtocolArray = this.protocols;
        int n = this.errorThreshold;
        StratumConnection conn2 = new StratumConnection(stratumProtocolArray, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, socket){
            final /* synthetic */ StratumServer this$0;
            final /* synthetic */ NetSocket $socket;
            {
                this.this$0 = $receiver;
                this.$socket = $socket;
                super(1);
            }

            public final void invoke(boolean addToDenyList) {
                if (addToDenyList) {
                    StratumServer.access$getDenyList$p(this.this$0).add((Object)this.$socket.remoteAddress().host());
                }
                this.$socket.close();
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(socket){
            final /* synthetic */ NetSocket $socket;
            {
                this.$socket = $socket;
                super(1);
            }

            public final void invoke(@NotNull String bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                this.$socket.write((Object)Buffer.buffer((String)bytes));
            }
        }), name, n);
        socket.handler(conn2::handleBuffer);
        socket.closeHandler(arg_0 -> StratumServer.handleConnection$lambda-3(name, conn2, arg_0));
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        if (this.started.compareAndSet(true, false)) {
            Object v1;
            NetServer netServer = this.tcpServer;
            if (netServer == null) {
                v1 = null;
            } else {
                Future future = netServer.close();
                if (future == null) {
                    v1 = null;
                } else {
                    Object object = VertxCoroutineKt.await((Future)future, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            }
            if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return v1;
            }
        }
        return Unit.INSTANCE;
    }

    public final int port() {
        NetServer netServer = this.tcpServer;
        Integer n = netServer == null ? null : Integer.valueOf(netServer.actualPort());
        return n == null ? this.port : n;
    }

    private static final void start$lambda-1(Throwable e) {
        logger.error(e.getMessage(), e);
    }

    private static final void handleConnection$lambda-2(Throwable e) {
        logger.error(e.getMessage(), e);
    }

    private static final void handleConnection$lambda-3(String $name, StratumConnection $conn, Void it) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$conn, (String)"$conn");
        logger.trace("Client initiated socket close " + $name);
        $conn.close(false);
    }

    public static final /* synthetic */ ExpiringSet access$getDenyList$p(StratumServer $this) {
        return $this.denyList;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/stratum/server/StratumServer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "server"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

