/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import io.vertx.core.buffer.Buffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tuweni.stratum.server.StratumProtocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\nH\u0002J\u000e\u0010#\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lorg/apache/tuweni/stratum/server/StratumConnection;", "", "protocols", "", "Lorg/apache/tuweni/stratum/server/StratumProtocol;", "closeHandle", "Lkotlin/Function1;", "", "", "sender", "", "name", "threshold", "", "([Lorg/apache/tuweni/stratum/server/StratumProtocol;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/lang/String;I)V", "getCloseHandle", "()Lkotlin/jvm/functions/Function1;", "errors", "incompleteMessage", "getName", "()Ljava/lang/String;", "protocol", "[Lorg/apache/tuweni/stratum/server/StratumProtocol;", "getSender", "getThreshold", "()I", "close", "addToDenyList", "handleBuffer", "buffer", "Lio/vertx/core/buffer/Buffer;", "handleClientResponseFeedback", "result", "handleMessage", "message", "send", "Companion", "server"})
public final class StratumConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StratumProtocol[] protocols;
    @NotNull
    private final Function1<Boolean, Unit> closeHandle;
    @NotNull
    private final Function1<String, Unit> sender;
    @NotNull
    private final String name;
    private final int threshold;
    @NotNull
    private String incompleteMessage;
    @Nullable
    private StratumProtocol protocol;
    private int errors;
    private static final Logger logger = LoggerFactory.getLogger(StratumConnection.class);

    public StratumConnection(@NotNull StratumProtocol[] protocols, @NotNull Function1<? super Boolean, Unit> closeHandle, @NotNull Function1<? super String, Unit> sender, @NotNull String name, int threshold) {
        Intrinsics.checkNotNullParameter((Object)protocols, (String)"protocols");
        Intrinsics.checkNotNullParameter(closeHandle, (String)"closeHandle");
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.protocols = protocols;
        this.closeHandle = closeHandle;
        this.sender = sender;
        this.name = name;
        this.threshold = threshold;
        this.incompleteMessage = "";
    }

    public /* synthetic */ StratumConnection(StratumProtocol[] stratumProtocolArray, Function1 function1, Function1 function12, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 3;
        }
        this(stratumProtocolArray, (Function1<? super Boolean, Unit>)function1, (Function1<? super String, Unit>)function12, string, n);
    }

    @NotNull
    public final Function1<Boolean, Unit> getCloseHandle() {
        return this.closeHandle;
    }

    @NotNull
    public final Function1<String, Unit> getSender() {
        return this.sender;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void handleBuffer(@NotNull Buffer buffer) {
        String string;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        logger.trace("Buffer received {}", (Object)buffer);
        boolean firstMessage = false;
        String messagesString = null;
        try {
            string = buffer.toString(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n      buffer.toString(\u2026dardCharsets.UTF_8)\n    }");
        }
        catch (IllegalArgumentException e) {
            logger.debug("Invalid message with non UTF-8 characters: " + e.getMessage(), (Throwable)e);
            this.closeHandle.invoke((Object)true);
            return;
        }
        messagesString = string;
        char[] e = new char[]{'\n'};
        Iterator messages = StringsKt.split$default((CharSequence)messagesString, (char[])e, (boolean)false, (int)0, (int)6, null).iterator();
        while (messages.hasNext()) {
            Object message = (String)messages.next();
            if (!firstMessage) {
                message = this.incompleteMessage + (String)message;
                firstMessage = true;
            }
            if (!messages.hasNext()) {
                this.incompleteMessage = message;
                continue;
            }
            logger.trace("Dispatching message {}", message);
            this.handleMessage((String)message);
        }
    }

    public final void close(boolean addToDenyList) {
        logger.trace("Closing connection");
        StratumProtocol stratumProtocol = this.protocol;
        if (stratumProtocol != null) {
            stratumProtocol.onClose(this);
        }
        this.closeHandle.invoke((Object)addToDenyList);
    }

    private final void handleMessage(String message) {
        if (this.protocol == null) {
            for (StratumProtocol protocol : this.protocols) {
                if (!protocol.canHandle(message, this)) continue;
                this.protocol = protocol;
            }
            if (this.protocol == null) {
                logger.debug("Invalid first message: {}", (Object)message);
                this.closeHandle.invoke((Object)true);
            }
        } else {
            StratumProtocol stratumProtocol = this.protocol;
            if (stratumProtocol != null) {
                stratumProtocol.handle(this, message);
            }
        }
    }

    public final void send(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        logger.debug("Sending message {}", (Object)message);
        this.sender.invoke((Object)message);
    }

    public final void handleClientResponseFeedback(boolean result) {
        if (result) {
            this.errors = 0;
        } else {
            ++this.errors;
            if (this.errors > this.threshold) {
                logger.warn("Too many errors with handle " + this.name + ", closing");
                this.close(true);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/tuweni/stratum/server/StratumConnection$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

