/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.config.DocumentPosition;
import org.apache.tuweni.config.PropertyValidator;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.config.SchemaBuilder;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EnodeUriKt;
import org.apache.tuweni.ethclient.DNSConfiguration;
import org.apache.tuweni.ethclient.DNSConfigurationImpl;
import org.apache.tuweni.ethclient.DataStoreConfiguration;
import org.apache.tuweni.ethclient.DataStoreConfigurationImpl;
import org.apache.tuweni.ethclient.DiscoveryConfiguration;
import org.apache.tuweni.ethclient.DiscoveryConfigurationImpl;
import org.apache.tuweni.ethclient.GenesisFileConfiguration;
import org.apache.tuweni.ethclient.GenesisFileConfigurationImpl;
import org.apache.tuweni.ethclient.PeerRepositoryConfiguration;
import org.apache.tuweni.ethclient.PeerRepositoryConfigurationImpl;
import org.apache.tuweni.ethclient.ProxyConfiguration;
import org.apache.tuweni.ethclient.ProxyConfigurationImpl;
import org.apache.tuweni.ethclient.RLPxServiceConfiguration;
import org.apache.tuweni.ethclient.RLPxServiceConfigurationImpl;
import org.apache.tuweni.ethclient.StaticPeersConfiguration;
import org.apache.tuweni.ethclient.StaticPeersConfigurationImpl;
import org.apache.tuweni.ethclient.SynchronizerConfiguration;
import org.apache.tuweni.ethclient.SynchronizerConfigurationImpl;
import org.apache.tuweni.ethclient.SynchronizerType;
import org.apache.tuweni.ethclient.ValidatorConfiguration;
import org.apache.tuweni.ethclient.ValidatorConfigurationImpl;
import org.apache.tuweni.ethclient.ValidatorType;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u000fJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0006J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0006J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0006J\u000e\u0010 \u001a\n !*\u0004\u0018\u00010\u00120\u0012J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/apache/tuweni/ethclient/EthereumClientConfig;", "", "config", "Lorg/apache/tuweni/config/Configuration;", "(Lorg/apache/tuweni/config/Configuration;)V", "dataStores", "", "Lorg/apache/tuweni/ethclient/DataStoreConfiguration;", "discoveryServices", "Lorg/apache/tuweni/ethclient/DiscoveryConfiguration;", "dnsClients", "Lorg/apache/tuweni/ethclient/DNSConfiguration;", "genesisFiles", "Lorg/apache/tuweni/ethclient/GenesisFileConfiguration;", "metricsEnabled", "", "metricsGrpcPushEnabled", "metricsNetworkInterface", "", "metricsPort", "", "metricsPrometheusEnabled", "peerRepositories", "Lorg/apache/tuweni/ethclient/PeerRepositoryConfiguration;", "proxies", "Lorg/apache/tuweni/ethclient/ProxyConfiguration;", "rlpxServices", "Lorg/apache/tuweni/ethclient/RLPxServiceConfiguration;", "staticPeers", "Lorg/apache/tuweni/ethclient/StaticPeersConfiguration;", "synchronizers", "Lorg/apache/tuweni/ethclient/SynchronizerConfiguration;", "toToml", "kotlin.jvm.PlatformType", "validate", "Ljava/util/stream/Stream;", "Lorg/apache/tuweni/config/ConfigurationError;", "validateSubsection", "name", "schema", "Lorg/apache/tuweni/config/Schema;", "validators", "Lorg/apache/tuweni/ethclient/ValidatorConfiguration;", "Companion", "eth-client"})
public final class EthereumClientConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Configuration config;
    private static final Logger logger = LoggerFactory.getLogger(EthereumClientConfig.class);

    public EthereumClientConfig(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public /* synthetic */ EthereumClientConfig(Configuration configuration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Configuration configuration2 = Configuration.empty((Schema)Companion.createSchema());
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"empty(createSchema())");
            configuration = configuration2;
        }
        this(configuration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DataStoreConfiguration> dataStores() {
        void $this$mapTo$iv$iv;
        Set storageSections = this.config.sections("storage");
        if (storageSections == null || storageSections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = storageSections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("storage." + (String)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            Object object = Paths.get(sectionConfig.getString("path"), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(sectionConfig.getString(\"path\"))");
            Path path = object;
            object = sectionConfig.getString("genesis");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sectionConfig.getString(\"genesis\")");
            collection.add(new DataStoreConfigurationImpl((String)section, path, (String)object));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RLPxServiceConfiguration> rlpxServices() {
        void $this$mapTo$iv$iv;
        Set rlpxSections = this.config.sections("rlpx");
        if (rlpxSections == null || rlpxSections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = rlpxSections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("rlpx." + (String)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            String string2 = sectionConfig.getString("clientName");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"clientName\")");
            String string3 = string2;
            int n = sectionConfig.getInteger("port");
            string2 = sectionConfig.getString("networkInterface");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"networkInterface\")");
            String string4 = string2;
            int n2 = sectionConfig.getInteger("advertisedPort");
            string2 = sectionConfig.getString("repository");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"repository\")");
            String string5 = string2;
            string2 = sectionConfig.getString("peerRepository");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"peerRepository\")");
            String string6 = string2;
            string2 = sectionConfig.getString("key");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"key\")");
            collection.add(new RLPxServiceConfigurationImpl((String)section, string3, n, string4, n2, string5, string6, string2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GenesisFileConfiguration> genesisFiles() {
        void $this$mapTo$iv$iv;
        Set genesisSections = this.config.sections("genesis");
        if (genesisSections == null || genesisSections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = genesisSections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("genesis." + (String)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            URI uRI = URI.create(sectionConfig.getString("path"));
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(sectionConfig.getString(\"path\"))");
            collection.add(new GenesisFileConfigurationImpl((String)section, uRI));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PeerRepositoryConfiguration> peerRepositories() {
        void $this$mapTo$iv$iv;
        Set peerRepositories = this.config.sections("peerRepository");
        if (peerRepositories == null || peerRepositories.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = peerRepositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("peerRepository." + (String)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            String string2 = sectionConfig.getString("type");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"type\")");
            collection.add(new PeerRepositoryConfigurationImpl((String)section, string2));
        }
        return (List)destination$iv$iv;
    }

    public final boolean metricsEnabled() {
        return this.config.getConfigurationSection("metrics").getBoolean("enabled");
    }

    public final int metricsPort() {
        return this.config.getConfigurationSection("metrics").getInteger("port");
    }

    @NotNull
    public final String metricsNetworkInterface() {
        String string = this.config.getConfigurationSection("metrics").getString("networkInterface");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.getConfigurationS\u2026tring(\"networkInterface\")");
        return string;
    }

    public final boolean metricsPrometheusEnabled() {
        return this.config.getConfigurationSection("metrics").getBoolean("enablePrometheus");
    }

    public final boolean metricsGrpcPushEnabled() {
        return this.config.getConfigurationSection("metrics").getBoolean("enableGrpcPush");
    }

    public final String toToml() {
        return this.config.toToml();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DNSConfiguration> dnsClients() {
        void $this$mapTo$iv$iv;
        Set dnsSections = this.config.sections("dns");
        if (dnsSections == null || dnsSections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = dnsSections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("dns." + (String)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            String string2 = sectionConfig.getString("peerRepository");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"peerRepository\")");
            String string3 = string2;
            string2 = sectionConfig.getString("enrLink");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"enrLink\")");
            collection.add(new DNSConfigurationImpl((String)section, string3, string2, sectionConfig.getLong("pollingPeriod"), sectionConfig.contains("dnsServer") ? sectionConfig.getString("dnsServer") : null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DiscoveryConfiguration> discoveryServices() {
        void $this$mapTo$iv$iv;
        Set discoverySections = this.config.sections("discovery");
        if (discoverySections == null || discoverySections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = discoverySections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("discovery." + (String)section);
            String secretKey = sectionConfig.getString("identity");
            SECP256K1.KeyPair keypair = Intrinsics.areEqual((Object)secretKey, (Object)"") ? SECP256K1.KeyPair.random() : SECP256K1.KeyPair.fromSecretKey((SECP256K1.SecretKey)SECP256K1.SecretKey.fromBytes((Bytes32)Bytes32.fromHexString((CharSequence)secretKey)));
            logger.info("Using () for discovery ()", (Object)keypair.publicKey().toHexString(), (Object)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            String string2 = sectionConfig.getString("peerRepository");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"peerRepository\")");
            String string3 = string2;
            int n = sectionConfig.getInteger("port");
            string2 = sectionConfig.getString("networkInterface");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"networkInterface\")");
            Intrinsics.checkNotNullExpressionValue((Object)keypair, (String)"keypair");
            collection.add(new DiscoveryConfigurationImpl((String)section, string3, n, string2, keypair));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<StaticPeersConfiguration> staticPeers() {
        void $this$mapTo$iv$iv;
        Set staticPeersSections = this.config.sections("static");
        if (staticPeersSections == null || staticPeersSections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = staticPeersSections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("static." + (String)section);
            Object object = sectionConfig.getListOfString("enodes");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sectionConfig.getListOfString(\"enodes\")");
            List list = object;
            object = sectionConfig.getString("peerRepository");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sectionConfig.getString(\"peerRepository\")");
            collection.add(new StaticPeersConfigurationImpl(list, (String)object));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProxyConfiguration> proxies() {
        void $this$mapTo$iv$iv;
        Set proxySections = this.config.sections("proxy");
        if (proxySections == null || proxySections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = proxySections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("proxy." + (String)section);
            String string2 = sectionConfig.getString("name");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"name\")");
            String string3 = string2;
            string2 = sectionConfig.getString("upstream");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"upstream\")");
            String string4 = string2;
            string2 = sectionConfig.getString("downstream");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"downstream\")");
            collection.add(new ProxyConfigurationImpl(string3, string4, string2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SynchronizerConfiguration> synchronizers() {
        void $this$mapTo$iv$iv;
        Set synchronizers = this.config.sections("synchronizer");
        if (synchronizers == null || synchronizers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = synchronizers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("synchronizer." + (String)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            String string2 = sectionConfig.getString("type");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"type\")");
            SynchronizerType synchronizerType = SynchronizerType.valueOf(string2);
            string2 = sectionConfig.getString("repository");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"repository\")");
            String string3 = string2;
            string2 = sectionConfig.getString("peerRepository");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"peerRepository\")");
            String string4 = string2;
            string2 = sectionConfig.getString("rlpxService");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"rlpxService\")");
            collection.add(new SynchronizerConfigurationImpl((String)section, synchronizerType, string3, string4, string2, UInt256.valueOf((long)sectionConfig.getLong("from")), UInt256.valueOf((long)sectionConfig.getLong("to")), sectionConfig.getString("fromRepository")));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ValidatorConfiguration> validators() {
        void $this$mapTo$iv$iv;
        Set validators = this.config.sections("validator");
        if (validators == null || validators.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = validators;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("validator." + (String)section);
            Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
            String string2 = sectionConfig.getString("type");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"type\")");
            collection.add(new ValidatorConfigurationImpl((String)section, ValidatorType.valueOf(string2), UInt256.valueOf((long)sectionConfig.getLong("from")), UInt256.valueOf((long)sectionConfig.getLong("to")), sectionConfig.getInteger("chainId")));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Stream<ConfigurationError> validate() {
        Schema schema = Companion.createSchema();
        Stream<ConfigurationError> errors = schema.validate(this.config);
        errors = Stream.concat(errors, this.validateSubsection("metrics", schema));
        errors = Stream.concat(errors, this.validateSubsection("storage", schema));
        errors = Stream.concat(errors, this.validateSubsection("dns", schema));
        errors = Stream.concat(errors, this.validateSubsection("static", schema));
        errors = Stream.concat(errors, this.validateSubsection("discovery", schema));
        errors = Stream.concat(errors, this.validateSubsection("rlpx", schema));
        errors = Stream.concat(errors, this.validateSubsection("proxy", schema));
        Stream<ConfigurationError> stream = errors = Stream.concat(errors, this.validateSubsection("peerRepository", schema));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"errors");
        return stream;
    }

    private final Stream<ConfigurationError> validateSubsection(String name, Schema schema) {
        Stream<ConfigurationError> stream = CollectionsKt.emptyList().stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"listOf<ConfigurationError>().stream()");
        Stream<ConfigurationError> errors = stream;
        for (String subSection : this.config.sections(name)) {
            Stream<ConfigurationError> stream2 = Stream.concat(errors, schema.getSubSection(name).validate(this.config.getConfigurationSection(name + "." + subSection)));
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"concat(\n        errors,\n\u2026me.$subSection\"))\n      )");
            errors = stream2;
        }
        return errors;
    }

    public EthereumClientConfig() {
        this(null, 1, null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/apache/tuweni/ethclient/EthereumClientConfig$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "createSchema", "Lorg/apache/tuweni/config/Schema;", "empty", "Lorg/apache/tuweni/ethclient/EthereumClientConfig;", "fromFile", "path", "Ljava/nio/file/Path;", "fromString", "config", "", "eth-client"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Schema createSchema() {
            SchemaBuilder metricsSection = SchemaBuilder.create();
            metricsSection.addBoolean("enabled", Boolean.valueOf(false), "Enable telemetry", null);
            metricsSection.addInteger("port", Integer.valueOf(9090), "Port to expose Prometheus metrics", PropertyValidator.isValidPort());
            metricsSection.addString("networkInterface", "0.0.0.0", "Network interface to expose Prometheus metrics", null);
            metricsSection.addBoolean("enablePrometheus", Boolean.valueOf(true), "Enable Prometheus metrics reporting", null);
            metricsSection.addBoolean("enableGrpcPush", Boolean.valueOf(true), "Enable GRPC OpenTelemetry metrics reporting", null);
            SchemaBuilder storageSection = SchemaBuilder.create();
            storageSection.addString("path", null, "File system path where data is stored", null);
            storageSection.addString("genesis", null, "Reference to a genesis configuration", null);
            SchemaBuilder dnsSection = SchemaBuilder.create();
            dnsSection.addString("enrLink", null, "DNS domain to query for records", null);
            dnsSection.addLong("pollingPeriod", Long.valueOf(50000L), "Polling period to refresh DNS records", null);
            dnsSection.addString("peerRepository", "default", "Peer repository to which records should go", null);
            dnsSection.addString("dnsServer", null, "DNS Server address to use, will use system default if null", null);
            SchemaBuilder staticPeers = SchemaBuilder.create();
            staticPeers.addListOfString("enodes", Collections.emptyList(), "Static enodes to connect to in enode://publickey@host:port format", Companion::createSchema$lambda-0);
            staticPeers.addString("peerRepository", "default", "Peer repository to which static nodes should go", null);
            SchemaBuilder discoverySection = SchemaBuilder.create();
            discoverySection.addString("identity", "", "Node identity", null);
            discoverySection.addString("networkInterface", "127.0.0.1", "Network interface to bind", null);
            discoverySection.addInteger("port", Integer.valueOf(0), "Port to expose the discovery service on", PropertyValidator.isValidPortOrZero());
            discoverySection.addString("peerRepository", "default", "Peer repository to which records should go", null);
            SchemaBuilder genesis = SchemaBuilder.create();
            genesis.addString("path", "classpath:/default.json", "Path to the genesis file", PropertyValidator.isURL());
            SchemaBuilder rlpx = SchemaBuilder.create();
            rlpx.addString("networkInterface", "127.0.0.1", "Network interface to bind", null);
            rlpx.addString("key", null, "Hex string representation of the private key used to represent the node", (PropertyValidator)new PropertyValidator<String>(){

                @NotNull
                public List<ConfigurationError> validate(@NotNull String key, @Nullable DocumentPosition position, @Nullable String value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    try {
                        String string = value;
                        if (string == null) {
                            string = "";
                        }
                        SECP256K1.SecretKey.fromBytes((Bytes32)Bytes32.fromHexString((CharSequence)string));
                    }
                    catch (IllegalArgumentException e) {
                        Object[] objectArray = new ConfigurationError[]{new ConfigurationError("Invalid enode secret key")};
                        return CollectionsKt.mutableListOf((Object[])objectArray);
                    }
                    return new ArrayList<E>();
                }
            });
            rlpx.addInteger("port", Integer.valueOf(0), "Port to expose the RLPx service on", PropertyValidator.isValidPortOrZero());
            rlpx.addInteger("advertisedPort", Integer.valueOf(30303), "Port to advertise in communications as the RLPx service port", PropertyValidator.isValidPort());
            rlpx.addString("clientName", "Apache Tuweni", "Name of the Ethereum client", null);
            rlpx.addString("repository", "default", "Name of the blockchain repository", null);
            rlpx.addString("peerRepository", "default", "Peer repository to which records should go", null);
            SchemaBuilder proxiesSection = SchemaBuilder.create();
            proxiesSection.addString("name", null, "Name of the site", null);
            proxiesSection.addString("upstream", "", "Server and port to send data to, such as localhost:1234", null);
            proxiesSection.addString("downstream", "", "Server and port to expose data on, such as localhost:1234", null);
            SchemaBuilder peerRepositoriesSection = SchemaBuilder.create();
            String[] stringArray = new String[]{"memory"};
            peerRepositoriesSection.addString("type", "memory", "Peer repository type", PropertyValidator.anyOf((String[])stringArray));
            SchemaBuilder synchronizersSection = SchemaBuilder.create();
            String[] stringArray2 = new String[]{"status", "parent", "best", "canonical"};
            synchronizersSection.addString("type", "status", "Synchronizer type", PropertyValidator.anyOf((String[])stringArray2));
            synchronizersSection.addLong("from", Long.valueOf(0L), "Start block to sync from", PropertyValidator.isGreaterOrEqual((long)0L));
            synchronizersSection.addLong("to", Long.valueOf(0L), "End block to sync to", PropertyValidator.isGreaterOrEqual((long)0L));
            synchronizersSection.addString("repository", "default", "Blockchain repository to use", null);
            synchronizersSection.addString("rlpxService", "default", "RLPx service to use for requests with this synchronizer", null);
            synchronizersSection.addString("peerRepository", "default", "Peer repository to use for requests with this synchronizer", null);
            synchronizersSection.addString("fromRepository", null, "(only for canonical) Repository to sync from", null);
            SchemaBuilder validatorsSection = SchemaBuilder.create();
            String[] stringArray3 = new String[]{"header", "difficulty", "evm"};
            validatorsSection.addString("type", "evm", "Validator type", PropertyValidator.anyOf((String[])stringArray3));
            validatorsSection.addInteger("chainId", Integer.valueOf(1), "chain id to validate with", null);
            SchemaBuilder builder = SchemaBuilder.create();
            builder.addSection("metrics", metricsSection.toSchema());
            builder.addSection("storage", storageSection.toSchema());
            builder.addSection("dns", dnsSection.toSchema());
            builder.addSection("static", staticPeers.toSchema());
            builder.addSection("discovery", discoverySection.toSchema());
            builder.addSection("rlpx", rlpx.toSchema());
            builder.addSection("genesis", genesis.toSchema());
            builder.addSection("proxy", proxiesSection.toSchema());
            builder.addSection("peerRepository", peerRepositoriesSection.toSchema());
            builder.addSection("synchronizer", synchronizersSection.toSchema());
            builder.addSection("validators", validatorsSection.toSchema());
            Schema schema = builder.toSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"builder.toSchema()");
            return schema;
        }

        @NotNull
        public final EthereumClientConfig fromFile(@Nullable Path path) {
            if (path == null) {
                return this.empty();
            }
            try {
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
                return this.fromString(FilesKt.readText$default((File)file, null, (int)1, null));
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof NoSuchFileException ? true : exception instanceof FileNotFoundException) {
                    throw new IllegalArgumentException("Missing config file: '" + path + "'");
                }
                throw e;
            }
        }

        @NotNull
        public final EthereumClientConfig fromString(@NotNull String config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Configuration configuration = Configuration.fromToml((String)config, (Schema)this.createSchema());
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"fromToml(config, createSchema())");
            return new EthereumClientConfig(configuration);
        }

        @NotNull
        public final EthereumClientConfig empty() {
            URL uRL = EthereumClientConfig.class.getResource("/default.toml");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"EthereumClientConfig::cl\u2026Resource(\"/default.toml\")");
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            return this.fromString(new String(byArray, charset));
        }

        private static final List createSchema$lambda-0(String $noName_0, DocumentPosition position, List value) {
            Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
            List errors = new ArrayList();
            List list = value;
            Intrinsics.checkNotNull((Object)list);
            for (String enode : list) {
                try {
                    URI uRI = URI.create(enode);
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(enode)");
                    EnodeUriKt.parseEnodeUri((URI)uRI);
                }
                catch (IllegalArgumentException e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "error validating enode";
                    }
                    errors.add(new ConfigurationError(position, string));
                }
            }
            return errors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

