/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.net.tls;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.io.file.Files;
import org.apache.tuweni.net.tls.FingerprintRepository;
import org.apache.tuweni.net.tls.TLSEnvironmentException;

final class FileBackedFingerprintRepository
implements FingerprintRepository {
    private final Path fingerprintFile;
    private volatile Map<String, Bytes> fingerprints;

    FileBackedFingerprintRepository(Path fingerprintFile) {
        try {
            java.nio.file.Files.createDirectories(fingerprintFile.toAbsolutePath().getParent(), new FileAttribute[0]);
            Files.createFileIfMissing((Path)fingerprintFile, (FileAttribute[])new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new TLSEnvironmentException("Cannot create fingerprint file " + fingerprintFile, e);
        }
        this.fingerprintFile = fingerprintFile;
        this.fingerprints = FileBackedFingerprintRepository.parseFingerprintFile(fingerprintFile);
    }

    @Override
    public boolean contains(String identifier) {
        return this.fingerprints.containsKey(identifier);
    }

    @Override
    public boolean contains(String identifier, Bytes fingerprint) {
        return fingerprint.equals(this.fingerprints.get(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFingerprint(String identifier, Bytes fingerprint) {
        if (!this.contains(identifier, fingerprint)) {
            FileBackedFingerprintRepository fileBackedFingerprintRepository = this;
            synchronized (fileBackedFingerprintRepository) {
                if (!this.contains(identifier, fingerprint)) {
                    HashMap<String, Bytes> fingerprintsCopy = new HashMap<String, Bytes>(this.fingerprints);
                    fingerprintsCopy.put(identifier, fingerprint);
                    this.fingerprints = FileBackedFingerprintRepository.writeFingerprintFile(this.fingerprintFile, fingerprintsCopy);
                }
            }
        }
    }

    private static Map<String, Bytes> parseFingerprintFile(Path fingerprintFile) {
        List<String> lines;
        try {
            lines = java.nio.file.Files.readAllLines(fingerprintFile);
        }
        catch (IOException e) {
            throw new TLSEnvironmentException("Cannot read fingerprint file " + fingerprintFile, e);
        }
        HashMap<String, Bytes> fingerprints = new HashMap<String, Bytes>();
        for (int i = 0; i < lines.size(); ++i) {
            Map.Entry<String, Bytes> entry;
            String line = lines.get(i).trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            try {
                entry = FileBackedFingerprintRepository.parseLine(line);
            }
            catch (IOException e) {
                throw new TLSEnvironmentException(e.getMessage() + " in " + fingerprintFile + " (line " + (i + 1) + ")");
            }
            fingerprints.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(fingerprints);
    }

    private static Map<String, Bytes> writeFingerprintFile(Path fingerprintFile, Map<String, Bytes> updatedFingerprints) {
        List<String> lines;
        try {
            lines = java.nio.file.Files.readAllLines(fingerprintFile);
        }
        catch (IOException e) {
            throw new TLSEnvironmentException("Cannot read fingerprint file " + fingerprintFile, e);
        }
        HashMap fingerprints = new HashMap();
        HashSet<String> updatedIdentifiers = new HashSet<String>(updatedFingerprints.keySet());
        try {
            Files.atomicReplace((Path)fingerprintFile, writer -> {
                for (int i = 0; i < lines.size(); ++i) {
                    Map.Entry<String, Bytes> entry;
                    String line = ((String)lines.get(i)).trim();
                    if (line.isEmpty() || line.startsWith("#")) {
                        writer.write((String)lines.get(i));
                        writer.write(System.lineSeparator());
                        continue;
                    }
                    try {
                        entry = FileBackedFingerprintRepository.parseLine(line);
                    }
                    catch (IOException e) {
                        throw new TLSEnvironmentException(e.getMessage() + " in " + fingerprintFile + " (line " + (i + 1) + ")");
                    }
                    String identifier = entry.getKey();
                    Bytes fingerprint = updatedFingerprints.getOrDefault(identifier, entry.getValue());
                    fingerprints.put(identifier, fingerprint);
                    updatedIdentifiers.remove(identifier);
                    writer.write(identifier);
                    writer.write(32);
                    writer.write(fingerprint.toHexString().substring(2).toLowerCase());
                    writer.write(System.lineSeparator());
                }
                for (String identifier : updatedIdentifiers) {
                    Bytes fingerprint = (Bytes)updatedFingerprints.get(identifier);
                    fingerprints.put(identifier, fingerprint);
                    writer.write(identifier);
                    writer.write(32);
                    writer.write(fingerprint.toHexString().substring(2).toLowerCase());
                    writer.write(System.lineSeparator());
                }
            });
            return Collections.unmodifiableMap(fingerprints);
        }
        catch (IOException e) {
            throw new TLSEnvironmentException("Cannot write fingerprint file " + fingerprintFile, e);
        }
    }

    private static Map.Entry<String, Bytes> parseLine(String line) throws IOException {
        Bytes fingerprint;
        String[] segments = line.split("\\s+", 2);
        if (segments.length != 2) {
            throw new IOException("Invalid line");
        }
        String identifier = segments[0];
        String fingerprintString = segments[1].trim().replace(":", "");
        try {
            fingerprint = Bytes.fromHexString((CharSequence)fingerprintString);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid fingerprint", e);
        }
        return new AbstractMap.SimpleImmutableEntry<String, Bytes>(identifier, fingerprint);
    }
}

