/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.rpc;

public interface RPCFlag {
    public int value();

    default public byte apply(byte flagsByte) {
        return (byte)(flagsByte | this.value());
    }

    default public boolean isApplied(byte flagsByte) {
        return (flagsByte & this.value()) == this.value();
    }

    public static enum BodyType implements RPCFlag
    {
        BINARY(0),
        UTF_8_STRING(1),
        JSON(2);

        private final int value;

        private BodyType(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public boolean isApplied(byte flagByte) {
            if (flagByte == BodyType.BINARY.value) {
                return this == BINARY;
            }
            return (flagByte & (byte)this.value) != 0;
        }

        public static BodyType extractBodyType(byte flagByte) {
            if (BINARY.isApplied(flagByte)) {
                return BINARY;
            }
            if (UTF_8_STRING.isApplied(flagByte)) {
                return UTF_8_STRING;
            }
            return JSON;
        }
    }

    public static enum EndOrError implements RPCFlag
    {
        END(4);

        private final int value;

        private EndOrError(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    public static enum Stream implements RPCFlag
    {
        STREAM(8);

        private final int value;

        private Stream(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }
    }
}

