/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;

public class GlobalStorageConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<Supplier<? extends LocalConfigurationStorage>> CONFIGURATION_STORAGE_SUPPLIER = AttributeDefinition.supplierBuilder((String)"class", LocalConfigurationStorage.class).autoPersist(false).serializer((AttributeSerializer)new AttributeSerializer<Supplier<? extends LocalConfigurationStorage>, ConfigurationInfo, ConfigurationBuilderInfo>(){

        public Object getSerializationValue(Attribute<Supplier<? extends LocalConfigurationStorage>> attribute, ConfigurationInfo configurationElement) {
            Supplier supplier = (Supplier)attribute.get();
            if (supplier == null) {
                return null;
            }
            return ((LocalConfigurationStorage)supplier.get()).getClass().getName();
        }
    }).immutable().build();
    private final ElementDefinition elementDefinition;
    private final ConfigurationStorage storage;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStorageConfiguration.class, new AttributeDefinition[]{CONFIGURATION_STORAGE_SUPPLIER});
    }

    GlobalStorageConfiguration(AttributeSet attributeSet, ConfigurationStorage storage) {
        this.attributes = attributeSet;
        this.storage = storage;
        this.elementDefinition = this.getElementDefinition(storage);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ConfigurationStorage configurationStorage() {
        return this.storage;
    }

    Supplier<? extends LocalConfigurationStorage> storageSupplier() {
        return (Supplier)this.attributes.attribute(CONFIGURATION_STORAGE_SUPPLIER).get();
    }

    public ElementDefinition getElementDefinition() {
        return this.elementDefinition;
    }

    private ElementDefinition getElementDefinition(ConfigurationStorage configurationStorage) {
        switch (configurationStorage) {
            case IMMUTABLE: {
                return new DefaultElementDefinition(Element.IMMUTABLE_CONFIGURATION_STORAGE.getLocalName(), true, false);
            }
            case VOLATILE: {
                return new DefaultElementDefinition(Element.VOLATILE_CONFIGURATION_STORAGE.getLocalName(), true, false);
            }
            case OVERLAY: {
                return new DefaultElementDefinition(Element.OVERLAY_CONFIGURATION_STORAGE.getLocalName(), true, false);
            }
            case MANAGED: {
                return new DefaultElementDefinition(Element.MANAGED_CONFIGURATION_STORAGE.getLocalName(), true, false);
            }
            case CUSTOM: {
                return new DefaultElementDefinition(Element.CUSTOM_CONFIGURATION_STORAGE.getLocalName(), true, false);
            }
        }
        return null;
    }
}

