/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.gossip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuweni.plumtree.Peer;
import org.apache.tuweni.plumtree.PeerRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoggingPeerRepository
implements PeerRepository {
    private static final Logger logger = LoggerFactory.getLogger((String)LoggingPeerRepository.class.getName());
    private final Set<Peer> eagerPushPeers = ConcurrentHashMap.newKeySet();
    private final Set<Peer> lazyPushPeers = ConcurrentHashMap.newKeySet();

    LoggingPeerRepository() {
    }

    public void addEager(Peer peer) {
        this.eagerPushPeers.add(peer);
    }

    public List<Peer> peers() {
        ArrayList<Peer> peers = new ArrayList<Peer>(this.eagerPushPeers);
        peers.addAll(this.lazyPushPeers);
        return peers;
    }

    public Collection<Peer> lazyPushPeers() {
        return this.lazyPushPeers;
    }

    public Collection<Peer> eagerPushPeers() {
        return this.eagerPushPeers;
    }

    public void removePeer(Peer peer) {
        logger.info("Removing peer {}", (Object)peer);
        this.lazyPushPeers.remove(peer);
        this.eagerPushPeers.remove(peer);
    }

    public boolean moveToLazy(Peer peer) {
        logger.info("Move peer to lazy {}", (Object)peer);
        this.eagerPushPeers.remove(peer);
        this.lazyPushPeers.add(peer);
        return true;
    }

    public void moveToEager(Peer peer) {
        logger.info("Move peer to eager {}", (Object)peer);
        this.lazyPushPeers.remove(peer);
        this.eagerPushPeers.add(peer);
    }

    public void considerNewPeer(Peer peer) {
        if (!this.lazyPushPeers.contains(peer) && this.eagerPushPeers.add(peer)) {
            logger.info("Added new peer {}", (Object)peer);
        }
    }
}

