/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.blockprocessor;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.blockprocessor.BlockProcessor;
import org.apache.tuweni.blockprocessor.TransactionProcessor;
import org.apache.tuweni.blockprocessor.TransactionProcessorResult;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.AccountState;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.Log;
import org.apache.tuweni.eth.LogsBloomFilter;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.eth.TransactionReceipt;
import org.apache.tuweni.eth.repository.BlockchainRepository;
import org.apache.tuweni.eth.repository.TransientStateRepository;
import org.apache.tuweni.evm.CallKind;
import org.apache.tuweni.evm.EVMExecutionStatusCode;
import org.apache.tuweni.evm.EVMResult;
import org.apache.tuweni.evm.EthereumVirtualMachine;
import org.apache.tuweni.evm.HardFork;
import org.apache.tuweni.trie.MerkleTrie;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.apache.tuweni.units.ethereum.Gas;
import org.apache.tuweni.units.ethereum.Wei;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005JY\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lorg/apache/tuweni/blockprocessor/TransactionProcessor;", "", "vm", "Lorg/apache/tuweni/evm/EthereumVirtualMachine;", "hardFork", "Lorg/apache/tuweni/evm/HardFork;", "repository", "Lorg/apache/tuweni/eth/repository/BlockchainRepository;", "stateChanges", "Lorg/apache/tuweni/eth/repository/TransientStateRepository;", "(Lorg/apache/tuweni/evm/EthereumVirtualMachine;Lorg/apache/tuweni/evm/HardFork;Lorg/apache/tuweni/eth/repository/BlockchainRepository;Lorg/apache/tuweni/eth/repository/TransientStateRepository;)V", "getHardFork", "()Lorg/apache/tuweni/evm/HardFork;", "getRepository", "()Lorg/apache/tuweni/eth/repository/BlockchainRepository;", "getStateChanges", "()Lorg/apache/tuweni/eth/repository/TransientStateRepository;", "getVm", "()Lorg/apache/tuweni/evm/EthereumVirtualMachine;", "calculateTransactionCost", "Lorg/apache/tuweni/units/ethereum/Gas;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "execute", "Lorg/apache/tuweni/blockprocessor/TransactionProcessorResult;", "tx", "Lorg/apache/tuweni/eth/Transaction;", "timestamp", "Lorg/apache/tuweni/units/bigints/UInt256;", "chainId", "parentBlock", "Lorg/apache/tuweni/eth/BlockHeader;", "gasLimit", "gasUsed", "allGasUsed", "coinbase", "Lorg/apache/tuweni/eth/Address;", "blockBloomFilter", "Lorg/apache/tuweni/eth/LogsBloomFilter;", "(Lorg/apache/tuweni/eth/Transaction;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/BlockHeader;Lorg/apache/tuweni/units/ethereum/Gas;Lorg/apache/tuweni/units/ethereum/Gas;Lorg/apache/tuweni/units/ethereum/Gas;Lorg/apache/tuweni/eth/Address;Lorg/apache/tuweni/eth/LogsBloomFilter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "eth-blockprocessor"})
public final class TransactionProcessor {
    @NotNull
    private final EthereumVirtualMachine vm;
    @NotNull
    private final HardFork hardFork;
    @NotNull
    private final BlockchainRepository repository;
    @NotNull
    private final TransientStateRepository stateChanges;

    public TransactionProcessor(@NotNull EthereumVirtualMachine vm2, @NotNull HardFork hardFork, @NotNull BlockchainRepository repository, @NotNull TransientStateRepository stateChanges) {
        Intrinsics.checkNotNullParameter((Object)vm2, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)hardFork, (String)"hardFork");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)stateChanges, (String)"stateChanges");
        this.vm = vm2;
        this.hardFork = hardFork;
        this.repository = repository;
        this.stateChanges = stateChanges;
    }

    @NotNull
    public final EthereumVirtualMachine getVm() {
        return this.vm;
    }

    @NotNull
    public final HardFork getHardFork() {
        return this.hardFork;
    }

    @NotNull
    public final BlockchainRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final TransientStateRepository getStateChanges() {
        return this.stateChanges;
    }

    @NotNull
    public final Gas calculateTransactionCost(@NotNull Bytes payload, @NotNull HardFork hardFork) {
        Gas gas;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)hardFork, (String)"hardFork");
        int zeros = 0;
        boolean zeroByte = false;
        int n = 0;
        int n2 = payload.size();
        while (n < n2) {
            int i;
            if (payload.get(i = n++) != 0) continue;
            ++zeros;
        }
        int nonZeros = payload.size() - zeros;
        if (hardFork.getNumber() < HardFork.ISTANBUL.getNumber()) {
            UInt256Value uInt256Value = ((Gas)Gas.valueOf((long)21000L).add((UInt256Value)Gas.valueOf((long)(4L * (long)zeros)))).add((UInt256Value)Gas.valueOf((long)(68L * (long)nonZeros)));
            Intrinsics.checkNotNullExpressionValue((Object)uInt256Value, (String)"{\n      Gas.valueOf(2100\u2026Of(68L * nonZeros))\n    }");
            gas = (Gas)uInt256Value;
        } else {
            UInt256Value uInt256Value = ((Gas)Gas.valueOf((long)21000L).add((UInt256Value)Gas.valueOf((long)(4L * (long)zeros)))).add((UInt256Value)Gas.valueOf((long)(16L * (long)nonZeros)));
            Intrinsics.checkNotNullExpressionValue((Object)uInt256Value, (String)"{\n      Gas.valueOf(2100\u2026Of(16L * nonZeros))\n    }");
            gas = (Gas)uInt256Value;
        }
        return gas;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object execute(@NotNull Transaction var1_1, @NotNull UInt256 var2_2, @NotNull UInt256 var3_3, @NotNull BlockHeader var4_4, @NotNull Gas var5_5, @NotNull Gas var6_6, @NotNull Gas var7_7, @NotNull Address var8_8, @NotNull LogsBloomFilter var9_9, @NotNull Continuation<? super TransactionProcessorResult> var10_10) {
        if (!(var10_10 instanceof execute.1)) ** GOTO lbl-1000
        var27_11 = var10_10;
        if ((var27_11.label & -2147483648) != 0) {
            var27_11.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var10_10){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                /* synthetic */ Object result;
                final /* synthetic */ TransactionProcessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, null, null, null, null, null, null, null, (Continuation<? super TransactionProcessorResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var28_13 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                sender = tx.getSender();
                if (sender == null) {
                    return new TransactionProcessorResult(null, false, null, 7, null);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = tx;
                $continuation.L$2 = timestamp;
                $continuation.L$3 = chainId;
                $continuation.L$4 = parentBlock;
                $continuation.L$5 = gasLimit;
                $continuation.L$6 = gasUsed;
                $continuation.L$7 = allGasUsed;
                $continuation.L$8 = coinbase;
                $continuation.L$9 = blockBloomFilter;
                $continuation.L$10 = sender;
                $continuation.label = 1;
                v0 = this.getRepository().getAccount(sender, (Continuation)$continuation);
                if (v0 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl45
            }
            case 1: {
                sender = (Address)$continuation.L$10;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$9;
                coinbase = (Address)$continuation.L$8;
                allGasUsed = (Gas)$continuation.L$7;
                gasUsed = (Gas)$continuation.L$6;
                gasLimit = (Gas)$continuation.L$5;
                parentBlock = (BlockHeader)$continuation.L$4;
                chainId = (UInt256)$continuation.L$3;
                timestamp = (UInt256)$continuation.L$2;
                tx = (Transaction)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl45:
                // 2 sources

                if ((senderAccount = (AccountState)v0) == null || !Hash.hash((Bytes)Bytes.EMPTY).equals((Object)senderAccount.getCodeHash())) {
                    return new TransactionProcessorResult(null, false, null, 7, null);
                }
                if (tx.getGasLimit().compareTo((Bytes)((Gas)gasLimit.subtract((UInt256Value)gasUsed)).subtract((UInt256Value)allGasUsed)) > 0) {
                    return new TransactionProcessorResult(null, false, null, 7, null);
                }
                if (tx.getTo() != null) break;
                contractAddress = Address.fromTransaction((Transaction)tx);
                Intrinsics.checkNotNullExpressionValue((Object)contractAddress, (String)"contractAddress");
                to = contractAddress;
                var17_18 = tx.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)var17_18, (String)"tx.payload");
                code = var17_18;
                var17_18 = Bytes.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)var17_18, (String)"EMPTY");
                inputData = var17_18;
                state = new AccountState(UInt256.ONE, Wei.valueOf((long)0L), Hash.fromBytes((Bytes32)MerkleTrie.Companion.getEMPTY_TRIE_ROOT_HASH()), Hash.hash((Bytes)tx.getPayload()));
                $continuation.L$0 = this;
                $continuation.L$1 = tx;
                $continuation.L$2 = timestamp;
                $continuation.L$3 = chainId;
                $continuation.L$4 = parentBlock;
                $continuation.L$5 = gasUsed;
                $continuation.L$6 = coinbase;
                $continuation.L$7 = blockBloomFilter;
                $continuation.L$8 = sender;
                $continuation.L$9 = code;
                $continuation.L$10 = to;
                $continuation.L$11 = inputData;
                $continuation.label = 2;
                v1 = this.getStateChanges().storeAccount(contractAddress, (AccountState)state, (Continuation)$continuation);
                if (v1 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl92
            }
            case 2: {
                inputData = (Bytes)$continuation.L$11;
                to = (Address)$continuation.L$10;
                code = (Bytes)$continuation.L$9;
                sender = (Address)$continuation.L$8;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$7;
                coinbase = (Address)$continuation.L$6;
                gasUsed = (Gas)$continuation.L$5;
                parentBlock = (BlockHeader)$continuation.L$4;
                chainId = (UInt256)$continuation.L$3;
                timestamp = (UInt256)$continuation.L$2;
                tx = (Transaction)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl92:
                // 2 sources

                v2 = this.getStateChanges();
                var18_21 = tx.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)var18_21, (String)"tx.payload");
                $continuation.L$0 = this;
                $continuation.L$1 = tx;
                $continuation.L$2 = timestamp;
                $continuation.L$3 = chainId;
                $continuation.L$4 = parentBlock;
                $continuation.L$5 = gasUsed;
                $continuation.L$6 = coinbase;
                $continuation.L$7 = blockBloomFilter;
                $continuation.L$8 = sender;
                $continuation.L$9 = code;
                $continuation.L$10 = to;
                $continuation.L$11 = inputData;
                $continuation.label = 3;
                v3 = v2.storeCode(var18_21, (Continuation)$continuation);
                if (v3 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl174
            }
            case 3: {
                inputData = (Bytes)$continuation.L$11;
                to = (Address)$continuation.L$10;
                code = (Bytes)$continuation.L$9;
                sender = (Address)$continuation.L$8;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$7;
                coinbase = (Address)$continuation.L$6;
                gasUsed = (Gas)$continuation.L$5;
                parentBlock = (BlockHeader)$continuation.L$4;
                chainId = (UInt256)$continuation.L$3;
                timestamp = (UInt256)$continuation.L$2;
                tx = (Transaction)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
                ** GOTO lbl174
            }
        }
        v4 = this.getStateChanges();
        v5 = tx.getTo();
        Intrinsics.checkNotNull((Object)v5);
        state = v5;
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"tx.to!!");
        $continuation.L$0 = this;
        $continuation.L$1 = tx;
        $continuation.L$2 = timestamp;
        $continuation.L$3 = chainId;
        $continuation.L$4 = parentBlock;
        $continuation.L$5 = gasUsed;
        $continuation.L$6 = coinbase;
        $continuation.L$7 = blockBloomFilter;
        $continuation.L$8 = sender;
        $continuation.L$9 = null;
        $continuation.L$10 = null;
        $continuation.label = 4;
        v6 = v4.getAccountCode((Address)state, (Continuation)$continuation);
        if (v6 == var28_13) {
            return var28_13;
        }
        ** GOTO lbl161
        {
            case 4: {
                sender = (Address)$continuation.L$8;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$7;
                coinbase = (Address)$continuation.L$6;
                gasUsed = (Gas)$continuation.L$5;
                parentBlock = (BlockHeader)$continuation.L$4;
                chainId = (UInt256)$continuation.L$3;
                timestamp = (UInt256)$continuation.L$2;
                tx = (Transaction)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl161:
                // 2 sources

                if ((v7 = (Bytes)v6) == null) {
                    state = Bytes.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)state, (String)"EMPTY");
                    v7 = state;
                }
                code = v7;
                v8 = tx.getTo();
                Intrinsics.checkNotNull((Object)v8);
                contractAddress = v8;
                Intrinsics.checkNotNullExpressionValue((Object)contractAddress, (String)"tx.to!!");
                to = contractAddress;
                contractAddress = tx.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)contractAddress, (String)"tx.payload");
                inputData = contractAddress;
lbl174:
                // 3 sources

                state = tx.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"tx.payload");
                gasCost = this.calculateTransactionCost(state, this.getHardFork());
                v9 = this.getVm();
                v10 = tx.getSender();
                Intrinsics.checkNotNull((Object)v10);
                var18_21 = v10;
                Intrinsics.checkNotNullExpressionValue((Object)var18_21, (String)"tx.sender!!");
                v11 = var18_21;
                var18_21 = tx.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)var18_21, (String)"tx.value");
                var18_21 = tx.getGasLimit().subtract((UInt256Value)gasCost);
                Intrinsics.checkNotNullExpressionValue((Object)var18_21, (String)"tx.gasLimit.subtract(gasCost)");
                v12 = (Gas)var18_21;
                var18_21 = tx.getGasPrice();
                Intrinsics.checkNotNullExpressionValue((Object)var18_21, (String)"tx.gasPrice");
                v13 = var18_21;
                var18_21 = parentBlock.getNumber().add(1L);
                Intrinsics.checkNotNullExpressionValue((Object)var18_21, (String)"parentBlock.number.add(1)");
                v14 = var18_21;
                v15 = tx.getGasLimit().toLong();
                var18_21 = parentBlock.getDifficulty();
                Intrinsics.checkNotNullExpressionValue((Object)var18_21, (String)"parentBlock.difficulty");
                $continuation.L$0 = this;
                $continuation.L$1 = tx;
                $continuation.L$2 = gasUsed;
                $continuation.L$3 = coinbase;
                $continuation.L$4 = blockBloomFilter;
                $continuation.L$5 = sender;
                $continuation.L$6 = gasCost;
                $continuation.L$7 = null;
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.L$10 = null;
                $continuation.L$11 = null;
                $continuation.label = 5;
                v16 = EthereumVirtualMachine.execute$default((EthereumVirtualMachine)v9, (Address)v11, (Address)to, (Bytes)var18_21, (Bytes)code, (Bytes)inputData, (Gas)v12, (Wei)v13, (Address)coinbase, (UInt256)v14, (UInt256)var2_2, (long)v15, (UInt256)var18_21, (UInt256)var3_3, (CallKind)CallKind.CALL, (HardFork)this.getHardFork(), (int)0, (Continuation)$continuation, (int)32768, null);
                if (v16 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl224
            }
            case 5: {
                gasCost = (Gas)$continuation.L$6;
                sender = (Address)$continuation.L$5;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$4;
                coinbase = (Address)$continuation.L$3;
                gasUsed = (Gas)$continuation.L$2;
                tx = (Transaction)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v16 = $result;
lbl224:
                // 2 sources

                result = (EVMResult)v16;
                result.getState().getGasManager().add(gasCost);
                if (result.getStatusCode() != EVMExecutionStatusCode.SUCCESS) {
                    BlockProcessor.Companion.getLogger().info("EVM execution failed with status " + result.getStatusCode());
                    return new TransactionProcessorResult(null, false, null, 7, null);
                }
                pay = result.getState().getGasManager().getGasCost().priceFor(tx.getGasPrice());
                if (pay.compareTo((Bytes)tx.getGasPrice()) < 0) {
                    return new TransactionProcessorResult(null, false, null, 7, null);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = gasUsed;
                $continuation.L$2 = coinbase;
                $continuation.L$3 = blockBloomFilter;
                $continuation.L$4 = sender;
                $continuation.L$5 = result;
                $continuation.L$6 = pay;
                $continuation.label = 6;
                v17 = this.getRepository().getAccount(sender, (Continuation)$continuation);
                if (v17 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl254
            }
            case 6: {
                pay = (Wei)$continuation.L$6;
                result = (EVMResult)$continuation.L$5;
                sender = (Address)$continuation.L$4;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$3;
                coinbase = (Address)$continuation.L$2;
                gasUsed = (Gas)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v17 = $result;
lbl254:
                // 2 sources

                Intrinsics.checkNotNull((Object)v17);
                senderAccountAfter = (AccountState)v17;
                newSenderAccountState = new AccountState(senderAccountAfter.getNonce().add(1L), (Wei)senderAccountAfter.getBalance().subtract((UInt256Value)pay), senderAccountAfter.getStorageRoot(), senderAccountAfter.getCodeHash());
                $continuation.L$0 = this;
                $continuation.L$1 = gasUsed;
                $continuation.L$2 = coinbase;
                $continuation.L$3 = blockBloomFilter;
                $continuation.L$4 = result;
                $continuation.L$5 = pay;
                $continuation.L$6 = null;
                $continuation.label = 7;
                v18 = this.getStateChanges().storeAccount(sender, newSenderAccountState, (Continuation)$continuation);
                if (v18 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl278
            }
            case 7: {
                pay = (Wei)$continuation.L$5;
                result = (EVMResult)$continuation.L$4;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$3;
                coinbase = (Address)$continuation.L$2;
                gasUsed = (Gas)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v18 = $result;
lbl278:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = gasUsed;
                $continuation.L$2 = coinbase;
                $continuation.L$3 = blockBloomFilter;
                $continuation.L$4 = result;
                $continuation.L$5 = pay;
                $continuation.label = 8;
                v19 = this.getStateChanges().getAccount(coinbase, (Continuation)$continuation);
                if (v19 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl298
            }
            case 8: {
                pay = (Wei)$continuation.L$5;
                result = (EVMResult)$continuation.L$4;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$3;
                coinbase = (Address)$continuation.L$2;
                gasUsed = (Gas)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v19 = $result;
lbl298:
                // 2 sources

                if ((v20 = (AccountState)v19) == null) {
                    v20 = this.getStateChanges().newAccountState();
                }
                coinbaseAccountState = v20;
                newCoinbaseAccountState = new AccountState(coinbaseAccountState.getNonce(), (Wei)coinbaseAccountState.getBalance().add((UInt256Value)pay), coinbaseAccountState.getStorageRoot(), coinbaseAccountState.getCodeHash());
                $continuation.L$0 = this;
                $continuation.L$1 = gasUsed;
                $continuation.L$2 = blockBloomFilter;
                $continuation.L$3 = result;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.label = 9;
                v21 = this.getStateChanges().storeAccount(coinbase, newCoinbaseAccountState, (Continuation)$continuation);
                if (v21 == var28_13) {
                    return var28_13;
                }
                ** GOTO lbl320
            }
            case 9: {
                result = (EVMResult)$continuation.L$3;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$2;
                gasUsed = (Gas)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v21 = $result;
lbl320:
                // 2 sources

                var23_26 = result.getChanges().accountsToDestroy().iterator();
lbl321:
                // 3 sources

                while (var23_26.hasNext()) {
                    accountToDestroy = (Address)var23_26.next();
                    $continuation.L$0 = this;
                    $continuation.L$1 = gasUsed;
                    $continuation.L$2 = blockBloomFilter;
                    $continuation.L$3 = result;
                    $continuation.L$4 = var23_26;
                    $continuation.label = 10;
                    v22 = this.getStateChanges().destroyAccount(accountToDestroy, (Continuation)$continuation);
                    if (v22 != var28_13) continue;
                    return var28_13;
                }
                break;
            }
            case 10: {
                var23_26 = (Iterator<E>)$continuation.L$4;
                result = (EVMResult)$continuation.L$3;
                blockBloomFilter = (LogsBloomFilter)$continuation.L$2;
                gasUsed = (Gas)$continuation.L$1;
                this = (TransactionProcessor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v22 = $result;
                ** GOTO lbl321
            }
        }
        txLogsBloomFilter = new LogsBloomFilter();
        for (Log log : result.getChanges().getLogs()) {
            blockBloomFilter.insertLog(log);
            txLogsBloomFilter.insertLog(log);
        }
        receipt = new TransactionReceipt(1, result.getState().getGasManager().getGasCost().toLong(), txLogsBloomFilter, result.getChanges().getLogs());
        return new TransactionProcessorResult(receipt, true, gasUsed);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

