/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.blockprocessor;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt64;
import org.apache.tuweni.units.ethereum.Gas;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003JY\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J>\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204J\t\u00105\u001a\u000206H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u00067"}, d2={"Lorg/apache/tuweni/blockprocessor/SealableHeader;", "", "parentHash", "Lorg/apache/tuweni/eth/Hash;", "stateRoot", "transactionsRoot", "receiptsRoot", "logsBloom", "Lorg/apache/tuweni/bytes/Bytes;", "number", "Lorg/apache/tuweni/units/bigints/UInt256;", "gasLimit", "Lorg/apache/tuweni/units/ethereum/Gas;", "gasUsed", "(Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/ethereum/Gas;Lorg/apache/tuweni/units/ethereum/Gas;)V", "getGasLimit", "()Lorg/apache/tuweni/units/ethereum/Gas;", "getGasUsed", "getLogsBloom", "()Lorg/apache/tuweni/bytes/Bytes;", "getNumber", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getParentHash", "()Lorg/apache/tuweni/eth/Hash;", "getReceiptsRoot", "getStateRoot", "getTransactionsRoot", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toHeader", "Lorg/apache/tuweni/eth/BlockHeader;", "ommersHash", "coinbase", "Lorg/apache/tuweni/eth/Address;", "difficulty", "timestamp", "Ljava/time/Instant;", "extraData", "mixHash", "nonce", "Lorg/apache/tuweni/units/bigints/UInt64;", "toString", "", "eth-blockprocessor"})
public final class SealableHeader {
    @NotNull
    private final Hash parentHash;
    @NotNull
    private final Hash stateRoot;
    @NotNull
    private final Hash transactionsRoot;
    @NotNull
    private final Hash receiptsRoot;
    @NotNull
    private final Bytes logsBloom;
    @NotNull
    private final UInt256 number;
    @NotNull
    private final Gas gasLimit;
    @NotNull
    private final Gas gasUsed;

    public SealableHeader(@NotNull Hash parentHash, @NotNull Hash stateRoot, @NotNull Hash transactionsRoot, @NotNull Hash receiptsRoot, @NotNull Bytes logsBloom, @NotNull UInt256 number, @NotNull Gas gasLimit, @NotNull Gas gasUsed) {
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter((Object)stateRoot, (String)"stateRoot");
        Intrinsics.checkNotNullParameter((Object)transactionsRoot, (String)"transactionsRoot");
        Intrinsics.checkNotNullParameter((Object)receiptsRoot, (String)"receiptsRoot");
        Intrinsics.checkNotNullParameter((Object)logsBloom, (String)"logsBloom");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)gasLimit, (String)"gasLimit");
        Intrinsics.checkNotNullParameter((Object)gasUsed, (String)"gasUsed");
        this.parentHash = parentHash;
        this.stateRoot = stateRoot;
        this.transactionsRoot = transactionsRoot;
        this.receiptsRoot = receiptsRoot;
        this.logsBloom = logsBloom;
        this.number = number;
        this.gasLimit = gasLimit;
        this.gasUsed = gasUsed;
    }

    @NotNull
    public final Hash getParentHash() {
        return this.parentHash;
    }

    @NotNull
    public final Hash getStateRoot() {
        return this.stateRoot;
    }

    @NotNull
    public final Hash getTransactionsRoot() {
        return this.transactionsRoot;
    }

    @NotNull
    public final Hash getReceiptsRoot() {
        return this.receiptsRoot;
    }

    @NotNull
    public final Bytes getLogsBloom() {
        return this.logsBloom;
    }

    @NotNull
    public final UInt256 getNumber() {
        return this.number;
    }

    @NotNull
    public final Gas getGasLimit() {
        return this.gasLimit;
    }

    @NotNull
    public final Gas getGasUsed() {
        return this.gasUsed;
    }

    @NotNull
    public final BlockHeader toHeader(@NotNull Hash ommersHash, @NotNull Address coinbase, @NotNull UInt256 difficulty, @NotNull Instant timestamp, @NotNull Bytes extraData, @NotNull Hash mixHash, @NotNull UInt64 nonce) {
        Intrinsics.checkNotNullParameter((Object)ommersHash, (String)"ommersHash");
        Intrinsics.checkNotNullParameter((Object)coinbase, (String)"coinbase");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        Intrinsics.checkNotNullParameter((Object)mixHash, (String)"mixHash");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        return new BlockHeader(this.parentHash, ommersHash, coinbase, this.stateRoot, this.transactionsRoot, this.receiptsRoot, this.logsBloom, difficulty, this.number, this.gasLimit, this.gasUsed, timestamp, extraData, mixHash, nonce);
    }

    @NotNull
    public final Hash component1() {
        return this.parentHash;
    }

    @NotNull
    public final Hash component2() {
        return this.stateRoot;
    }

    @NotNull
    public final Hash component3() {
        return this.transactionsRoot;
    }

    @NotNull
    public final Hash component4() {
        return this.receiptsRoot;
    }

    @NotNull
    public final Bytes component5() {
        return this.logsBloom;
    }

    @NotNull
    public final UInt256 component6() {
        return this.number;
    }

    @NotNull
    public final Gas component7() {
        return this.gasLimit;
    }

    @NotNull
    public final Gas component8() {
        return this.gasUsed;
    }

    @NotNull
    public final SealableHeader copy(@NotNull Hash parentHash, @NotNull Hash stateRoot, @NotNull Hash transactionsRoot, @NotNull Hash receiptsRoot, @NotNull Bytes logsBloom, @NotNull UInt256 number, @NotNull Gas gasLimit, @NotNull Gas gasUsed) {
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter((Object)stateRoot, (String)"stateRoot");
        Intrinsics.checkNotNullParameter((Object)transactionsRoot, (String)"transactionsRoot");
        Intrinsics.checkNotNullParameter((Object)receiptsRoot, (String)"receiptsRoot");
        Intrinsics.checkNotNullParameter((Object)logsBloom, (String)"logsBloom");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)gasLimit, (String)"gasLimit");
        Intrinsics.checkNotNullParameter((Object)gasUsed, (String)"gasUsed");
        return new SealableHeader(parentHash, stateRoot, transactionsRoot, receiptsRoot, logsBloom, number, gasLimit, gasUsed);
    }

    public static /* synthetic */ SealableHeader copy$default(SealableHeader sealableHeader, Hash hash, Hash hash2, Hash hash3, Hash hash4, Bytes bytes, UInt256 uInt256, Gas gas, Gas gas2, int n, Object object) {
        if ((n & 1) != 0) {
            hash = sealableHeader.parentHash;
        }
        if ((n & 2) != 0) {
            hash2 = sealableHeader.stateRoot;
        }
        if ((n & 4) != 0) {
            hash3 = sealableHeader.transactionsRoot;
        }
        if ((n & 8) != 0) {
            hash4 = sealableHeader.receiptsRoot;
        }
        if ((n & 0x10) != 0) {
            bytes = sealableHeader.logsBloom;
        }
        if ((n & 0x20) != 0) {
            uInt256 = sealableHeader.number;
        }
        if ((n & 0x40) != 0) {
            gas = sealableHeader.gasLimit;
        }
        if ((n & 0x80) != 0) {
            gas2 = sealableHeader.gasUsed;
        }
        return sealableHeader.copy(hash, hash2, hash3, hash4, bytes, uInt256, gas, gas2);
    }

    @NotNull
    public String toString() {
        return "SealableHeader(parentHash=" + this.parentHash + ", stateRoot=" + this.stateRoot + ", transactionsRoot=" + this.transactionsRoot + ", receiptsRoot=" + this.receiptsRoot + ", logsBloom=" + this.logsBloom + ", number=" + this.number + ", gasLimit=" + this.gasLimit + ", gasUsed=" + this.gasUsed + ")";
    }

    public int hashCode() {
        int result = this.parentHash.hashCode();
        result = result * 31 + this.stateRoot.hashCode();
        result = result * 31 + this.transactionsRoot.hashCode();
        result = result * 31 + this.receiptsRoot.hashCode();
        result = result * 31 + this.logsBloom.hashCode();
        result = result * 31 + this.number.hashCode();
        result = result * 31 + this.gasLimit.hashCode();
        result = result * 31 + this.gasUsed.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SealableHeader)) {
            return false;
        }
        SealableHeader sealableHeader = (SealableHeader)other;
        if (!Intrinsics.areEqual((Object)this.parentHash, (Object)sealableHeader.parentHash)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stateRoot, (Object)sealableHeader.stateRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transactionsRoot, (Object)sealableHeader.transactionsRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.receiptsRoot, (Object)sealableHeader.receiptsRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logsBloom, (Object)sealableHeader.logsBloom)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.number, (Object)sealableHeader.number)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasLimit, (Object)sealableHeader.gasLimit)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.gasUsed, (Object)sealableHeader.gasUsed);
    }
}

