/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.precompiles;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.eth.precompiles.PrecompileContract;
import org.apache.tuweni.eth.precompiles.Result;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/eth/precompiles/ECRECPrecompiledContract;", "Lorg/apache/tuweni/eth/precompiles/PrecompileContract;", "()V", "run", "Lorg/apache/tuweni/eth/precompiles/Result;", "input", "Lorg/apache/tuweni/bytes/Bytes;", "eth-precompiles"})
public final class ECRECPrecompiledContract
implements PrecompileContract {
    @Override
    @NotNull
    public Result run(@NotNull Bytes input) {
        Bytes bytes;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input.size() < 128) {
            Bytes[] bytesArray = new Bytes[]{Bytes.repeat((byte)0, (int)(128 - input.size())), input};
            bytes = Bytes.wrap((Bytes[])bytesArray);
        } else {
            bytes = input;
        }
        Bytes padded = bytes;
        Bytes32 h = Bytes32.wrap((Bytes)padded.slice(0, 32));
        Bytes v = padded.slice(32, 32);
        Bytes r = padded.slice(64, 32);
        Bytes s = padded.slice(96, 32);
        if (v.numberOfLeadingZeroBytes() != 31) {
            return new Result(3000L, Bytes.EMPTY);
        }
        try {
            SECP256K1.Signature signature = SECP256K1.Signature.create((byte)v.get(31), (BigInteger)r.toUnsignedBigInteger(), (BigInteger)s.toUnsignedBigInteger());
            SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.recoverFromHashAndSignature((Bytes32)h, (SECP256K1.Signature)signature);
            if (publicKey == null) {
                return new Result(3000L, Bytes.EMPTY);
            }
            SECP256K1.PublicKey pkey = publicKey;
            Bytes32 bytes32 = Hash.keccak256((Bytes)pkey.bytes());
            Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"keccak256(pkey.bytes())");
            Bytes32 hashed = bytes32;
            return new Result(3000L, (Bytes)Bytes32.leftPad((Bytes)hashed.slice(12)));
        }
        catch (IllegalArgumentException e) {
            return new Result(3000L, Bytes.EMPTY);
        }
    }
}

