/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.precompiles;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.eth.precompiles.PrecompileContract;
import org.apache.tuweni.eth.precompiles.Result;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/eth/precompiles/Blake2BFPrecompileContract;", "Lorg/apache/tuweni/eth/precompiles/PrecompileContract;", "()V", "run", "Lorg/apache/tuweni/eth/precompiles/Result;", "input", "Lorg/apache/tuweni/bytes/Bytes;", "eth-precompiles"})
public final class Blake2BFPrecompileContract
implements PrecompileContract {
    @Override
    @NotNull
    public Result run(@NotNull Bytes input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (input.size() != 213) {
            return new Result(0L, Bytes.EMPTY);
        }
        if ((byte)(input.get(212) & 0xFFFFFFFE) != 0) {
            return new Result(0L, Bytes.EMPTY);
        }
        Bytes[] bytesArray = new Bytes[]{Bytes.repeat((byte)0, (int)4), input.slice(0, 4)};
        Bytes rounds = Bytes.wrap((Bytes[])bytesArray);
        return new Result(rounds.toLong(), Hash.digestUsingAlgorithm((Bytes)input, (String)"BLAKE2BF"));
    }
}

