/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;

public final class Log {
    private final Address logger;
    private final Bytes data;
    private final List<Bytes32> topics;

    public static Log readFrom(RLPReader in) {
        return (Log)in.readList(reader -> {
            Address logger = Address.fromBytes(reader.readValue());
            List topics = reader.readListContents(topicsReader -> Bytes32.wrap((Bytes)topicsReader.readValue()));
            Bytes data = reader.readValue();
            return new Log(logger, data, topics);
        });
    }

    public Log(Address logger, Bytes data, List<Bytes32> topics) {
        this.logger = logger;
        this.data = data;
        this.topics = topics;
    }

    public void writeTo(RLPWriter writer) {
        writer.writeList(out -> {
            out.writeValue((Bytes)this.logger);
            out.writeList(topicsWriter -> {
                for (Bytes32 topic : this.topics) {
                    topicsWriter.writeValue((Bytes)topic);
                }
            });
            out.writeValue(this.data);
        });
    }

    public Bytes toBytes() {
        return RLP.encode(this::writeTo);
    }

    public Address getLogger() {
        return this.logger;
    }

    public Bytes getData() {
        return this.data;
    }

    public List<Bytes32> getTopics() {
        return this.topics;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Log)) {
            return false;
        }
        Log that = (Log)other;
        return this.data.equals(that.data) && this.logger.equals((Object)that.logger) && this.topics.equals(that.topics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.logger, this.topics});
    }

    public String toString() {
        return "Log{logger=" + this.logger + ", data=" + this.data + ", topics=" + this.topics + "}";
    }
}

