/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import com.fasterxml.jackson.annotation.JsonGetter;
import java.time.Instant;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt64;
import org.apache.tuweni.units.ethereum.Gas;
import org.jetbrains.annotations.Nullable;

public final class BlockHeader {
    @Nullable
    private final Hash parentHash;
    private final Hash ommersHash;
    private final Address coinbase;
    private final Hash stateRoot;
    private final Hash transactionsRoot;
    private final Hash receiptsRoot;
    private final Bytes logsBloom;
    private final UInt256 difficulty;
    private final UInt256 number;
    private final Gas gasLimit;
    private final Gas gasUsed;
    private final Instant timestamp;
    private final Bytes extraData;
    private final Hash mixHash;
    private final UInt64 nonce;
    private Hash hash;

    public static BlockHeader fromBytes(Bytes encoded) {
        Objects.requireNonNull(encoded);
        return (BlockHeader)RLP.decodeList((Bytes)encoded, BlockHeader::readFrom);
    }

    public static BlockHeader readFrom(RLPReader reader) {
        Bytes parentHashBytes = reader.readValue();
        return new BlockHeader(parentHashBytes.isEmpty() ? null : Hash.fromBytes(parentHashBytes), Hash.fromBytes(reader.readValue()), Address.fromBytes(reader.readValue()), Hash.fromBytes(reader.readValue()), Hash.fromBytes(reader.readValue()), Hash.fromBytes(reader.readValue()), reader.readValue(), UInt256.fromBytes((Bytes)reader.readValue()), UInt256.fromBytes((Bytes)reader.readValue()), Gas.valueOf((UInt256)reader.readUInt256()), Gas.valueOf((UInt256)reader.readUInt256()), Instant.ofEpochSecond(reader.readLong()), reader.readValue(), Hash.fromBytes(reader.readValue()), UInt64.fromBytes((Bytes)reader.readValue()));
    }

    public BlockHeader(@Nullable Hash parentHash, Hash ommersHash, Address coinbase, Hash stateRoot, Hash transactionsRoot, Hash receiptsRoot, Bytes logsBloom, UInt256 difficulty, UInt256 number, Gas gasLimit, Gas gasUsed, Instant timestamp, Bytes extraData, Hash mixHash, UInt64 nonce) {
        Objects.requireNonNull(ommersHash);
        Objects.requireNonNull(coinbase);
        Objects.requireNonNull(stateRoot);
        Objects.requireNonNull(transactionsRoot);
        Objects.requireNonNull(receiptsRoot);
        Objects.requireNonNull(logsBloom);
        Objects.requireNonNull(difficulty);
        Objects.requireNonNull(number);
        Objects.requireNonNull(gasLimit);
        Objects.requireNonNull(gasUsed);
        Objects.requireNonNull(timestamp);
        Objects.requireNonNull(extraData);
        Objects.requireNonNull(mixHash);
        Objects.requireNonNull(nonce);
        this.parentHash = parentHash;
        this.ommersHash = ommersHash;
        this.coinbase = coinbase;
        this.stateRoot = stateRoot;
        this.transactionsRoot = transactionsRoot;
        this.receiptsRoot = receiptsRoot;
        this.logsBloom = logsBloom;
        this.difficulty = difficulty;
        this.number = number;
        this.gasLimit = gasLimit;
        this.gasUsed = gasUsed;
        this.timestamp = timestamp;
        this.extraData = extraData;
        this.mixHash = mixHash;
        this.nonce = nonce;
    }

    @JsonGetter(value="miner")
    public Address getCoinbase() {
        return this.coinbase;
    }

    @JsonGetter(value="difficulty")
    public UInt256 getDifficulty() {
        return this.difficulty;
    }

    @JsonGetter(value="extraData")
    public Bytes getExtraData() {
        return this.extraData;
    }

    @JsonGetter(value="gasLimit")
    public Gas getGasLimit() {
        return this.gasLimit;
    }

    @JsonGetter(value="gasUsed")
    public Gas getGasUsed() {
        return this.gasUsed;
    }

    @JsonGetter(value="hash")
    public Hash getHash() {
        if (this.hash == null) {
            Bytes rlp = this.toBytes();
            this.hash = Hash.hash(rlp);
        }
        return this.hash;
    }

    @JsonGetter(value="logsBloom")
    public Bytes getLogsBloom() {
        return this.logsBloom;
    }

    @JsonGetter(value="mixHash")
    public Hash getMixHash() {
        return this.mixHash;
    }

    @JsonGetter(value="nonce")
    public UInt64 getNonce() {
        return this.nonce;
    }

    @JsonGetter(value="number")
    public UInt256 getNumber() {
        return this.number;
    }

    @JsonGetter(value="sha3Uncles")
    public Hash getOmmersHash() {
        return this.ommersHash;
    }

    @JsonGetter(value="parentHash")
    @Nullable
    public Hash getParentHash() {
        return this.parentHash;
    }

    @JsonGetter(value="receiptsRoot")
    public Hash getReceiptsRoot() {
        return this.receiptsRoot;
    }

    @JsonGetter(value="stateRoot")
    public Hash getStateRoot() {
        return this.stateRoot;
    }

    @JsonGetter(value="timestamp")
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonGetter(value="transactionsRoot")
    public Hash getTransactionsRoot() {
        return this.transactionsRoot;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockHeader)) {
            return false;
        }
        BlockHeader other = (BlockHeader)obj;
        return Objects.equals((Object)this.parentHash, (Object)other.parentHash) && this.ommersHash.equals((Object)other.ommersHash) && this.coinbase.equals((Object)other.coinbase) && this.stateRoot.equals((Object)other.stateRoot) && this.transactionsRoot.equals((Object)other.transactionsRoot) && this.receiptsRoot.equals((Object)other.receiptsRoot) && this.logsBloom.equals(other.logsBloom) && this.difficulty.equals((Object)other.difficulty) && this.number.equals((Object)other.number) && this.gasLimit.equals((Object)other.gasLimit) && this.gasUsed.equals((Object)other.gasUsed) && this.timestamp.equals(other.timestamp) && this.extraData.equals(other.extraData) && this.mixHash.equals((Object)other.mixHash) && this.nonce.equals((Object)other.nonce);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parentHash, this.ommersHash, this.coinbase, this.stateRoot, this.transactionsRoot, this.receiptsRoot, this.logsBloom, this.difficulty, this.number, this.gasLimit, this.gasUsed, this.timestamp, this.extraData, this.mixHash, this.nonce});
    }

    public String toString() {
        return "BlockHeader{parentHash=" + this.parentHash + ", ommersHash=" + this.ommersHash + ", coinbase=" + this.coinbase + ", stateRoot=" + this.stateRoot + ", transactionsRoot=" + this.transactionsRoot + ", receiptsRoot=" + this.receiptsRoot + ", logsBloom=" + this.logsBloom + ", difficulty=" + this.difficulty + ", number=" + this.number + ", gasLimit=" + this.gasLimit + ", gasUsed=" + this.gasUsed + ", timestamp=" + this.timestamp + ", extraData=" + this.extraData + ", mixHash=" + this.mixHash + ", nonce=" + this.nonce + "}";
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::writeTo);
    }

    void writeTo(RLPWriter writer) {
        writer.writeValue((Bytes)(this.parentHash != null ? this.parentHash : Bytes32.wrap((byte[])new byte[32])));
        writer.writeValue((Bytes)this.ommersHash);
        writer.writeValue((Bytes)this.coinbase);
        writer.writeValue((Bytes)this.stateRoot);
        writer.writeValue((Bytes)this.transactionsRoot);
        writer.writeValue((Bytes)this.receiptsRoot);
        writer.writeValue(this.logsBloom);
        writer.writeValue(this.difficulty.toMinimalBytes());
        writer.writeValue(this.number.toMinimalBytes());
        writer.writeValue(this.gasLimit.toMinimalBytes());
        writer.writeValue(this.gasUsed.toMinimalBytes());
        writer.writeLong(this.timestamp.getEpochSecond());
        writer.writeValue(this.extraData);
        writer.writeValue((Bytes)this.mixHash);
        writer.writeValue(this.nonce.toBytes());
    }
}

