/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import java.util.Enumeration;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Streams {
    private Streams() {
    }

    public static <T> Stream<T> enumerationStream(final Enumeration<T> enumeration) {
        Objects.requireNonNull(enumeration);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (enumeration.hasMoreElements()) {
                    action.accept(enumeration.nextElement());
                    return true;
                }
                return false;
            }
        }, false);
    }
}

